// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model

import aws.smithy.kotlin.runtime.time.Instant

public class GetCustomDataIdentifierResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the custom data identifier.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The date and time, in UTC and extended ISO 8601 format, when the custom data identifier was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * Specifies whether the custom data identifier was deleted. If you delete a custom data identifier, Amazon Macie doesn't delete it permanently. Instead, it soft deletes the identifier.
     */
    public val deleted: kotlin.Boolean = builder.deleted
    /**
     * The custom description of the custom data identifier.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The unique identifier for the custom data identifier.
     */
    public val id: kotlin.String? = builder.id
    /**
     * An array that lists specific character sequences (*ignore words*) to exclude from the results. If the text matched by the regular expression contains any string in this array, Amazon Macie ignores it. Ignore words are case sensitive.
     */
    public val ignoreWords: List<String>? = builder.ignoreWords
    /**
     * An array that lists specific character sequences (*keywords*), one of which must precede and be within proximity (maximumMatchDistance) of the regular expression to match. Keywords aren't case sensitive.
     */
    public val keywords: List<String>? = builder.keywords
    /**
     * The maximum number of characters that can exist between the end of at least one complete character sequence specified by the keywords array and the end of the text that matches the regex pattern. If a complete keyword precedes all the text that matches the pattern and the keyword is within the specified distance, Amazon Macie includes the result. Otherwise, Macie excludes the result.
     */
    public val maximumMatchDistance: kotlin.Int = builder.maximumMatchDistance
    /**
     * The custom name of the custom data identifier.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The regular expression (*regex*) that defines the pattern to match.
     */
    public val regex: kotlin.String? = builder.regex
    /**
     * Specifies the severity that's assigned to findings that the custom data identifier produces, based on the number of occurrences of text that matches the custom data identifier's detection criteria. By default, Amazon Macie creates findings for S3 objects that contain at least one occurrence of text that matches the detection criteria, and Macie assigns the MEDIUM severity to those findings.
     */
    public val severityLevels: List<SeverityLevel>? = builder.severityLevels
    /**
     * A map of key-value pairs that identifies the tags (keys and values) that are associated with the custom data identifier.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.GetCustomDataIdentifierResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetCustomDataIdentifierResponse(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("deleted=$deleted,")
        append("description=$description,")
        append("id=$id,")
        append("ignoreWords=$ignoreWords,")
        append("keywords=$keywords,")
        append("maximumMatchDistance=$maximumMatchDistance,")
        append("name=$name,")
        append("regex=$regex,")
        append("severityLevels=$severityLevels,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (deleted.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (ignoreWords?.hashCode() ?: 0)
        result = 31 * result + (keywords?.hashCode() ?: 0)
        result = 31 * result + (maximumMatchDistance)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (regex?.hashCode() ?: 0)
        result = 31 * result + (severityLevels?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetCustomDataIdentifierResponse

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (deleted != other.deleted) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (ignoreWords != other.ignoreWords) return false
        if (keywords != other.keywords) return false
        if (maximumMatchDistance != other.maximumMatchDistance) return false
        if (name != other.name) return false
        if (regex != other.regex) return false
        if (severityLevels != other.severityLevels) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.GetCustomDataIdentifierResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the custom data identifier.
         */
        public var arn: kotlin.String? = null
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the custom data identifier was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies whether the custom data identifier was deleted. If you delete a custom data identifier, Amazon Macie doesn't delete it permanently. Instead, it soft deletes the identifier.
         */
        public var deleted: kotlin.Boolean = false
        /**
         * The custom description of the custom data identifier.
         */
        public var description: kotlin.String? = null
        /**
         * The unique identifier for the custom data identifier.
         */
        public var id: kotlin.String? = null
        /**
         * An array that lists specific character sequences (*ignore words*) to exclude from the results. If the text matched by the regular expression contains any string in this array, Amazon Macie ignores it. Ignore words are case sensitive.
         */
        public var ignoreWords: List<String>? = null
        /**
         * An array that lists specific character sequences (*keywords*), one of which must precede and be within proximity (maximumMatchDistance) of the regular expression to match. Keywords aren't case sensitive.
         */
        public var keywords: List<String>? = null
        /**
         * The maximum number of characters that can exist between the end of at least one complete character sequence specified by the keywords array and the end of the text that matches the regex pattern. If a complete keyword precedes all the text that matches the pattern and the keyword is within the specified distance, Amazon Macie includes the result. Otherwise, Macie excludes the result.
         */
        public var maximumMatchDistance: kotlin.Int = 0
        /**
         * The custom name of the custom data identifier.
         */
        public var name: kotlin.String? = null
        /**
         * The regular expression (*regex*) that defines the pattern to match.
         */
        public var regex: kotlin.String? = null
        /**
         * Specifies the severity that's assigned to findings that the custom data identifier produces, based on the number of occurrences of text that matches the custom data identifier's detection criteria. By default, Amazon Macie creates findings for S3 objects that contain at least one occurrence of text that matches the detection criteria, and Macie assigns the MEDIUM severity to those findings.
         */
        public var severityLevels: List<SeverityLevel>? = null
        /**
         * A map of key-value pairs that identifies the tags (keys and values) that are associated with the custom data identifier.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.GetCustomDataIdentifierResponse) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.deleted = x.deleted
            this.description = x.description
            this.id = x.id
            this.ignoreWords = x.ignoreWords
            this.keywords = x.keywords
            this.maximumMatchDistance = x.maximumMatchDistance
            this.name = x.name
            this.regex = x.regex
            this.severityLevels = x.severityLevels
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.GetCustomDataIdentifierResponse = GetCustomDataIdentifierResponse(this)
    }
}
