// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about an Identity and Access Management (IAM) user who performed an action on an affected resource.
 */
public class IamUser private constructor(builder: Builder) {
    /**
     * The unique identifier for the Amazon Web Services account that's associated with the IAM user who performed the action.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The Amazon Resource Name (ARN) of the principal that performed the action. The last section of the ARN contains the name of the user who performed the action.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The unique identifier for the IAM user who performed the action.
     */
    public val principalId: kotlin.String? = builder.principalId
    /**
     * The user name of the IAM user who performed the action.
     */
    public val userName: kotlin.String? = builder.userName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.IamUser = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IamUser(")
        append("accountId=$accountId,")
        append("arn=$arn,")
        append("principalId=$principalId,")
        append("userName=$userName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (principalId?.hashCode() ?: 0)
        result = 31 * result + (userName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IamUser

        if (accountId != other.accountId) return false
        if (arn != other.arn) return false
        if (principalId != other.principalId) return false
        if (userName != other.userName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.IamUser = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique identifier for the Amazon Web Services account that's associated with the IAM user who performed the action.
         */
        public var accountId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the principal that performed the action. The last section of the ARN contains the name of the user who performed the action.
         */
        public var arn: kotlin.String? = null
        /**
         * The unique identifier for the IAM user who performed the action.
         */
        public var principalId: kotlin.String? = null
        /**
         * The user name of the IAM user who performed the action.
         */
        public var userName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.IamUser) : this() {
            this.accountId = x.accountId
            this.arn = x.arn
            this.principalId = x.principalId
            this.userName = x.userName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.IamUser = IamUser(this)
    }
}
