// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information about an Amazon Macie membership invitation.
 */
public class Invitation private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID for the account that sent the invitation.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The unique identifier for the invitation.
     */
    public val invitationId: kotlin.String? = builder.invitationId
    /**
     * The date and time, in UTC and extended ISO 8601 format, when the invitation was sent.
     */
    public val invitedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.invitedAt
    /**
     * The status of the relationship between the account that sent the invitation and the account that received the invitation.
     */
    public val relationshipStatus: aws.sdk.kotlin.services.macie2.model.RelationshipStatus? = builder.relationshipStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.Invitation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Invitation(")
        append("accountId=$accountId,")
        append("invitationId=$invitationId,")
        append("invitedAt=$invitedAt,")
        append("relationshipStatus=$relationshipStatus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (invitationId?.hashCode() ?: 0)
        result = 31 * result + (invitedAt?.hashCode() ?: 0)
        result = 31 * result + (relationshipStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Invitation

        if (accountId != other.accountId) return false
        if (invitationId != other.invitationId) return false
        if (invitedAt != other.invitedAt) return false
        if (relationshipStatus != other.relationshipStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.Invitation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Web Services account ID for the account that sent the invitation.
         */
        public var accountId: kotlin.String? = null
        /**
         * The unique identifier for the invitation.
         */
        public var invitationId: kotlin.String? = null
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the invitation was sent.
         */
        public var invitedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the relationship between the account that sent the invitation and the account that received the invitation.
         */
        public var relationshipStatus: aws.sdk.kotlin.services.macie2.model.RelationshipStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.Invitation) : this() {
            this.accountId = x.accountId
            this.invitationId = x.invitationId
            this.invitedAt = x.invitedAt
            this.relationshipStatus = x.relationshipStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.Invitation = Invitation(this)
    }
}
