// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Specifies whether any one-time or recurring classification jobs are configured to analyze data in an S3 bucket, and, if so, the details of the job that ran most recently.
 */
public class JobDetails private constructor(builder: Builder) {
    /**
     * Specifies whether any one-time or recurring jobs are configured to analyze data in the bucket. Possible values are:
     * + TRUE - The bucket is explicitly included in the bucket definition (S3BucketDefinitionForJob) for one or more jobs and at least one of those jobs has a status other than CANCELLED. Or the bucket matched the bucket criteria (S3BucketCriteriaForJob) for at least one job that previously ran.
     * + FALSE - The bucket isn't explicitly included in the bucket definition (S3BucketDefinitionForJob) for any jobs, all the jobs that explicitly include the bucket in their bucket definitions have a status of CANCELLED, or the bucket didn't match the bucket criteria (S3BucketCriteriaForJob) for any jobs that previously ran.
     * + UNKNOWN - An exception occurred when Amazon Macie attempted to retrieve job data for the bucket.
     */
    public val isDefinedInJob: aws.sdk.kotlin.services.macie2.model.IsDefinedInJob? = builder.isDefinedInJob
    /**
     * Specifies whether any recurring jobs are configured to analyze data in the bucket. Possible values are:
     * + TRUE - The bucket is explicitly included in the bucket definition (S3BucketDefinitionForJob) for one or more recurring jobs or the bucket matches the bucket criteria (S3BucketCriteriaForJob) for one or more recurring jobs. At least one of those jobs has a status other than CANCELLED.
     * + FALSE - The bucket isn't explicitly included in the bucket definition (S3BucketDefinitionForJob) for any recurring jobs, the bucket doesn't match the bucket criteria (S3BucketCriteriaForJob) for any recurring jobs, or all the recurring jobs that are configured to analyze data in the bucket have a status of CANCELLED.
     * + UNKNOWN - An exception occurred when Amazon Macie attempted to retrieve job data for the bucket.
     */
    public val isMonitoredByJob: aws.sdk.kotlin.services.macie2.model.IsMonitoredByJob? = builder.isMonitoredByJob
    /**
     * The unique identifier for the job that ran most recently and is configured to analyze data in the bucket, either the latest run of a recurring job or the only run of a one-time job.
     *
     * This value is typically null if the value for the isDefinedInJob property is FALSE or UNKNOWN.
     */
    public val lastJobId: kotlin.String? = builder.lastJobId
    /**
     * The date and time, in UTC and extended ISO 8601 format, when the job (lastJobId) started. If the job is a recurring job, this value indicates when the most recent run started.
     *
     * This value is typically null if the value for the isDefinedInJob property is FALSE or UNKNOWN.
     */
    public val lastJobRunTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastJobRunTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.JobDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobDetails(")
        append("isDefinedInJob=$isDefinedInJob,")
        append("isMonitoredByJob=$isMonitoredByJob,")
        append("lastJobId=$lastJobId,")
        append("lastJobRunTime=$lastJobRunTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = isDefinedInJob?.hashCode() ?: 0
        result = 31 * result + (isMonitoredByJob?.hashCode() ?: 0)
        result = 31 * result + (lastJobId?.hashCode() ?: 0)
        result = 31 * result + (lastJobRunTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobDetails

        if (isDefinedInJob != other.isDefinedInJob) return false
        if (isMonitoredByJob != other.isMonitoredByJob) return false
        if (lastJobId != other.lastJobId) return false
        if (lastJobRunTime != other.lastJobRunTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.JobDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether any one-time or recurring jobs are configured to analyze data in the bucket. Possible values are:
         * + TRUE - The bucket is explicitly included in the bucket definition (S3BucketDefinitionForJob) for one or more jobs and at least one of those jobs has a status other than CANCELLED. Or the bucket matched the bucket criteria (S3BucketCriteriaForJob) for at least one job that previously ran.
         * + FALSE - The bucket isn't explicitly included in the bucket definition (S3BucketDefinitionForJob) for any jobs, all the jobs that explicitly include the bucket in their bucket definitions have a status of CANCELLED, or the bucket didn't match the bucket criteria (S3BucketCriteriaForJob) for any jobs that previously ran.
         * + UNKNOWN - An exception occurred when Amazon Macie attempted to retrieve job data for the bucket.
         */
        public var isDefinedInJob: aws.sdk.kotlin.services.macie2.model.IsDefinedInJob? = null
        /**
         * Specifies whether any recurring jobs are configured to analyze data in the bucket. Possible values are:
         * + TRUE - The bucket is explicitly included in the bucket definition (S3BucketDefinitionForJob) for one or more recurring jobs or the bucket matches the bucket criteria (S3BucketCriteriaForJob) for one or more recurring jobs. At least one of those jobs has a status other than CANCELLED.
         * + FALSE - The bucket isn't explicitly included in the bucket definition (S3BucketDefinitionForJob) for any recurring jobs, the bucket doesn't match the bucket criteria (S3BucketCriteriaForJob) for any recurring jobs, or all the recurring jobs that are configured to analyze data in the bucket have a status of CANCELLED.
         * + UNKNOWN - An exception occurred when Amazon Macie attempted to retrieve job data for the bucket.
         */
        public var isMonitoredByJob: aws.sdk.kotlin.services.macie2.model.IsMonitoredByJob? = null
        /**
         * The unique identifier for the job that ran most recently and is configured to analyze data in the bucket, either the latest run of a recurring job or the only run of a one-time job.
         *
         * This value is typically null if the value for the isDefinedInJob property is FALSE or UNKNOWN.
         */
        public var lastJobId: kotlin.String? = null
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the job (lastJobId) started. If the job is a recurring job, this value indicates when the most recent run started.
         *
         * This value is typically null if the value for the isDefinedInJob property is FALSE or UNKNOWN.
         */
        public var lastJobRunTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.JobDetails) : this() {
            this.isDefinedInJob = x.isDefinedInJob
            this.isMonitoredByJob = x.isMonitoredByJob
            this.lastJobId = x.lastJobId
            this.lastJobRunTime = x.lastJobRunTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.JobDetails = JobDetails(this)
    }
}
