// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information about a classification job, including the current status of the job.
 */
public class JobSummary private constructor(builder: Builder) {
    /**
     * The property- and tag-based conditions that determine which S3 buckets are included or excluded from the job's analysis. Each time the job runs, the job uses these criteria to determine which buckets to analyze. A job's definition can contain a bucketCriteria object or a bucketDefinitions array, not both.
     */
    public val bucketCriteria: aws.sdk.kotlin.services.macie2.model.S3BucketCriteriaForJob? = builder.bucketCriteria
    /**
     * An array of objects, one for each Amazon Web Services account that owns specific S3 buckets for the job to analyze. Each object specifies the account ID for an account and one or more buckets to analyze for that account. A job's definition can contain a bucketDefinitions array or a bucketCriteria object, not both.
     */
    public val bucketDefinitions: List<S3BucketDefinitionForJob>? = builder.bucketDefinitions
    /**
     * The date and time, in UTC and extended ISO 8601 format, when the job was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The unique identifier for the job.
     */
    public val jobId: kotlin.String? = builder.jobId
    /**
     * The current status of the job. Possible values are:
     * + CANCELLED - You cancelled the job or, if it's a one-time job, you paused the job and didn't resume it within 30 days.
     * + COMPLETE - For a one-time job, Amazon Macie finished processing the data specified for the job. This value doesn't apply to recurring jobs.
     * + IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is pending. This value doesn't apply to one-time jobs.
     * + PAUSED - Macie started running the job but additional processing would exceed the monthly sensitive data discovery quota for your account or one or more member accounts that the job analyzes data for.
     * + RUNNING - For a one-time job, the job is in progress. For a recurring job, a scheduled run is in progress.
     * + USER_PAUSED - You paused the job. If you paused the job while it had a status of RUNNING and you don't resume it within 30 days of pausing it, the job or job run will expire and be cancelled, depending on the job's type. To check the expiration date, refer to the UserPausedDetails.jobExpiresAt property.
     */
    public val jobStatus: aws.sdk.kotlin.services.macie2.model.JobStatus? = builder.jobStatus
    /**
     * The schedule for running the job. Possible values are:
     * + ONE_TIME - The job runs only once.
     * + SCHEDULED - The job runs on a daily, weekly, or monthly basis.
     */
    public val jobType: aws.sdk.kotlin.services.macie2.model.JobType? = builder.jobType
    /**
     * Specifies whether any account- or bucket-level access errors occurred when the job ran. For a recurring job, this value indicates the error status of the job's most recent run.
     */
    public val lastRunErrorStatus: aws.sdk.kotlin.services.macie2.model.LastRunErrorStatus? = builder.lastRunErrorStatus
    /**
     * The custom name of the job.
     */
    public val name: kotlin.String? = builder.name
    /**
     * If the current status of the job is USER_PAUSED, specifies when the job was paused and when the job or job run will expire and be cancelled if it isn't resumed. This value is present only if the value for jobStatus is USER_PAUSED.
     */
    public val userPausedDetails: aws.sdk.kotlin.services.macie2.model.UserPausedDetails? = builder.userPausedDetails

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.JobSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobSummary(")
        append("bucketCriteria=$bucketCriteria,")
        append("bucketDefinitions=$bucketDefinitions,")
        append("createdAt=$createdAt,")
        append("jobId=$jobId,")
        append("jobStatus=$jobStatus,")
        append("jobType=$jobType,")
        append("lastRunErrorStatus=$lastRunErrorStatus,")
        append("name=$name,")
        append("userPausedDetails=$userPausedDetails)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketCriteria?.hashCode() ?: 0
        result = 31 * result + (bucketDefinitions?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (jobStatus?.hashCode() ?: 0)
        result = 31 * result + (jobType?.hashCode() ?: 0)
        result = 31 * result + (lastRunErrorStatus?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (userPausedDetails?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobSummary

        if (bucketCriteria != other.bucketCriteria) return false
        if (bucketDefinitions != other.bucketDefinitions) return false
        if (createdAt != other.createdAt) return false
        if (jobId != other.jobId) return false
        if (jobStatus != other.jobStatus) return false
        if (jobType != other.jobType) return false
        if (lastRunErrorStatus != other.lastRunErrorStatus) return false
        if (name != other.name) return false
        if (userPausedDetails != other.userPausedDetails) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.JobSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The property- and tag-based conditions that determine which S3 buckets are included or excluded from the job's analysis. Each time the job runs, the job uses these criteria to determine which buckets to analyze. A job's definition can contain a bucketCriteria object or a bucketDefinitions array, not both.
         */
        public var bucketCriteria: aws.sdk.kotlin.services.macie2.model.S3BucketCriteriaForJob? = null
        /**
         * An array of objects, one for each Amazon Web Services account that owns specific S3 buckets for the job to analyze. Each object specifies the account ID for an account and one or more buckets to analyze for that account. A job's definition can contain a bucketDefinitions array or a bucketCriteria object, not both.
         */
        public var bucketDefinitions: List<S3BucketDefinitionForJob>? = null
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the job was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The unique identifier for the job.
         */
        public var jobId: kotlin.String? = null
        /**
         * The current status of the job. Possible values are:
         * + CANCELLED - You cancelled the job or, if it's a one-time job, you paused the job and didn't resume it within 30 days.
         * + COMPLETE - For a one-time job, Amazon Macie finished processing the data specified for the job. This value doesn't apply to recurring jobs.
         * + IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is pending. This value doesn't apply to one-time jobs.
         * + PAUSED - Macie started running the job but additional processing would exceed the monthly sensitive data discovery quota for your account or one or more member accounts that the job analyzes data for.
         * + RUNNING - For a one-time job, the job is in progress. For a recurring job, a scheduled run is in progress.
         * + USER_PAUSED - You paused the job. If you paused the job while it had a status of RUNNING and you don't resume it within 30 days of pausing it, the job or job run will expire and be cancelled, depending on the job's type. To check the expiration date, refer to the UserPausedDetails.jobExpiresAt property.
         */
        public var jobStatus: aws.sdk.kotlin.services.macie2.model.JobStatus? = null
        /**
         * The schedule for running the job. Possible values are:
         * + ONE_TIME - The job runs only once.
         * + SCHEDULED - The job runs on a daily, weekly, or monthly basis.
         */
        public var jobType: aws.sdk.kotlin.services.macie2.model.JobType? = null
        /**
         * Specifies whether any account- or bucket-level access errors occurred when the job ran. For a recurring job, this value indicates the error status of the job's most recent run.
         */
        public var lastRunErrorStatus: aws.sdk.kotlin.services.macie2.model.LastRunErrorStatus? = null
        /**
         * The custom name of the job.
         */
        public var name: kotlin.String? = null
        /**
         * If the current status of the job is USER_PAUSED, specifies when the job was paused and when the job or job run will expire and be cancelled if it isn't resumed. This value is present only if the value for jobStatus is USER_PAUSED.
         */
        public var userPausedDetails: aws.sdk.kotlin.services.macie2.model.UserPausedDetails? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.JobSummary) : this() {
            this.bucketCriteria = x.bucketCriteria
            this.bucketDefinitions = x.bucketDefinitions
            this.createdAt = x.createdAt
            this.jobId = x.jobId
            this.jobStatus = x.jobStatus
            this.jobType = x.jobType
            this.lastRunErrorStatus = x.lastRunErrorStatus
            this.name = x.name
            this.userPausedDetails = x.userPausedDetails
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.JobSummary = JobSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.S3BucketCriteriaForJob] inside the given [block]
         */
        public fun bucketCriteria(block: aws.sdk.kotlin.services.macie2.model.S3BucketCriteriaForJob.Builder.() -> kotlin.Unit) {
            this.bucketCriteria = aws.sdk.kotlin.services.macie2.model.S3BucketCriteriaForJob.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.LastRunErrorStatus] inside the given [block]
         */
        public fun lastRunErrorStatus(block: aws.sdk.kotlin.services.macie2.model.LastRunErrorStatus.Builder.() -> kotlin.Unit) {
            this.lastRunErrorStatus = aws.sdk.kotlin.services.macie2.model.LastRunErrorStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.UserPausedDetails] inside the given [block]
         */
        public fun userPausedDetails(block: aws.sdk.kotlin.services.macie2.model.UserPausedDetails.Builder.() -> kotlin.Unit) {
            this.userPausedDetails = aws.sdk.kotlin.services.macie2.model.UserPausedDetails.invoke(block)
        }
    }
}
