// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides statistical data and other information about an S3 bucket that Amazon Macie monitors and analyzes for your account. If an error occurs when Macie attempts to retrieve and process information about the bucket or the bucket's objects, the value for most of these properties is null. Exceptions are accountId and bucketName. To identify the cause of the error, refer to the errorCode and errorMessage values.
 */
public class MatchingBucket private constructor(builder: Builder) {
    /**
     * The unique identifier for the Amazon Web Services account that owns the bucket.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The name of the bucket.
     */
    public val bucketName: kotlin.String? = builder.bucketName
    /**
     * The total number of objects that Amazon Macie can analyze in the bucket. These objects use a supported storage class and have a file name extension for a supported file or storage format.
     */
    public val classifiableObjectCount: kotlin.Long = builder.classifiableObjectCount
    /**
     * The total storage size, in bytes, of the objects that Amazon Macie can analyze in the bucket. These objects use a supported storage class and have a file name extension for a supported file or storage format.
     *
     * If versioning is enabled for the bucket, Macie calculates this value based on the size of the latest version of each applicable object in the bucket. This value doesn't reflect the storage size of all versions of each applicable object in the bucket.
     */
    public val classifiableSizeInBytes: kotlin.Long = builder.classifiableSizeInBytes
    /**
     * Specifies the error code for an error that prevented Amazon Macie from retrieving and processing information about the bucket and the bucket's objects. If this value is ACCESS_DENIED, Macie doesn't have permission to retrieve the information. For example, the bucket has a restrictive bucket policy and Amazon S3 denied the request. If this value is null, Macie was able to retrieve and process the information.
     */
    public val errorCode: aws.sdk.kotlin.services.macie2.model.BucketMetadataErrorCode? = builder.errorCode
    /**
     * A brief description of the error (errorCode) that prevented Amazon Macie from retrieving and processing information about the bucket and the bucket's objects. This value is null if Macie was able to retrieve and process the information.
     */
    public val errorMessage: kotlin.String? = builder.errorMessage
    /**
     * Specifies whether any one-time or recurring classification jobs are configured to analyze objects in the bucket, and, if so, the details of the job that ran most recently.
     */
    public val jobDetails: aws.sdk.kotlin.services.macie2.model.JobDetails? = builder.jobDetails
    /**
     * The total number of objects in the bucket.
     */
    public val objectCount: kotlin.Long = builder.objectCount
    /**
     * The total number of objects that are in the bucket, grouped by server-side encryption type. This includes a grouping that reports the total number of objects that aren't encrypted or use client-side encryption.
     */
    public val objectCountByEncryptionType: aws.sdk.kotlin.services.macie2.model.ObjectCountByEncryptionType? = builder.objectCountByEncryptionType
    /**
     * The total storage size, in bytes, of the bucket.
     *
     * If versioning is enabled for the bucket, Amazon Macie calculates this value based on the size of the latest version of each object in the bucket. This value doesn't reflect the storage size of all versions of each object in the bucket.
     */
    public val sizeInBytes: kotlin.Long = builder.sizeInBytes
    /**
     * The total storage size, in bytes, of the objects that are compressed (.gz, .gzip, .zip) files in the bucket.
     *
     * If versioning is enabled for the bucket, Amazon Macie calculates this value based on the size of the latest version of each applicable object in the bucket. This value doesn't reflect the storage size of all versions of each applicable object in the bucket.
     */
    public val sizeInBytesCompressed: kotlin.Long = builder.sizeInBytesCompressed
    /**
     * The total number of objects that Amazon Macie can't analyze in the bucket. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.
     */
    public val unclassifiableObjectCount: aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics? = builder.unclassifiableObjectCount
    /**
     * The total storage size, in bytes, of the objects that Amazon Macie can't analyze in the bucket. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.
     */
    public val unclassifiableObjectSizeInBytes: aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics? = builder.unclassifiableObjectSizeInBytes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.MatchingBucket = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MatchingBucket(")
        append("accountId=$accountId,")
        append("bucketName=$bucketName,")
        append("classifiableObjectCount=$classifiableObjectCount,")
        append("classifiableSizeInBytes=$classifiableSizeInBytes,")
        append("errorCode=$errorCode,")
        append("errorMessage=$errorMessage,")
        append("jobDetails=$jobDetails,")
        append("objectCount=$objectCount,")
        append("objectCountByEncryptionType=$objectCountByEncryptionType,")
        append("sizeInBytes=$sizeInBytes,")
        append("sizeInBytesCompressed=$sizeInBytesCompressed,")
        append("unclassifiableObjectCount=$unclassifiableObjectCount,")
        append("unclassifiableObjectSizeInBytes=$unclassifiableObjectSizeInBytes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (bucketName?.hashCode() ?: 0)
        result = 31 * result + (classifiableObjectCount.hashCode())
        result = 31 * result + (classifiableSizeInBytes.hashCode())
        result = 31 * result + (errorCode?.hashCode() ?: 0)
        result = 31 * result + (errorMessage?.hashCode() ?: 0)
        result = 31 * result + (jobDetails?.hashCode() ?: 0)
        result = 31 * result + (objectCount.hashCode())
        result = 31 * result + (objectCountByEncryptionType?.hashCode() ?: 0)
        result = 31 * result + (sizeInBytes.hashCode())
        result = 31 * result + (sizeInBytesCompressed.hashCode())
        result = 31 * result + (unclassifiableObjectCount?.hashCode() ?: 0)
        result = 31 * result + (unclassifiableObjectSizeInBytes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MatchingBucket

        if (accountId != other.accountId) return false
        if (bucketName != other.bucketName) return false
        if (classifiableObjectCount != other.classifiableObjectCount) return false
        if (classifiableSizeInBytes != other.classifiableSizeInBytes) return false
        if (errorCode != other.errorCode) return false
        if (errorMessage != other.errorMessage) return false
        if (jobDetails != other.jobDetails) return false
        if (objectCount != other.objectCount) return false
        if (objectCountByEncryptionType != other.objectCountByEncryptionType) return false
        if (sizeInBytes != other.sizeInBytes) return false
        if (sizeInBytesCompressed != other.sizeInBytesCompressed) return false
        if (unclassifiableObjectCount != other.unclassifiableObjectCount) return false
        if (unclassifiableObjectSizeInBytes != other.unclassifiableObjectSizeInBytes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.MatchingBucket = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique identifier for the Amazon Web Services account that owns the bucket.
         */
        public var accountId: kotlin.String? = null
        /**
         * The name of the bucket.
         */
        public var bucketName: kotlin.String? = null
        /**
         * The total number of objects that Amazon Macie can analyze in the bucket. These objects use a supported storage class and have a file name extension for a supported file or storage format.
         */
        public var classifiableObjectCount: kotlin.Long = 0L
        /**
         * The total storage size, in bytes, of the objects that Amazon Macie can analyze in the bucket. These objects use a supported storage class and have a file name extension for a supported file or storage format.
         *
         * If versioning is enabled for the bucket, Macie calculates this value based on the size of the latest version of each applicable object in the bucket. This value doesn't reflect the storage size of all versions of each applicable object in the bucket.
         */
        public var classifiableSizeInBytes: kotlin.Long = 0L
        /**
         * Specifies the error code for an error that prevented Amazon Macie from retrieving and processing information about the bucket and the bucket's objects. If this value is ACCESS_DENIED, Macie doesn't have permission to retrieve the information. For example, the bucket has a restrictive bucket policy and Amazon S3 denied the request. If this value is null, Macie was able to retrieve and process the information.
         */
        public var errorCode: aws.sdk.kotlin.services.macie2.model.BucketMetadataErrorCode? = null
        /**
         * A brief description of the error (errorCode) that prevented Amazon Macie from retrieving and processing information about the bucket and the bucket's objects. This value is null if Macie was able to retrieve and process the information.
         */
        public var errorMessage: kotlin.String? = null
        /**
         * Specifies whether any one-time or recurring classification jobs are configured to analyze objects in the bucket, and, if so, the details of the job that ran most recently.
         */
        public var jobDetails: aws.sdk.kotlin.services.macie2.model.JobDetails? = null
        /**
         * The total number of objects in the bucket.
         */
        public var objectCount: kotlin.Long = 0L
        /**
         * The total number of objects that are in the bucket, grouped by server-side encryption type. This includes a grouping that reports the total number of objects that aren't encrypted or use client-side encryption.
         */
        public var objectCountByEncryptionType: aws.sdk.kotlin.services.macie2.model.ObjectCountByEncryptionType? = null
        /**
         * The total storage size, in bytes, of the bucket.
         *
         * If versioning is enabled for the bucket, Amazon Macie calculates this value based on the size of the latest version of each object in the bucket. This value doesn't reflect the storage size of all versions of each object in the bucket.
         */
        public var sizeInBytes: kotlin.Long = 0L
        /**
         * The total storage size, in bytes, of the objects that are compressed (.gz, .gzip, .zip) files in the bucket.
         *
         * If versioning is enabled for the bucket, Amazon Macie calculates this value based on the size of the latest version of each applicable object in the bucket. This value doesn't reflect the storage size of all versions of each applicable object in the bucket.
         */
        public var sizeInBytesCompressed: kotlin.Long = 0L
        /**
         * The total number of objects that Amazon Macie can't analyze in the bucket. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.
         */
        public var unclassifiableObjectCount: aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics? = null
        /**
         * The total storage size, in bytes, of the objects that Amazon Macie can't analyze in the bucket. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.
         */
        public var unclassifiableObjectSizeInBytes: aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.MatchingBucket) : this() {
            this.accountId = x.accountId
            this.bucketName = x.bucketName
            this.classifiableObjectCount = x.classifiableObjectCount
            this.classifiableSizeInBytes = x.classifiableSizeInBytes
            this.errorCode = x.errorCode
            this.errorMessage = x.errorMessage
            this.jobDetails = x.jobDetails
            this.objectCount = x.objectCount
            this.objectCountByEncryptionType = x.objectCountByEncryptionType
            this.sizeInBytes = x.sizeInBytes
            this.sizeInBytesCompressed = x.sizeInBytesCompressed
            this.unclassifiableObjectCount = x.unclassifiableObjectCount
            this.unclassifiableObjectSizeInBytes = x.unclassifiableObjectSizeInBytes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.MatchingBucket = MatchingBucket(this)

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.JobDetails] inside the given [block]
         */
        public fun jobDetails(block: aws.sdk.kotlin.services.macie2.model.JobDetails.Builder.() -> kotlin.Unit) {
            this.jobDetails = aws.sdk.kotlin.services.macie2.model.JobDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.ObjectCountByEncryptionType] inside the given [block]
         */
        public fun objectCountByEncryptionType(block: aws.sdk.kotlin.services.macie2.model.ObjectCountByEncryptionType.Builder.() -> kotlin.Unit) {
            this.objectCountByEncryptionType = aws.sdk.kotlin.services.macie2.model.ObjectCountByEncryptionType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics] inside the given [block]
         */
        public fun unclassifiableObjectCount(block: aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics.Builder.() -> kotlin.Unit) {
            this.unclassifiableObjectCount = aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics] inside the given [block]
         */
        public fun unclassifiableObjectSizeInBytes(block: aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics.Builder.() -> kotlin.Unit) {
            this.unclassifiableObjectSizeInBytes = aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics.invoke(block)
        }
    }
}
