// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about the number of objects that are in an S3 bucket and use certain types of server-side encryption, use client-side encryption, or aren't encrypted.
 */
public class ObjectCountByEncryptionType private constructor(builder: Builder) {
    /**
     * The total number of objects that are encrypted with a customer-provided key. The objects use customer-provided server-side encryption (SSE-C).
     */
    public val customerManaged: kotlin.Long = builder.customerManaged
    /**
     * The total number of objects that are encrypted with an KMS key, either an Amazon Web Services managed key or a customer managed key. The objects use KMS encryption (SSE-KMS).
     */
    public val kmsManaged: kotlin.Long = builder.kmsManaged
    /**
     * The total number of objects that are encrypted with an Amazon S3 managed key. The objects use Amazon S3 managed encryption (SSE-S3).
     */
    public val s3Managed: kotlin.Long = builder.s3Managed
    /**
     * The total number of objects that aren't encrypted or use client-side encryption.
     */
    public val unencrypted: kotlin.Long = builder.unencrypted
    /**
     * The total number of objects that Amazon Macie doesn't have current encryption metadata for. Macie can't provide current data about the encryption settings for these objects.
     */
    public val unknown: kotlin.Long = builder.unknown

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.ObjectCountByEncryptionType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ObjectCountByEncryptionType(")
        append("customerManaged=$customerManaged,")
        append("kmsManaged=$kmsManaged,")
        append("s3Managed=$s3Managed,")
        append("unencrypted=$unencrypted,")
        append("unknown=$unknown)")
    }

    override fun hashCode(): kotlin.Int {
        var result = customerManaged.hashCode()
        result = 31 * result + (kmsManaged.hashCode())
        result = 31 * result + (s3Managed.hashCode())
        result = 31 * result + (unencrypted.hashCode())
        result = 31 * result + (unknown.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ObjectCountByEncryptionType

        if (customerManaged != other.customerManaged) return false
        if (kmsManaged != other.kmsManaged) return false
        if (s3Managed != other.s3Managed) return false
        if (unencrypted != other.unencrypted) return false
        if (unknown != other.unknown) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.ObjectCountByEncryptionType = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The total number of objects that are encrypted with a customer-provided key. The objects use customer-provided server-side encryption (SSE-C).
         */
        public var customerManaged: kotlin.Long = 0L
        /**
         * The total number of objects that are encrypted with an KMS key, either an Amazon Web Services managed key or a customer managed key. The objects use KMS encryption (SSE-KMS).
         */
        public var kmsManaged: kotlin.Long = 0L
        /**
         * The total number of objects that are encrypted with an Amazon S3 managed key. The objects use Amazon S3 managed encryption (SSE-S3).
         */
        public var s3Managed: kotlin.Long = 0L
        /**
         * The total number of objects that aren't encrypted or use client-side encryption.
         */
        public var unencrypted: kotlin.Long = 0L
        /**
         * The total number of objects that Amazon Macie doesn't have current encryption metadata for. Macie can't provide current data about the encryption settings for these objects.
         */
        public var unknown: kotlin.Long = 0L

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.ObjectCountByEncryptionType) : this() {
            this.customerManaged = x.customerManaged
            this.kmsManaged = x.kmsManaged
            this.s3Managed = x.s3Managed
            this.unencrypted = x.unencrypted
            this.unknown = x.unknown
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.ObjectCountByEncryptionType = ObjectCountByEncryptionType(this)
    }
}
