// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about the total storage size (in bytes) or number of objects that Amazon Macie can't analyze in one or more S3 buckets. In a BucketMetadata or MatchingBucket object, this data is for a specific bucket. In a GetBucketStatisticsResponse object, this data is aggregated for the buckets in the query results. If versioning is enabled for a bucket, total storage size values are based on the size of the latest version of each applicable object in the bucket.
 */
public class ObjectLevelStatistics private constructor(builder: Builder) {
    /**
     * The total storage size (in bytes) or number of objects that Amazon Macie can't analyze because the objects don't have a file name extension for a supported file or storage format.
     */
    public val fileType: kotlin.Long = builder.fileType
    /**
     * The total storage size (in bytes) or number of objects that Amazon Macie can't analyze because the objects use an unsupported storage class.
     */
    public val storageClass: kotlin.Long = builder.storageClass
    /**
     * The total storage size (in bytes) or number of objects that Amazon Macie can't analyze because the objects use an unsupported storage class or don't have a file name extension for a supported file or storage format.
     */
    public val total: kotlin.Long = builder.total

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ObjectLevelStatistics(")
        append("fileType=$fileType,")
        append("storageClass=$storageClass,")
        append("total=$total)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fileType.hashCode()
        result = 31 * result + (storageClass.hashCode())
        result = 31 * result + (total.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ObjectLevelStatistics

        if (fileType != other.fileType) return false
        if (storageClass != other.storageClass) return false
        if (total != other.total) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The total storage size (in bytes) or number of objects that Amazon Macie can't analyze because the objects don't have a file name extension for a supported file or storage format.
         */
        public var fileType: kotlin.Long = 0L
        /**
         * The total storage size (in bytes) or number of objects that Amazon Macie can't analyze because the objects use an unsupported storage class.
         */
        public var storageClass: kotlin.Long = 0L
        /**
         * The total storage size (in bytes) or number of objects that Amazon Macie can't analyze because the objects use an unsupported storage class or don't have a file name extension for a supported file or storage format.
         */
        public var total: kotlin.Long = 0L

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics) : this() {
            this.fileType = x.fileType
            this.storageClass = x.storageClass
            this.total = x.total
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics = ObjectLevelStatistics(this)
    }
}
