// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Specifies the location of 1-15 occurrences of sensitive data that was detected by a managed data identifier or a custom data identifier and produced a sensitive data finding.
 */
public class Occurrences private constructor(builder: Builder) {
    /**
     * An array of objects, one for each occurrence of sensitive data in a Microsoft Excel workbook, CSV file, or TSV file. This value is null for all other types of files.
     *
     * Each Cell object specifies a cell or field that contains the sensitive data.
     */
    public val cells: List<Cell>? = builder.cells
    /**
     * An array of objects, one for each occurrence of sensitive data in a non-binary text file, such as an HTML, TXT, or XML file. Each Range object specifies a line or inclusive range of lines that contains the sensitive data, and the position of the data on the specified line or lines.
     *
     * This value is often null for file types that are supported by Cell, Page, or Record objects. Exceptions are the location of sensitive data in: unstructured sections of an otherwise structured file, such as a comment in a file; a malformed file that Amazon Macie analyzes as plain text; and, a CSV or TSV file that has any column names that contain sensitive data.
     */
    public val lineRanges: List<Range>? = builder.lineRanges
    /**
     * Reserved for future use.
     */
    public val offsetRanges: List<Range>? = builder.offsetRanges
    /**
     * An array of objects, one for each occurrence of sensitive data in an Adobe Portable Document Format file. This value is null for all other types of files.
     *
     * Each Page object specifies a page that contains the sensitive data.
     */
    public val pages: List<Page>? = builder.pages
    /**
     * An array of objects, one for each occurrence of sensitive data in an Apache Avro object container, Apache Parquet file, JSON file, or JSON Lines file. This value is null for all other types of files.
     *
     * For an Avro object container or Parquet file, each Record object specifies a record index and the path to a field in a record that contains the sensitive data. For a JSON or JSON Lines file, each Record object specifies the path to a field or array that contains the sensitive data. For a JSON Lines file, it also specifies the index of the line that contains the data.
     */
    public val records: List<Record>? = builder.records

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.Occurrences = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Occurrences(")
        append("cells=$cells,")
        append("lineRanges=$lineRanges,")
        append("offsetRanges=$offsetRanges,")
        append("pages=$pages,")
        append("records=$records)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cells?.hashCode() ?: 0
        result = 31 * result + (lineRanges?.hashCode() ?: 0)
        result = 31 * result + (offsetRanges?.hashCode() ?: 0)
        result = 31 * result + (pages?.hashCode() ?: 0)
        result = 31 * result + (records?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Occurrences

        if (cells != other.cells) return false
        if (lineRanges != other.lineRanges) return false
        if (offsetRanges != other.offsetRanges) return false
        if (pages != other.pages) return false
        if (records != other.records) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.Occurrences = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An array of objects, one for each occurrence of sensitive data in a Microsoft Excel workbook, CSV file, or TSV file. This value is null for all other types of files.
         *
         * Each Cell object specifies a cell or field that contains the sensitive data.
         */
        public var cells: List<Cell>? = null
        /**
         * An array of objects, one for each occurrence of sensitive data in a non-binary text file, such as an HTML, TXT, or XML file. Each Range object specifies a line or inclusive range of lines that contains the sensitive data, and the position of the data on the specified line or lines.
         *
         * This value is often null for file types that are supported by Cell, Page, or Record objects. Exceptions are the location of sensitive data in: unstructured sections of an otherwise structured file, such as a comment in a file; a malformed file that Amazon Macie analyzes as plain text; and, a CSV or TSV file that has any column names that contain sensitive data.
         */
        public var lineRanges: List<Range>? = null
        /**
         * Reserved for future use.
         */
        public var offsetRanges: List<Range>? = null
        /**
         * An array of objects, one for each occurrence of sensitive data in an Adobe Portable Document Format file. This value is null for all other types of files.
         *
         * Each Page object specifies a page that contains the sensitive data.
         */
        public var pages: List<Page>? = null
        /**
         * An array of objects, one for each occurrence of sensitive data in an Apache Avro object container, Apache Parquet file, JSON file, or JSON Lines file. This value is null for all other types of files.
         *
         * For an Avro object container or Parquet file, each Record object specifies a record index and the path to a field in a record that contains the sensitive data. For a JSON or JSON Lines file, each Record object specifies the path to a field or array that contains the sensitive data. For a JSON Lines file, it also specifies the index of the line that contains the data.
         */
        public var records: List<Record>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.Occurrences) : this() {
            this.cells = x.cells
            this.lineRanges = x.lineRanges
            this.offsetRanges = x.offsetRanges
            this.pages = x.pages
            this.records = x.records
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.Occurrences = Occurrences(this)
    }
}
