// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about settings that define whether one or more objects in an S3 bucket are replicated to S3 buckets for other Amazon Web Services accounts and, if so, which accounts.
 */
public class ReplicationDetails private constructor(builder: Builder) {
    /**
     * Specifies whether the bucket is configured to replicate one or more objects to any destination.
     */
    public val replicated: kotlin.Boolean = builder.replicated
    /**
     * Specifies whether the bucket is configured to replicate one or more objects to an Amazon Web Services account that isn't part of the same Amazon Macie organization.
     */
    public val replicatedExternally: kotlin.Boolean = builder.replicatedExternally
    /**
     * An array of Amazon Web Services account IDs, one for each Amazon Web Services account that the bucket is configured to replicate one or more objects to.
     */
    public val replicationAccounts: List<String>? = builder.replicationAccounts

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.ReplicationDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReplicationDetails(")
        append("replicated=$replicated,")
        append("replicatedExternally=$replicatedExternally,")
        append("replicationAccounts=$replicationAccounts)")
    }

    override fun hashCode(): kotlin.Int {
        var result = replicated.hashCode()
        result = 31 * result + (replicatedExternally.hashCode())
        result = 31 * result + (replicationAccounts?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReplicationDetails

        if (replicated != other.replicated) return false
        if (replicatedExternally != other.replicatedExternally) return false
        if (replicationAccounts != other.replicationAccounts) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.ReplicationDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether the bucket is configured to replicate one or more objects to any destination.
         */
        public var replicated: kotlin.Boolean = false
        /**
         * Specifies whether the bucket is configured to replicate one or more objects to an Amazon Web Services account that isn't part of the same Amazon Macie organization.
         */
        public var replicatedExternally: kotlin.Boolean = false
        /**
         * An array of Amazon Web Services account IDs, one for each Amazon Web Services account that the bucket is configured to replicate one or more objects to.
         */
        public var replicationAccounts: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.ReplicationDetails) : this() {
            this.replicated = x.replicated
            this.replicatedExternally = x.replicatedExternally
            this.replicationAccounts = x.replicationAccounts
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.ReplicationDetails = ReplicationDetails(this)
    }
}
