// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information about the S3 bucket that a finding applies to.
 */
public class S3Bucket private constructor(builder: Builder) {
    /**
     * Specifies whether the bucket policy for the bucket requires server-side encryption of objects when objects are uploaded to the bucket. Possible values are:
     * + FALSE - The bucket policy requires server-side encryption of new objects. PutObject requests must include the x-amz-server-side-encryption header and the value for that header must be AES256 or aws:kms.
     * + TRUE - The bucket doesn't have a bucket policy or it has a bucket policy that doesn't require server-side encryption of new objects. If a bucket policy exists, it doesn't require PutObject requests to include the x-amz-server-side-encryption header and it doesn't require the value for that header to be AES256 or aws:kms.
     * + UNKNOWN - Amazon Macie can't determine whether the bucket policy requires server-side encryption of objects.
     */
    public val allowsUnencryptedObjectUploads: aws.sdk.kotlin.services.macie2.model.AllowsUnencryptedObjectUploads? = builder.allowsUnencryptedObjectUploads
    /**
     * The Amazon Resource Name (ARN) of the bucket.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The date and time, in UTC and extended ISO 8601 format, when the bucket was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The type of server-side encryption that's used by default to encrypt objects in the bucket.
     */
    public val defaultServerSideEncryption: aws.sdk.kotlin.services.macie2.model.ServerSideEncryption? = builder.defaultServerSideEncryption
    /**
     * The name of the bucket.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The display name and canonical user ID for the Amazon Web Services account that owns the bucket.
     */
    public val owner: aws.sdk.kotlin.services.macie2.model.S3BucketOwner? = builder.owner
    /**
     * The permissions settings that determine whether the bucket is publicly accessible.
     */
    public val publicAccess: aws.sdk.kotlin.services.macie2.model.BucketPublicAccess? = builder.publicAccess
    /**
     * The tags that are associated with the bucket.
     */
    public val tags: List<KeyValuePair>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.S3Bucket = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3Bucket(")
        append("allowsUnencryptedObjectUploads=$allowsUnencryptedObjectUploads,")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("defaultServerSideEncryption=$defaultServerSideEncryption,")
        append("name=$name,")
        append("owner=$owner,")
        append("publicAccess=$publicAccess,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowsUnencryptedObjectUploads?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (defaultServerSideEncryption?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (publicAccess?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3Bucket

        if (allowsUnencryptedObjectUploads != other.allowsUnencryptedObjectUploads) return false
        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (defaultServerSideEncryption != other.defaultServerSideEncryption) return false
        if (name != other.name) return false
        if (owner != other.owner) return false
        if (publicAccess != other.publicAccess) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.S3Bucket = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether the bucket policy for the bucket requires server-side encryption of objects when objects are uploaded to the bucket. Possible values are:
         * + FALSE - The bucket policy requires server-side encryption of new objects. PutObject requests must include the x-amz-server-side-encryption header and the value for that header must be AES256 or aws:kms.
         * + TRUE - The bucket doesn't have a bucket policy or it has a bucket policy that doesn't require server-side encryption of new objects. If a bucket policy exists, it doesn't require PutObject requests to include the x-amz-server-side-encryption header and it doesn't require the value for that header to be AES256 or aws:kms.
         * + UNKNOWN - Amazon Macie can't determine whether the bucket policy requires server-side encryption of objects.
         */
        public var allowsUnencryptedObjectUploads: aws.sdk.kotlin.services.macie2.model.AllowsUnencryptedObjectUploads? = null
        /**
         * The Amazon Resource Name (ARN) of the bucket.
         */
        public var arn: kotlin.String? = null
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the bucket was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The type of server-side encryption that's used by default to encrypt objects in the bucket.
         */
        public var defaultServerSideEncryption: aws.sdk.kotlin.services.macie2.model.ServerSideEncryption? = null
        /**
         * The name of the bucket.
         */
        public var name: kotlin.String? = null
        /**
         * The display name and canonical user ID for the Amazon Web Services account that owns the bucket.
         */
        public var owner: aws.sdk.kotlin.services.macie2.model.S3BucketOwner? = null
        /**
         * The permissions settings that determine whether the bucket is publicly accessible.
         */
        public var publicAccess: aws.sdk.kotlin.services.macie2.model.BucketPublicAccess? = null
        /**
         * The tags that are associated with the bucket.
         */
        public var tags: List<KeyValuePair>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.S3Bucket) : this() {
            this.allowsUnencryptedObjectUploads = x.allowsUnencryptedObjectUploads
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.defaultServerSideEncryption = x.defaultServerSideEncryption
            this.name = x.name
            this.owner = x.owner
            this.publicAccess = x.publicAccess
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.S3Bucket = S3Bucket(this)

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.ServerSideEncryption] inside the given [block]
         */
        public fun defaultServerSideEncryption(block: aws.sdk.kotlin.services.macie2.model.ServerSideEncryption.Builder.() -> kotlin.Unit) {
            this.defaultServerSideEncryption = aws.sdk.kotlin.services.macie2.model.ServerSideEncryption.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.S3BucketOwner] inside the given [block]
         */
        public fun owner(block: aws.sdk.kotlin.services.macie2.model.S3BucketOwner.Builder.() -> kotlin.Unit) {
            this.owner = aws.sdk.kotlin.services.macie2.model.S3BucketOwner.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.BucketPublicAccess] inside the given [block]
         */
        public fun publicAccess(block: aws.sdk.kotlin.services.macie2.model.BucketPublicAccess.Builder.() -> kotlin.Unit) {
            this.publicAccess = aws.sdk.kotlin.services.macie2.model.BucketPublicAccess.invoke(block)
        }
    }
}
