// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Specifies an S3 bucket to store data classification results in, and the encryption settings to use when storing results in that bucket.
 */
public class S3Destination private constructor(builder: Builder) {
    /**
     * The name of the bucket.
     */
    public val bucketName: kotlin.String? = builder.bucketName
    /**
     * The path prefix to use in the path to the location in the bucket. This prefix specifies where to store classification results in the bucket.
     */
    public val keyPrefix: kotlin.String? = builder.keyPrefix
    /**
     * The Amazon Resource Name (ARN) of the customer managed KMS key to use for encryption of the results. This must be the ARN of an existing, symmetric encryption KMS key that's in the same Amazon Web Services Region as the bucket.
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.S3Destination = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3Destination(")
        append("bucketName=$bucketName,")
        append("keyPrefix=$keyPrefix,")
        append("kmsKeyArn=$kmsKeyArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketName?.hashCode() ?: 0
        result = 31 * result + (keyPrefix?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3Destination

        if (bucketName != other.bucketName) return false
        if (keyPrefix != other.keyPrefix) return false
        if (kmsKeyArn != other.kmsKeyArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.S3Destination = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the bucket.
         */
        public var bucketName: kotlin.String? = null
        /**
         * The path prefix to use in the path to the location in the bucket. This prefix specifies where to store classification results in the bucket.
         */
        public var keyPrefix: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the customer managed KMS key to use for encryption of the results. This must be the ARN of an existing, symmetric encryption KMS key that's in the same Amazon Web Services Region as the bucket.
         */
        public var kmsKeyArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.S3Destination) : this() {
            this.bucketName = x.bucketName
            this.keyPrefix = x.keyPrefix
            this.kmsKeyArn = x.kmsKeyArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.S3Destination = S3Destination(this)
    }
}
