// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Specifies which S3 buckets contain the objects that a classification job analyzes, and the scope of that analysis. The bucket specification can be static (bucketDefinitions) or dynamic (bucketCriteria). If it's static, the job analyzes objects in the same predefined set of buckets each time the job runs. If it's dynamic, the job analyzes objects in any buckets that match the specified criteria each time the job starts to run.
 */
public class S3JobDefinition private constructor(builder: Builder) {
    /**
     * The property- and tag-based conditions that determine which S3 buckets to include or exclude from the analysis. Each time the job runs, the job uses these criteria to determine which buckets contain objects to analyze. A job's definition can contain a bucketCriteria object or a bucketDefinitions array, not both.
     */
    public val bucketCriteria: aws.sdk.kotlin.services.macie2.model.S3BucketCriteriaForJob? = builder.bucketCriteria
    /**
     * An array of objects, one for each Amazon Web Services account that owns specific S3 buckets to analyze. Each object specifies the account ID for an account and one or more buckets to analyze for that account. A job's definition can contain a bucketDefinitions array or a bucketCriteria object, not both.
     */
    public val bucketDefinitions: List<S3BucketDefinitionForJob>? = builder.bucketDefinitions
    /**
     * The property- and tag-based conditions that determine which S3 objects to include or exclude from the analysis. Each time the job runs, the job uses these criteria to determine which objects to analyze.
     */
    public val scoping: aws.sdk.kotlin.services.macie2.model.Scoping? = builder.scoping

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.S3JobDefinition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3JobDefinition(")
        append("bucketCriteria=$bucketCriteria,")
        append("bucketDefinitions=$bucketDefinitions,")
        append("scoping=$scoping)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketCriteria?.hashCode() ?: 0
        result = 31 * result + (bucketDefinitions?.hashCode() ?: 0)
        result = 31 * result + (scoping?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3JobDefinition

        if (bucketCriteria != other.bucketCriteria) return false
        if (bucketDefinitions != other.bucketDefinitions) return false
        if (scoping != other.scoping) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.S3JobDefinition = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The property- and tag-based conditions that determine which S3 buckets to include or exclude from the analysis. Each time the job runs, the job uses these criteria to determine which buckets contain objects to analyze. A job's definition can contain a bucketCriteria object or a bucketDefinitions array, not both.
         */
        public var bucketCriteria: aws.sdk.kotlin.services.macie2.model.S3BucketCriteriaForJob? = null
        /**
         * An array of objects, one for each Amazon Web Services account that owns specific S3 buckets to analyze. Each object specifies the account ID for an account and one or more buckets to analyze for that account. A job's definition can contain a bucketDefinitions array or a bucketCriteria object, not both.
         */
        public var bucketDefinitions: List<S3BucketDefinitionForJob>? = null
        /**
         * The property- and tag-based conditions that determine which S3 objects to include or exclude from the analysis. Each time the job runs, the job uses these criteria to determine which objects to analyze.
         */
        public var scoping: aws.sdk.kotlin.services.macie2.model.Scoping? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.S3JobDefinition) : this() {
            this.bucketCriteria = x.bucketCriteria
            this.bucketDefinitions = x.bucketDefinitions
            this.scoping = x.scoping
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.S3JobDefinition = S3JobDefinition(this)

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.S3BucketCriteriaForJob] inside the given [block]
         */
        public fun bucketCriteria(block: aws.sdk.kotlin.services.macie2.model.S3BucketCriteriaForJob.Builder.() -> kotlin.Unit) {
            this.bucketCriteria = aws.sdk.kotlin.services.macie2.model.S3BucketCriteriaForJob.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.Scoping] inside the given [block]
         */
        public fun scoping(block: aws.sdk.kotlin.services.macie2.model.Scoping.Builder.() -> kotlin.Unit) {
            this.scoping = aws.sdk.kotlin.services.macie2.model.Scoping.invoke(block)
        }
    }
}
