// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information about the S3 object that a finding applies to.
 */
public class S3Object private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the bucket that contains the object.
     */
    public val bucketArn: kotlin.String? = builder.bucketArn
    /**
     * The entity tag (ETag) that identifies the affected version of the object. If the object was overwritten or changed after Amazon Macie produced the finding, this value might be different from the current ETag for the object.
     */
    public val eTag: kotlin.String? = builder.eTag
    /**
     * The file name extension of the object. If the object doesn't have a file name extension, this value is "".
     */
    public val extension: kotlin.String? = builder.extension
    /**
     * The full key (name) that's assigned to the object.
     */
    public val key: kotlin.String? = builder.key
    /**
     * The date and time, in UTC and extended ISO 8601 format, when the object was last modified.
     */
    public val lastModified: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModified
    /**
     * The path to the object, including the full key (name).
     */
    public val path: kotlin.String? = builder.path
    /**
     * Specifies whether the object is publicly accessible due to the combination of permissions settings that apply to the object.
     */
    public val publicAccess: kotlin.Boolean = builder.publicAccess
    /**
     * The type of server-side encryption that's used to encrypt the object.
     */
    public val serverSideEncryption: aws.sdk.kotlin.services.macie2.model.ServerSideEncryption? = builder.serverSideEncryption
    /**
     * The total storage size, in bytes, of the object.
     */
    public val size: kotlin.Long = builder.size
    /**
     * The storage class of the object.
     */
    public val storageClass: aws.sdk.kotlin.services.macie2.model.StorageClass? = builder.storageClass
    /**
     * The tags that are associated with the object.
     */
    public val tags: List<KeyValuePair>? = builder.tags
    /**
     * The identifier for the affected version of the object.
     */
    public val versionId: kotlin.String? = builder.versionId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.S3Object = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3Object(")
        append("bucketArn=$bucketArn,")
        append("eTag=$eTag,")
        append("extension=$extension,")
        append("key=$key,")
        append("lastModified=$lastModified,")
        append("path=$path,")
        append("publicAccess=$publicAccess,")
        append("serverSideEncryption=$serverSideEncryption,")
        append("size=$size,")
        append("storageClass=$storageClass,")
        append("tags=$tags,")
        append("versionId=$versionId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketArn?.hashCode() ?: 0
        result = 31 * result + (eTag?.hashCode() ?: 0)
        result = 31 * result + (extension?.hashCode() ?: 0)
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (lastModified?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (publicAccess.hashCode())
        result = 31 * result + (serverSideEncryption?.hashCode() ?: 0)
        result = 31 * result + (size.hashCode())
        result = 31 * result + (storageClass?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (versionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3Object

        if (bucketArn != other.bucketArn) return false
        if (eTag != other.eTag) return false
        if (extension != other.extension) return false
        if (key != other.key) return false
        if (lastModified != other.lastModified) return false
        if (path != other.path) return false
        if (publicAccess != other.publicAccess) return false
        if (serverSideEncryption != other.serverSideEncryption) return false
        if (size != other.size) return false
        if (storageClass != other.storageClass) return false
        if (tags != other.tags) return false
        if (versionId != other.versionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.S3Object = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the bucket that contains the object.
         */
        public var bucketArn: kotlin.String? = null
        /**
         * The entity tag (ETag) that identifies the affected version of the object. If the object was overwritten or changed after Amazon Macie produced the finding, this value might be different from the current ETag for the object.
         */
        public var eTag: kotlin.String? = null
        /**
         * The file name extension of the object. If the object doesn't have a file name extension, this value is "".
         */
        public var extension: kotlin.String? = null
        /**
         * The full key (name) that's assigned to the object.
         */
        public var key: kotlin.String? = null
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the object was last modified.
         */
        public var lastModified: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The path to the object, including the full key (name).
         */
        public var path: kotlin.String? = null
        /**
         * Specifies whether the object is publicly accessible due to the combination of permissions settings that apply to the object.
         */
        public var publicAccess: kotlin.Boolean = false
        /**
         * The type of server-side encryption that's used to encrypt the object.
         */
        public var serverSideEncryption: aws.sdk.kotlin.services.macie2.model.ServerSideEncryption? = null
        /**
         * The total storage size, in bytes, of the object.
         */
        public var size: kotlin.Long = 0L
        /**
         * The storage class of the object.
         */
        public var storageClass: aws.sdk.kotlin.services.macie2.model.StorageClass? = null
        /**
         * The tags that are associated with the object.
         */
        public var tags: List<KeyValuePair>? = null
        /**
         * The identifier for the affected version of the object.
         */
        public var versionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.S3Object) : this() {
            this.bucketArn = x.bucketArn
            this.eTag = x.eTag
            this.extension = x.extension
            this.key = x.key
            this.lastModified = x.lastModified
            this.path = x.path
            this.publicAccess = x.publicAccess
            this.serverSideEncryption = x.serverSideEncryption
            this.size = x.size
            this.storageClass = x.storageClass
            this.tags = x.tags
            this.versionId = x.versionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.S3Object = S3Object(this)

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.ServerSideEncryption] inside the given [block]
         */
        public fun serverSideEncryption(block: aws.sdk.kotlin.services.macie2.model.ServerSideEncryption.Builder.() -> kotlin.Unit) {
            this.serverSideEncryption = aws.sdk.kotlin.services.macie2.model.ServerSideEncryption.invoke(block)
        }
    }
}
