// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Specifies configuration settings that determine which findings are published to Security Hub automatically. For information about how Macie publishes findings to Security Hub, see [Amazon Macie integration with Security Hub](https://docs.aws.amazon.com/macie/latest/user/securityhub-integration.html) in the *Amazon Macie User Guide*.
 */
public class SecurityHubConfiguration private constructor(builder: Builder) {
    /**
     * Specifies whether to publish sensitive data findings to Security Hub. If you set this value to true, Amazon Macie automatically publishes all sensitive data findings that weren't suppressed by a findings filter. The default value is false.
     */
    public val publishClassificationFindings: kotlin.Boolean = builder.publishClassificationFindings
    /**
     * Specifies whether to publish policy findings to Security Hub. If you set this value to true, Amazon Macie automatically publishes all new and updated policy findings that weren't suppressed by a findings filter. The default value is true.
     */
    public val publishPolicyFindings: kotlin.Boolean = builder.publishPolicyFindings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.SecurityHubConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SecurityHubConfiguration(")
        append("publishClassificationFindings=$publishClassificationFindings,")
        append("publishPolicyFindings=$publishPolicyFindings)")
    }

    override fun hashCode(): kotlin.Int {
        var result = publishClassificationFindings.hashCode()
        result = 31 * result + (publishPolicyFindings.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SecurityHubConfiguration

        if (publishClassificationFindings != other.publishClassificationFindings) return false
        if (publishPolicyFindings != other.publishPolicyFindings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.SecurityHubConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether to publish sensitive data findings to Security Hub. If you set this value to true, Amazon Macie automatically publishes all sensitive data findings that weren't suppressed by a findings filter. The default value is false.
         */
        public var publishClassificationFindings: kotlin.Boolean = false
        /**
         * Specifies whether to publish policy findings to Security Hub. If you set this value to true, Amazon Macie automatically publishes all new and updated policy findings that weren't suppressed by a findings filter. The default value is true.
         */
        public var publishPolicyFindings: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.SecurityHubConfiguration) : this() {
            this.publishClassificationFindings = x.publishClassificationFindings
            this.publishPolicyFindings = x.publishPolicyFindings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.SecurityHubConfiguration = SecurityHubConfiguration(this)
    }
}
