// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about the server-side encryption settings for an S3 bucket or S3 object.
 */
public class ServerSideEncryption private constructor(builder: Builder) {
    /**
     * The server-side encryption algorithm that's used when storing data in the bucket or object. If default encryption is disabled for the bucket or the object isn't encrypted using server-side encryption, this value is NONE.
     */
    public val encryptionType: aws.sdk.kotlin.services.macie2.model.EncryptionType? = builder.encryptionType
    /**
     * The Amazon Resource Name (ARN) or unique identifier (key ID) for the KMS key that's used to encrypt data in the bucket or the object. This value is null if an KMS key isn't used to encrypt the data.
     */
    public val kmsMasterKeyId: kotlin.String? = builder.kmsMasterKeyId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.ServerSideEncryption = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServerSideEncryption(")
        append("encryptionType=$encryptionType,")
        append("kmsMasterKeyId=$kmsMasterKeyId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = encryptionType?.hashCode() ?: 0
        result = 31 * result + (kmsMasterKeyId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServerSideEncryption

        if (encryptionType != other.encryptionType) return false
        if (kmsMasterKeyId != other.kmsMasterKeyId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.ServerSideEncryption = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The server-side encryption algorithm that's used when storing data in the bucket or object. If default encryption is disabled for the bucket or the object isn't encrypted using server-side encryption, this value is NONE.
         */
        public var encryptionType: aws.sdk.kotlin.services.macie2.model.EncryptionType? = null
        /**
         * The Amazon Resource Name (ARN) or unique identifier (key ID) for the KMS key that's used to encrypt data in the bucket or the object. This value is null if an KMS key isn't used to encrypt the data.
         */
        public var kmsMasterKeyId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.ServerSideEncryption) : this() {
            this.encryptionType = x.encryptionType
            this.kmsMasterKeyId = x.kmsMasterKeyId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.ServerSideEncryption = ServerSideEncryption(this)
    }
}
