// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about the source and type of temporary security credentials that were issued to an entity.
 */
public class SessionIssuer private constructor(builder: Builder) {
    /**
     * The unique identifier for the Amazon Web Services account that owns the entity that was used to get the credentials.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The Amazon Resource Name (ARN) of the source account, IAM user, or role that was used to get the credentials.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The unique identifier for the entity that was used to get the credentials.
     */
    public val principalId: kotlin.String? = builder.principalId
    /**
     * The source of the temporary security credentials, such as Root, IAMUser, or Role.
     */
    public val type: kotlin.String? = builder.type
    /**
     * The name or alias of the user or role that issued the session. This value is null if the credentials were obtained from a root account that doesn't have an alias.
     */
    public val userName: kotlin.String? = builder.userName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.SessionIssuer = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SessionIssuer(")
        append("accountId=$accountId,")
        append("arn=$arn,")
        append("principalId=$principalId,")
        append("type=$type,")
        append("userName=$userName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (principalId?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (userName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SessionIssuer

        if (accountId != other.accountId) return false
        if (arn != other.arn) return false
        if (principalId != other.principalId) return false
        if (type != other.type) return false
        if (userName != other.userName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.SessionIssuer = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique identifier for the Amazon Web Services account that owns the entity that was used to get the credentials.
         */
        public var accountId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the source account, IAM user, or role that was used to get the credentials.
         */
        public var arn: kotlin.String? = null
        /**
         * The unique identifier for the entity that was used to get the credentials.
         */
        public var principalId: kotlin.String? = null
        /**
         * The source of the temporary security credentials, such as Root, IAMUser, or Role.
         */
        public var type: kotlin.String? = null
        /**
         * The name or alias of the user or role that issued the session. This value is null if the credentials were obtained from a root account that doesn't have an alias.
         */
        public var userName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.SessionIssuer) : this() {
            this.accountId = x.accountId
            this.arn = x.arn
            this.principalId = x.principalId
            this.type = x.type
            this.userName = x.userName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.SessionIssuer = SessionIssuer(this)
    }
}
