// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Specifies a severity level for findings that a custom data identifier produces. A severity level determines which severity is assigned to the findings, based on the number of occurrences of text that matches the custom data identifier's detection criteria.
 */
public class SeverityLevel private constructor(builder: Builder) {
    /**
     * The minimum number of occurrences of text that must match the custom data identifier's detection criteria in order to produce a finding with the specified severity (severity).
     */
    public val occurrencesThreshold: kotlin.Long = builder.occurrencesThreshold
    /**
     * The severity to assign to a finding: if the number of occurrences is greater than or equal to the specified threshold (occurrencesThreshold); and, if applicable, the number of occurrences is less than the threshold for the next consecutive severity level for the custom data identifier, moving from LOW to HIGH.
     */
    public val severity: aws.sdk.kotlin.services.macie2.model.DataIdentifierSeverity? = builder.severity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.SeverityLevel = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SeverityLevel(")
        append("occurrencesThreshold=$occurrencesThreshold,")
        append("severity=$severity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = occurrencesThreshold.hashCode()
        result = 31 * result + (severity?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SeverityLevel

        if (occurrencesThreshold != other.occurrencesThreshold) return false
        if (severity != other.severity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.SeverityLevel = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The minimum number of occurrences of text that must match the custom data identifier's detection criteria in order to produce a finding with the specified severity (severity).
         */
        public var occurrencesThreshold: kotlin.Long = 0L
        /**
         * The severity to assign to a finding: if the number of occurrences is greater than or equal to the specified threshold (occurrencesThreshold); and, if applicable, the number of occurrences is less than the threshold for the next consecutive severity level for the custom data identifier, moving from LOW to HIGH.
         */
        public var severity: aws.sdk.kotlin.services.macie2.model.DataIdentifierSeverity? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.SeverityLevel) : this() {
            this.occurrencesThreshold = x.occurrencesThreshold
            this.severity = x.severity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.SeverityLevel = SeverityLevel(this)
    }
}
