// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Specifies a property-based condition that determines whether an S3 bucket is included or excluded from a classification job.
 */
public class SimpleCriterionForJob private constructor(builder: Builder) {
    /**
     * The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).
     */
    public val comparator: aws.sdk.kotlin.services.macie2.model.JobComparator? = builder.comparator
    /**
     * The property to use in the condition.
     */
    public val key: aws.sdk.kotlin.services.macie2.model.SimpleCriterionKeyForJob? = builder.key
    /**
     * An array that lists one or more values to use in the condition. If you specify multiple values, Amazon Macie uses OR logic to join the values. Valid values for each supported property (key) are:
     * + ACCOUNT_ID - A string that represents the unique identifier for the Amazon Web Services account that owns the bucket.
     * + S3_BUCKET_EFFECTIVE_PERMISSION - A string that represents an enumerated value that Macie defines for the [BucketPublicAccess.effectivePermission](https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketpublicaccess-effectivepermission) property of a bucket.
     * + S3_BUCKET_NAME - A string that represents the name of a bucket.
     * + S3_BUCKET_SHARED_ACCESS - A string that represents an enumerated value that Macie defines for the [BucketMetadata.sharedAccess](https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketmetadata-sharedaccess) property of a bucket.
     *
     * Values are case sensitive. Also, Macie doesn't support use of partial values or wildcard characters in these values.
     */
    public val values: List<String>? = builder.values

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.SimpleCriterionForJob = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SimpleCriterionForJob(")
        append("comparator=$comparator,")
        append("key=$key,")
        append("values=$values)")
    }

    override fun hashCode(): kotlin.Int {
        var result = comparator?.hashCode() ?: 0
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SimpleCriterionForJob

        if (comparator != other.comparator) return false
        if (key != other.key) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.SimpleCriterionForJob = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).
         */
        public var comparator: aws.sdk.kotlin.services.macie2.model.JobComparator? = null
        /**
         * The property to use in the condition.
         */
        public var key: aws.sdk.kotlin.services.macie2.model.SimpleCriterionKeyForJob? = null
        /**
         * An array that lists one or more values to use in the condition. If you specify multiple values, Amazon Macie uses OR logic to join the values. Valid values for each supported property (key) are:
         * + ACCOUNT_ID - A string that represents the unique identifier for the Amazon Web Services account that owns the bucket.
         * + S3_BUCKET_EFFECTIVE_PERMISSION - A string that represents an enumerated value that Macie defines for the [BucketPublicAccess.effectivePermission](https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketpublicaccess-effectivepermission) property of a bucket.
         * + S3_BUCKET_NAME - A string that represents the name of a bucket.
         * + S3_BUCKET_SHARED_ACCESS - A string that represents an enumerated value that Macie defines for the [BucketMetadata.sharedAccess](https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketmetadata-sharedaccess) property of a bucket.
         *
         * Values are case sensitive. Also, Macie doesn't support use of partial values or wildcard characters in these values.
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.SimpleCriterionForJob) : this() {
            this.comparator = x.comparator
            this.key = x.key
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.SimpleCriterionForJob = SimpleCriterionForJob(this)
    }
}
