// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Specifies a property-based condition that determines whether an S3 object is included or excluded from a classification job.
 */
public class SimpleScopeTerm private constructor(builder: Builder) {
    /**
     * The operator to use in the condition. Valid values for each supported property (key) are:
     * + OBJECT_EXTENSION - EQ (equals) or NE (not equals)
     * + OBJECT_KEY - STARTS_WITH
     * + OBJECT_LAST_MODIFIED_DATE - Any operator except CONTAINS
     * + OBJECT_SIZE - Any operator except CONTAINS
     */
    public val comparator: aws.sdk.kotlin.services.macie2.model.JobComparator? = builder.comparator
    /**
     * The object property to use in the condition.
     */
    public val key: aws.sdk.kotlin.services.macie2.model.ScopeFilterKey? = builder.key
    /**
     * An array that lists the values to use in the condition. If the value for the key property is OBJECT_EXTENSION or OBJECT_KEY, this array can specify multiple values and Amazon Macie uses OR logic to join the values. Otherwise, this array can specify only one value.
     *
     * Valid values for each supported property (key) are:
     * + OBJECT_EXTENSION - A string that represents the file name extension of an object. For example: docx or pdf
     * + OBJECT_KEY - A string that represents the key prefix (folder name or path) of an object. For example: logs or awslogs/eventlogs. This value applies a condition to objects whose keys (names) begin with the specified value.
     * + OBJECT_LAST_MODIFIED_DATE - The date and time (in UTC and extended ISO 8601 format) when an object was created or last changed, whichever is latest. For example: 2020-09-28T14:31:13Z
     * + OBJECT_SIZE - An integer that represents the storage size (in bytes) of an object.
     *
     * Macie doesn't support use of wildcard characters in these values. Also, string values are case sensitive.
     */
    public val values: List<String>? = builder.values

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.SimpleScopeTerm = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SimpleScopeTerm(")
        append("comparator=$comparator,")
        append("key=$key,")
        append("values=$values)")
    }

    override fun hashCode(): kotlin.Int {
        var result = comparator?.hashCode() ?: 0
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SimpleScopeTerm

        if (comparator != other.comparator) return false
        if (key != other.key) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.SimpleScopeTerm = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The operator to use in the condition. Valid values for each supported property (key) are:
         * + OBJECT_EXTENSION - EQ (equals) or NE (not equals)
         * + OBJECT_KEY - STARTS_WITH
         * + OBJECT_LAST_MODIFIED_DATE - Any operator except CONTAINS
         * + OBJECT_SIZE - Any operator except CONTAINS
         */
        public var comparator: aws.sdk.kotlin.services.macie2.model.JobComparator? = null
        /**
         * The object property to use in the condition.
         */
        public var key: aws.sdk.kotlin.services.macie2.model.ScopeFilterKey? = null
        /**
         * An array that lists the values to use in the condition. If the value for the key property is OBJECT_EXTENSION or OBJECT_KEY, this array can specify multiple values and Amazon Macie uses OR logic to join the values. Otherwise, this array can specify only one value.
         *
         * Valid values for each supported property (key) are:
         * + OBJECT_EXTENSION - A string that represents the file name extension of an object. For example: docx or pdf
         * + OBJECT_KEY - A string that represents the key prefix (folder name or path) of an object. For example: logs or awslogs/eventlogs. This value applies a condition to objects whose keys (names) begin with the specified value.
         * + OBJECT_LAST_MODIFIED_DATE - The date and time (in UTC and extended ISO 8601 format) when an object was created or last changed, whichever is latest. For example: 2020-09-28T14:31:13Z
         * + OBJECT_SIZE - An integer that represents the storage size (in bytes) of an object.
         *
         * Macie doesn't support use of wildcard characters in these values. Also, string values are case sensitive.
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.SimpleScopeTerm) : this() {
            this.comparator = x.comparator
            this.key = x.key
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.SimpleScopeTerm = SimpleScopeTerm(this)
    }
}
