// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



public class UpdateFindingsFilterRequest private constructor(builder: Builder) {
    /**
     * The action to perform on findings that meet the filter criteria (findingCriteria). Valid values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.
     */
    public val action: aws.sdk.kotlin.services.macie2.model.FindingsFilterAction? = builder.action
    /**
     * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * A custom description of the filter. The description can contain as many as 512 characters.
     *
     * We strongly recommend that you avoid including any sensitive data in the description of a filter. Other users might be able to see this description, depending on the actions that they're allowed to perform in Amazon Macie.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The criteria to use to filter findings.
     */
    public val findingCriteria: aws.sdk.kotlin.services.macie2.model.FindingCriteria? = builder.findingCriteria
    /**
     * The unique identifier for the Amazon Macie resource that the request applies to.
     */
    public val id: kotlin.String? = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64 characters.
     *
     * We strongly recommend that you avoid including any sensitive data in the name of a filter. Other users might be able to see this name, depending on the actions that they're allowed to perform in Amazon Macie.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.
     */
    public val position: kotlin.Int = builder.position

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.UpdateFindingsFilterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateFindingsFilterRequest(")
        append("action=$action,")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("findingCriteria=$findingCriteria,")
        append("id=$id,")
        append("name=$name,")
        append("position=$position)")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (findingCriteria?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (position)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateFindingsFilterRequest

        if (action != other.action) return false
        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (findingCriteria != other.findingCriteria) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (position != other.position) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.UpdateFindingsFilterRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The action to perform on findings that meet the filter criteria (findingCriteria). Valid values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.
         */
        public var action: aws.sdk.kotlin.services.macie2.model.FindingsFilterAction? = null
        /**
         * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
         */
        public var clientToken: kotlin.String? = null
        /**
         * A custom description of the filter. The description can contain as many as 512 characters.
         *
         * We strongly recommend that you avoid including any sensitive data in the description of a filter. Other users might be able to see this description, depending on the actions that they're allowed to perform in Amazon Macie.
         */
        public var description: kotlin.String? = null
        /**
         * The criteria to use to filter findings.
         */
        public var findingCriteria: aws.sdk.kotlin.services.macie2.model.FindingCriteria? = null
        /**
         * The unique identifier for the Amazon Macie resource that the request applies to.
         */
        public var id: kotlin.String? = null
        /**
         * A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64 characters.
         *
         * We strongly recommend that you avoid including any sensitive data in the name of a filter. Other users might be able to see this name, depending on the actions that they're allowed to perform in Amazon Macie.
         */
        public var name: kotlin.String? = null
        /**
         * The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.
         */
        public var position: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.UpdateFindingsFilterRequest) : this() {
            this.action = x.action
            this.clientToken = x.clientToken
            this.description = x.description
            this.findingCriteria = x.findingCriteria
            this.id = x.id
            this.name = x.name
            this.position = x.position
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.UpdateFindingsFilterRequest = UpdateFindingsFilterRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.FindingCriteria] inside the given [block]
         */
        public fun findingCriteria(block: aws.sdk.kotlin.services.macie2.model.FindingCriteria.Builder.() -> kotlin.Unit) {
            this.findingCriteria = aws.sdk.kotlin.services.macie2.model.FindingCriteria.invoke(block)
        }
    }
}
