// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides quota and aggregated usage data for an Amazon Macie account.
 */
public class UsageRecord private constructor(builder: Builder) {
    /**
     * The unique identifier for the Amazon Web Services account that the data applies to.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The date and time, in UTC and extended ISO 8601 format, when the free trial started for the account.
     */
    public val freeTrialStartDate: aws.smithy.kotlin.runtime.time.Instant? = builder.freeTrialStartDate
    /**
     * An array of objects that contains usage data and quotas for the account. Each object contains the data for a specific usage metric and the corresponding quota.
     */
    public val usage: List<UsageByAccount>? = builder.usage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.UsageRecord = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UsageRecord(")
        append("accountId=$accountId,")
        append("freeTrialStartDate=$freeTrialStartDate,")
        append("usage=$usage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (freeTrialStartDate?.hashCode() ?: 0)
        result = 31 * result + (usage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UsageRecord

        if (accountId != other.accountId) return false
        if (freeTrialStartDate != other.freeTrialStartDate) return false
        if (usage != other.usage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.UsageRecord = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique identifier for the Amazon Web Services account that the data applies to.
         */
        public var accountId: kotlin.String? = null
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the free trial started for the account.
         */
        public var freeTrialStartDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An array of objects that contains usage data and quotas for the account. Each object contains the data for a specific usage metric and the corresponding quota.
         */
        public var usage: List<UsageByAccount>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.UsageRecord) : this() {
            this.accountId = x.accountId
            this.freeTrialStartDate = x.freeTrialStartDate
            this.usage = x.usage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.UsageRecord = UsageRecord(this)
    }
}
