// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Specifies a condition for filtering the results of a query for quota and usage data for one or more Amazon Macie accounts.
 */
public class UsageStatisticsFilter private constructor(builder: Builder) {
    /**
     * The operator to use in the condition. If the value for the key property is accountId, this value must be CONTAINS. If the value for the key property is any other supported field, this value can be EQ, GT, GTE, LT, LTE, or NE.
     */
    public val comparator: aws.sdk.kotlin.services.macie2.model.UsageStatisticsFilterComparator? = builder.comparator
    /**
     * The field to use in the condition.
     */
    public val key: aws.sdk.kotlin.services.macie2.model.UsageStatisticsFilterKey? = builder.key
    /**
     * An array that lists values to use in the condition, based on the value for the field specified by the key property. If the value for the key property is accountId, this array can specify multiple values. Otherwise, this array can specify only one value.
     *
     * Valid values for each supported field are:
     * + accountId - The unique identifier for an Amazon Web Services account.
     * + freeTrialStartDate - The date and time, in UTC and extended ISO 8601 format, when the free trial started for an account.
     * + serviceLimit - A Boolean (true or false) value that indicates whether an account has reached its monthly quota.
     * + total - A string that represents the current estimated cost for an account.
     */
    public val values: List<String>? = builder.values

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.UsageStatisticsFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UsageStatisticsFilter(")
        append("comparator=$comparator,")
        append("key=$key,")
        append("values=$values)")
    }

    override fun hashCode(): kotlin.Int {
        var result = comparator?.hashCode() ?: 0
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UsageStatisticsFilter

        if (comparator != other.comparator) return false
        if (key != other.key) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.UsageStatisticsFilter = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The operator to use in the condition. If the value for the key property is accountId, this value must be CONTAINS. If the value for the key property is any other supported field, this value can be EQ, GT, GTE, LT, LTE, or NE.
         */
        public var comparator: aws.sdk.kotlin.services.macie2.model.UsageStatisticsFilterComparator? = null
        /**
         * The field to use in the condition.
         */
        public var key: aws.sdk.kotlin.services.macie2.model.UsageStatisticsFilterKey? = null
        /**
         * An array that lists values to use in the condition, based on the value for the field specified by the key property. If the value for the key property is accountId, this array can specify multiple values. Otherwise, this array can specify only one value.
         *
         * Valid values for each supported field are:
         * + accountId - The unique identifier for an Amazon Web Services account.
         * + freeTrialStartDate - The date and time, in UTC and extended ISO 8601 format, when the free trial started for an account.
         * + serviceLimit - A Boolean (true or false) value that indicates whether an account has reached its monthly quota.
         * + total - A string that represents the current estimated cost for an account.
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.UsageStatisticsFilter) : this() {
            this.comparator = x.comparator
            this.key = x.key
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.UsageStatisticsFilter = UsageStatisticsFilter(this)
    }
}
