// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides aggregated data for an Amazon Macie usage metric. The value for the metric reports estimated usage data for an account for the preceding 30 days or the current calendar month to date, depending on the time period (timeRange) specified in the request.
 */
public class UsageTotal private constructor(builder: Builder) {
    /**
     * The type of currency that the value for the metric (estimatedCost) is reported in.
     */
    public val currency: aws.sdk.kotlin.services.macie2.model.Currency? = builder.currency
    /**
     * The estimated value for the metric.
     */
    public val estimatedCost: kotlin.String? = builder.estimatedCost
    /**
     * The name of the metric. Possible values are: DATA_INVENTORY_EVALUATION, for monitoring S3 buckets; and, SENSITIVE_DATA_DISCOVERY, for analyzing S3 objects to detect sensitive data.
     */
    public val type: aws.sdk.kotlin.services.macie2.model.UsageType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.UsageTotal = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UsageTotal(")
        append("currency=$currency,")
        append("estimatedCost=$estimatedCost,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = currency?.hashCode() ?: 0
        result = 31 * result + (estimatedCost?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UsageTotal

        if (currency != other.currency) return false
        if (estimatedCost != other.estimatedCost) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.UsageTotal = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The type of currency that the value for the metric (estimatedCost) is reported in.
         */
        public var currency: aws.sdk.kotlin.services.macie2.model.Currency? = null
        /**
         * The estimated value for the metric.
         */
        public var estimatedCost: kotlin.String? = null
        /**
         * The name of the metric. Possible values are: DATA_INVENTORY_EVALUATION, for monitoring S3 buckets; and, SENSITIVE_DATA_DISCOVERY, for analyzing S3 objects to detect sensitive data.
         */
        public var type: aws.sdk.kotlin.services.macie2.model.UsageType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.UsageTotal) : this() {
            this.currency = x.currency
            this.estimatedCost = x.estimatedCost
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.UsageTotal = UsageTotal(this)
    }
}
