// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about the type and other characteristics of an entity that performed an action on an affected resource.
 */
public class UserIdentity private constructor(builder: Builder) {
    /**
     * If the action was performed with temporary security credentials that were obtained using the AssumeRole operation of the Security Token Service (STS) API, the identifiers, session context, and other details about the identity.
     */
    public val assumedRole: aws.sdk.kotlin.services.macie2.model.AssumedRole? = builder.assumedRole
    /**
     * If the action was performed using the credentials for another Amazon Web Services account, the details of that account.
     */
    public val awsAccount: aws.sdk.kotlin.services.macie2.model.AwsAccount? = builder.awsAccount
    /**
     * If the action was performed by an Amazon Web Services account that belongs to an Amazon Web Service, the name of the service.
     */
    public val awsService: aws.sdk.kotlin.services.macie2.model.AwsService? = builder.awsService
    /**
     * If the action was performed with temporary security credentials that were obtained using the GetFederationToken operation of the Security Token Service (STS) API, the identifiers, session context, and other details about the identity.
     */
    public val federatedUser: aws.sdk.kotlin.services.macie2.model.FederatedUser? = builder.federatedUser
    /**
     * If the action was performed using the credentials for an Identity and Access Management (IAM) user, the name and other details about the user.
     */
    public val iamUser: aws.sdk.kotlin.services.macie2.model.IamUser? = builder.iamUser
    /**
     * If the action was performed using the credentials for your Amazon Web Services account, the details of your account.
     */
    public val root: aws.sdk.kotlin.services.macie2.model.UserIdentityRoot? = builder.root
    /**
     * The type of entity that performed the action.
     */
    public val type: aws.sdk.kotlin.services.macie2.model.UserIdentityType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.UserIdentity = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UserIdentity(")
        append("assumedRole=$assumedRole,")
        append("awsAccount=$awsAccount,")
        append("awsService=$awsService,")
        append("federatedUser=$federatedUser,")
        append("iamUser=$iamUser,")
        append("root=$root,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assumedRole?.hashCode() ?: 0
        result = 31 * result + (awsAccount?.hashCode() ?: 0)
        result = 31 * result + (awsService?.hashCode() ?: 0)
        result = 31 * result + (federatedUser?.hashCode() ?: 0)
        result = 31 * result + (iamUser?.hashCode() ?: 0)
        result = 31 * result + (root?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UserIdentity

        if (assumedRole != other.assumedRole) return false
        if (awsAccount != other.awsAccount) return false
        if (awsService != other.awsService) return false
        if (federatedUser != other.federatedUser) return false
        if (iamUser != other.iamUser) return false
        if (root != other.root) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.UserIdentity = Builder(this).apply(block).build()

    public class Builder {
        /**
         * If the action was performed with temporary security credentials that were obtained using the AssumeRole operation of the Security Token Service (STS) API, the identifiers, session context, and other details about the identity.
         */
        public var assumedRole: aws.sdk.kotlin.services.macie2.model.AssumedRole? = null
        /**
         * If the action was performed using the credentials for another Amazon Web Services account, the details of that account.
         */
        public var awsAccount: aws.sdk.kotlin.services.macie2.model.AwsAccount? = null
        /**
         * If the action was performed by an Amazon Web Services account that belongs to an Amazon Web Service, the name of the service.
         */
        public var awsService: aws.sdk.kotlin.services.macie2.model.AwsService? = null
        /**
         * If the action was performed with temporary security credentials that were obtained using the GetFederationToken operation of the Security Token Service (STS) API, the identifiers, session context, and other details about the identity.
         */
        public var federatedUser: aws.sdk.kotlin.services.macie2.model.FederatedUser? = null
        /**
         * If the action was performed using the credentials for an Identity and Access Management (IAM) user, the name and other details about the user.
         */
        public var iamUser: aws.sdk.kotlin.services.macie2.model.IamUser? = null
        /**
         * If the action was performed using the credentials for your Amazon Web Services account, the details of your account.
         */
        public var root: aws.sdk.kotlin.services.macie2.model.UserIdentityRoot? = null
        /**
         * The type of entity that performed the action.
         */
        public var type: aws.sdk.kotlin.services.macie2.model.UserIdentityType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.UserIdentity) : this() {
            this.assumedRole = x.assumedRole
            this.awsAccount = x.awsAccount
            this.awsService = x.awsService
            this.federatedUser = x.federatedUser
            this.iamUser = x.iamUser
            this.root = x.root
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.UserIdentity = UserIdentity(this)

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.AssumedRole] inside the given [block]
         */
        public fun assumedRole(block: aws.sdk.kotlin.services.macie2.model.AssumedRole.Builder.() -> kotlin.Unit) {
            this.assumedRole = aws.sdk.kotlin.services.macie2.model.AssumedRole.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.AwsAccount] inside the given [block]
         */
        public fun awsAccount(block: aws.sdk.kotlin.services.macie2.model.AwsAccount.Builder.() -> kotlin.Unit) {
            this.awsAccount = aws.sdk.kotlin.services.macie2.model.AwsAccount.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.AwsService] inside the given [block]
         */
        public fun awsService(block: aws.sdk.kotlin.services.macie2.model.AwsService.Builder.() -> kotlin.Unit) {
            this.awsService = aws.sdk.kotlin.services.macie2.model.AwsService.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.FederatedUser] inside the given [block]
         */
        public fun federatedUser(block: aws.sdk.kotlin.services.macie2.model.FederatedUser.Builder.() -> kotlin.Unit) {
            this.federatedUser = aws.sdk.kotlin.services.macie2.model.FederatedUser.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.IamUser] inside the given [block]
         */
        public fun iamUser(block: aws.sdk.kotlin.services.macie2.model.IamUser.Builder.() -> kotlin.Unit) {
            this.iamUser = aws.sdk.kotlin.services.macie2.model.IamUser.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.UserIdentityRoot] inside the given [block]
         */
        public fun root(block: aws.sdk.kotlin.services.macie2.model.UserIdentityRoot.Builder.() -> kotlin.Unit) {
            this.root = aws.sdk.kotlin.services.macie2.model.UserIdentityRoot.invoke(block)
        }
    }
}
