// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about an Amazon Web Services account and entity that performed an action on an affected resource. The action was performed using the credentials for your Amazon Web Services account.
 */
public class UserIdentityRoot private constructor(builder: Builder) {
    /**
     * The unique identifier for the Amazon Web Services account.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The Amazon Resource Name (ARN) of the principal that performed the action. The last section of the ARN contains the name of the user or role that performed the action.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The unique identifier for the entity that performed the action.
     */
    public val principalId: kotlin.String? = builder.principalId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.UserIdentityRoot = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UserIdentityRoot(")
        append("accountId=$accountId,")
        append("arn=$arn,")
        append("principalId=$principalId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (principalId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UserIdentityRoot

        if (accountId != other.accountId) return false
        if (arn != other.arn) return false
        if (principalId != other.principalId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.UserIdentityRoot = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique identifier for the Amazon Web Services account.
         */
        public var accountId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the principal that performed the action. The last section of the ARN contains the name of the user or role that performed the action.
         */
        public var arn: kotlin.String? = null
        /**
         * The unique identifier for the entity that performed the action.
         */
        public var principalId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.UserIdentityRoot) : this() {
            this.accountId = x.accountId
            this.arn = x.arn
            this.principalId = x.principalId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.UserIdentityRoot = UserIdentityRoot(this)
    }
}
