// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information about when a classification job was paused. For a one-time job, this object also specifies when the job will expire and be cancelled if it isn't resumed. For a recurring job, this object also specifies when the paused job run will expire and be cancelled if it isn't resumed. This object is present only if a job's current status (jobStatus) is USER_PAUSED. The information in this object applies only to a job that was paused while it had a status of RUNNING.
 */
public class UserPausedDetails private constructor(builder: Builder) {
    /**
     * The date and time, in UTC and extended ISO 8601 format, when the job or job run will expire and be cancelled if you don't resume it first.
     */
    public val jobExpiresAt: aws.smithy.kotlin.runtime.time.Instant? = builder.jobExpiresAt
    /**
     * The Amazon Resource Name (ARN) of the Health event that Amazon Macie sent to notify you of the job or job run's pending expiration and cancellation. This value is null if a job has been paused for less than 23 days.
     */
    public val jobImminentExpirationHealthEventArn: kotlin.String? = builder.jobImminentExpirationHealthEventArn
    /**
     * The date and time, in UTC and extended ISO 8601 format, when you paused the job.
     */
    public val jobPausedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.jobPausedAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.UserPausedDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UserPausedDetails(")
        append("jobExpiresAt=$jobExpiresAt,")
        append("jobImminentExpirationHealthEventArn=$jobImminentExpirationHealthEventArn,")
        append("jobPausedAt=$jobPausedAt)")
    }

    override fun hashCode(): kotlin.Int {
        var result = jobExpiresAt?.hashCode() ?: 0
        result = 31 * result + (jobImminentExpirationHealthEventArn?.hashCode() ?: 0)
        result = 31 * result + (jobPausedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UserPausedDetails

        if (jobExpiresAt != other.jobExpiresAt) return false
        if (jobImminentExpirationHealthEventArn != other.jobImminentExpirationHealthEventArn) return false
        if (jobPausedAt != other.jobPausedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.UserPausedDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the job or job run will expire and be cancelled if you don't resume it first.
         */
        public var jobExpiresAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the Health event that Amazon Macie sent to notify you of the job or job run's pending expiration and cancellation. This value is null if a job has been paused for less than 23 days.
         */
        public var jobImminentExpirationHealthEventArn: kotlin.String? = null
        /**
         * The date and time, in UTC and extended ISO 8601 format, when you paused the job.
         */
        public var jobPausedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.UserPausedDetails) : this() {
            this.jobExpiresAt = x.jobExpiresAt
            this.jobImminentExpirationHealthEventArn = x.jobImminentExpirationHealthEventArn
            this.jobPausedAt = x.jobPausedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.UserPausedDetails = UserPausedDetails(this)
    }
}
