// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.paginators

import aws.sdk.kotlin.services.macie2.Macie2Client
import aws.sdk.kotlin.services.macie2.model.AdminAccount
import aws.sdk.kotlin.services.macie2.model.BucketMetadata
import aws.sdk.kotlin.services.macie2.model.CustomDataIdentifierSummary
import aws.sdk.kotlin.services.macie2.model.DescribeBucketsRequest
import aws.sdk.kotlin.services.macie2.model.DescribeBucketsResponse
import aws.sdk.kotlin.services.macie2.model.FindingsFilterListItem
import aws.sdk.kotlin.services.macie2.model.GetUsageStatisticsRequest
import aws.sdk.kotlin.services.macie2.model.GetUsageStatisticsResponse
import aws.sdk.kotlin.services.macie2.model.Invitation
import aws.sdk.kotlin.services.macie2.model.JobSummary
import aws.sdk.kotlin.services.macie2.model.ListClassificationJobsRequest
import aws.sdk.kotlin.services.macie2.model.ListClassificationJobsResponse
import aws.sdk.kotlin.services.macie2.model.ListCustomDataIdentifiersRequest
import aws.sdk.kotlin.services.macie2.model.ListCustomDataIdentifiersResponse
import aws.sdk.kotlin.services.macie2.model.ListFindingsFiltersRequest
import aws.sdk.kotlin.services.macie2.model.ListFindingsFiltersResponse
import aws.sdk.kotlin.services.macie2.model.ListFindingsRequest
import aws.sdk.kotlin.services.macie2.model.ListFindingsResponse
import aws.sdk.kotlin.services.macie2.model.ListInvitationsRequest
import aws.sdk.kotlin.services.macie2.model.ListInvitationsResponse
import aws.sdk.kotlin.services.macie2.model.ListMembersRequest
import aws.sdk.kotlin.services.macie2.model.ListMembersResponse
import aws.sdk.kotlin.services.macie2.model.ListOrganizationAdminAccountsRequest
import aws.sdk.kotlin.services.macie2.model.ListOrganizationAdminAccountsResponse
import aws.sdk.kotlin.services.macie2.model.MatchingResource
import aws.sdk.kotlin.services.macie2.model.Member
import aws.sdk.kotlin.services.macie2.model.SearchResourcesRequest
import aws.sdk.kotlin.services.macie2.model.SearchResourcesResponse
import aws.sdk.kotlin.services.macie2.model.UsageRecord
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeBucketsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeBucketsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeBucketsResponse]
 */
public fun Macie2Client.describeBucketsPaginated(initialRequest: DescribeBucketsRequest): Flow<DescribeBucketsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeBucketsPaginated.describeBuckets(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeBucketsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeBucketsResponse]
 */
public fun Macie2Client.describeBucketsPaginated(block: DescribeBucketsRequest.Builder.() -> Unit): Flow<DescribeBucketsResponse> =
    describeBucketsPaginated(DescribeBucketsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeBucketsPaginated]
 * to access the nested member [BucketMetadata]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [BucketMetadata]
 */
@JvmName("describeBucketsResponseBucketMetadata")
public fun Flow<DescribeBucketsResponse>.buckets(): Flow<BucketMetadata> =
    transform() { response ->
        response.buckets?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetUsageStatisticsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetUsageStatisticsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetUsageStatisticsResponse]
 */
public fun Macie2Client.getUsageStatisticsPaginated(initialRequest: GetUsageStatisticsRequest): Flow<GetUsageStatisticsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getUsageStatisticsPaginated.getUsageStatistics(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetUsageStatisticsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetUsageStatisticsResponse]
 */
public fun Macie2Client.getUsageStatisticsPaginated(block: GetUsageStatisticsRequest.Builder.() -> Unit): Flow<GetUsageStatisticsResponse> =
    getUsageStatisticsPaginated(GetUsageStatisticsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getUsageStatisticsPaginated]
 * to access the nested member [UsageRecord]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [UsageRecord]
 */
@JvmName("getUsageStatisticsResponseUsageRecord")
public fun Flow<GetUsageStatisticsResponse>.records(): Flow<UsageRecord> =
    transform() { response ->
        response.records?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListClassificationJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListClassificationJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClassificationJobsResponse]
 */
public fun Macie2Client.listClassificationJobsPaginated(initialRequest: ListClassificationJobsRequest): Flow<ListClassificationJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listClassificationJobsPaginated.listClassificationJobs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListClassificationJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClassificationJobsResponse]
 */
public fun Macie2Client.listClassificationJobsPaginated(block: ListClassificationJobsRequest.Builder.() -> Unit): Flow<ListClassificationJobsResponse> =
    listClassificationJobsPaginated(ListClassificationJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listClassificationJobsPaginated]
 * to access the nested member [JobSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [JobSummary]
 */
@JvmName("listClassificationJobsResponseJobSummary")
public fun Flow<ListClassificationJobsResponse>.items(): Flow<JobSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListCustomDataIdentifiersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCustomDataIdentifiersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCustomDataIdentifiersResponse]
 */
public fun Macie2Client.listCustomDataIdentifiersPaginated(initialRequest: ListCustomDataIdentifiersRequest): Flow<ListCustomDataIdentifiersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCustomDataIdentifiersPaginated.listCustomDataIdentifiers(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListCustomDataIdentifiersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCustomDataIdentifiersResponse]
 */
public fun Macie2Client.listCustomDataIdentifiersPaginated(block: ListCustomDataIdentifiersRequest.Builder.() -> Unit): Flow<ListCustomDataIdentifiersResponse> =
    listCustomDataIdentifiersPaginated(ListCustomDataIdentifiersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCustomDataIdentifiersPaginated]
 * to access the nested member [CustomDataIdentifierSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CustomDataIdentifierSummary]
 */
@JvmName("listCustomDataIdentifiersResponseCustomDataIdentifierSummary")
public fun Flow<ListCustomDataIdentifiersResponse>.items(): Flow<CustomDataIdentifierSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListFindingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFindingsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFindingsResponse]
 */
public fun Macie2Client.listFindingsPaginated(initialRequest: ListFindingsRequest): Flow<ListFindingsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFindingsPaginated.listFindings(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListFindingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFindingsResponse]
 */
public fun Macie2Client.listFindingsPaginated(block: ListFindingsRequest.Builder.() -> Unit): Flow<ListFindingsResponse> =
    listFindingsPaginated(ListFindingsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFindingsPaginated]
 * to access the nested member [String]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [String]
 */
@JvmName("listFindingsResponseString")
public fun Flow<ListFindingsResponse>.findingIds(): Flow<String> =
    transform() { response ->
        response.findingIds?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListFindingsFiltersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFindingsFiltersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFindingsFiltersResponse]
 */
public fun Macie2Client.listFindingsFiltersPaginated(initialRequest: ListFindingsFiltersRequest): Flow<ListFindingsFiltersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFindingsFiltersPaginated.listFindingsFilters(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListFindingsFiltersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFindingsFiltersResponse]
 */
public fun Macie2Client.listFindingsFiltersPaginated(block: ListFindingsFiltersRequest.Builder.() -> Unit): Flow<ListFindingsFiltersResponse> =
    listFindingsFiltersPaginated(ListFindingsFiltersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFindingsFiltersPaginated]
 * to access the nested member [FindingsFilterListItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FindingsFilterListItem]
 */
@JvmName("listFindingsFiltersResponseFindingsFilterListItem")
public fun Flow<ListFindingsFiltersResponse>.findingsFilterListItems(): Flow<FindingsFilterListItem> =
    transform() { response ->
        response.findingsFilterListItems?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListInvitationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListInvitationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInvitationsResponse]
 */
public fun Macie2Client.listInvitationsPaginated(initialRequest: ListInvitationsRequest): Flow<ListInvitationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listInvitationsPaginated.listInvitations(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListInvitationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInvitationsResponse]
 */
public fun Macie2Client.listInvitationsPaginated(block: ListInvitationsRequest.Builder.() -> Unit): Flow<ListInvitationsResponse> =
    listInvitationsPaginated(ListInvitationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listInvitationsPaginated]
 * to access the nested member [Invitation]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Invitation]
 */
@JvmName("listInvitationsResponseInvitation")
public fun Flow<ListInvitationsResponse>.invitations(): Flow<Invitation> =
    transform() { response ->
        response.invitations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListMembersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMembersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMembersResponse]
 */
public fun Macie2Client.listMembersPaginated(initialRequest: ListMembersRequest): Flow<ListMembersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMembersPaginated.listMembers(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListMembersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMembersResponse]
 */
public fun Macie2Client.listMembersPaginated(block: ListMembersRequest.Builder.() -> Unit): Flow<ListMembersResponse> =
    listMembersPaginated(ListMembersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listMembersPaginated]
 * to access the nested member [Member]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Member]
 */
@JvmName("listMembersResponseMember")
public fun Flow<ListMembersResponse>.members(): Flow<Member> =
    transform() { response ->
        response.members?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListOrganizationAdminAccountsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListOrganizationAdminAccountsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOrganizationAdminAccountsResponse]
 */
public fun Macie2Client.listOrganizationAdminAccountsPaginated(initialRequest: ListOrganizationAdminAccountsRequest): Flow<ListOrganizationAdminAccountsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listOrganizationAdminAccountsPaginated.listOrganizationAdminAccounts(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListOrganizationAdminAccountsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOrganizationAdminAccountsResponse]
 */
public fun Macie2Client.listOrganizationAdminAccountsPaginated(block: ListOrganizationAdminAccountsRequest.Builder.() -> Unit): Flow<ListOrganizationAdminAccountsResponse> =
    listOrganizationAdminAccountsPaginated(ListOrganizationAdminAccountsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listOrganizationAdminAccountsPaginated]
 * to access the nested member [AdminAccount]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AdminAccount]
 */
@JvmName("listOrganizationAdminAccountsResponseAdminAccount")
public fun Flow<ListOrganizationAdminAccountsResponse>.adminAccounts(): Flow<AdminAccount> =
    transform() { response ->
        response.adminAccounts?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [SearchResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SearchResourcesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchResourcesResponse]
 */
public fun Macie2Client.searchResourcesPaginated(initialRequest: SearchResourcesRequest): Flow<SearchResourcesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@searchResourcesPaginated.searchResources(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [SearchResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchResourcesResponse]
 */
public fun Macie2Client.searchResourcesPaginated(block: SearchResourcesRequest.Builder.() -> Unit): Flow<SearchResourcesResponse> =
    searchResourcesPaginated(SearchResourcesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [searchResourcesPaginated]
 * to access the nested member [MatchingResource]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [MatchingResource]
 */
@JvmName("searchResourcesResponseMatchingResource")
public fun Flow<SearchResourcesResponse>.matchingResources(): Flow<MatchingResource> =
    transform() { response ->
        response.matchingResources?.forEach {
            emit(it)
        }
    }
