// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.macie2.model.BatchGetCustomDataIdentifierSummary
import aws.sdk.kotlin.services.macie2.model.BatchGetCustomDataIdentifiersResponse
import aws.sdk.kotlin.services.macie2.model.Macie2Exception
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class BatchGetCustomDataIdentifiersOperationDeserializer: HttpDeserialize<BatchGetCustomDataIdentifiersResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): BatchGetCustomDataIdentifiersResponse {
        if (!response.status.isSuccess()) {
            throwBatchGetCustomDataIdentifiersError(context, response)
        }
        val builder = BatchGetCustomDataIdentifiersResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchGetCustomDataIdentifiersOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwBatchGetCustomDataIdentifiersError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw Macie2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> Macie2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchGetCustomDataIdentifiersOperationBody(builder: BatchGetCustomDataIdentifiersResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CUSTOMDATAIDENTIFIERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("customDataIdentifiers"))
    val NOTFOUNDIDENTIFIERIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("notFoundIdentifierIds"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CUSTOMDATAIDENTIFIERS_DESCRIPTOR)
        field(NOTFOUNDIDENTIFIERIDS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CUSTOMDATAIDENTIFIERS_DESCRIPTOR.index -> builder.customDataIdentifiers =
                    deserializer.deserializeList(CUSTOMDATAIDENTIFIERS_DESCRIPTOR) {
                        val col0 = mutableListOf<BatchGetCustomDataIdentifierSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBatchGetCustomDataIdentifierSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NOTFOUNDIDENTIFIERIDS_DESCRIPTOR.index -> builder.notFoundIdentifierIds =
                    deserializer.deserializeList(NOTFOUNDIDENTIFIERIDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
