// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.macie2.model.DescribeClassificationJobResponse
import aws.sdk.kotlin.services.macie2.model.JobScheduleFrequency
import aws.sdk.kotlin.services.macie2.model.JobStatus
import aws.sdk.kotlin.services.macie2.model.JobType
import aws.sdk.kotlin.services.macie2.model.LastRunErrorStatus
import aws.sdk.kotlin.services.macie2.model.Macie2Exception
import aws.sdk.kotlin.services.macie2.model.ManagedDataIdentifierSelector
import aws.sdk.kotlin.services.macie2.model.S3JobDefinition
import aws.sdk.kotlin.services.macie2.model.Statistics
import aws.sdk.kotlin.services.macie2.model.UserPausedDetails
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class DescribeClassificationJobOperationDeserializer: HttpDeserialize<DescribeClassificationJobResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeClassificationJobResponse {
        if (!response.status.isSuccess()) {
            throwDescribeClassificationJobError(context, response)
        }
        val builder = DescribeClassificationJobResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeClassificationJobOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeClassificationJobError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw Macie2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> Macie2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeClassificationJobOperationBody(builder: DescribeClassificationJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ALLOWLISTIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("allowListIds"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val CUSTOMDATAIDENTIFIERIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("customDataIdentifierIds"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val INITIALRUN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("initialRun"))
    val JOBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobArn"))
    val JOBID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobId"))
    val JOBSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobStatus"))
    val JOBTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobType"))
    val LASTRUNERRORSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("lastRunErrorStatus"))
    val LASTRUNTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastRunTime"))
    val MANAGEDDATAIDENTIFIERIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("managedDataIdentifierIds"))
    val MANAGEDDATAIDENTIFIERSELECTOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("managedDataIdentifierSelector"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val S3JOBDEFINITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("s3JobDefinition"))
    val SAMPLINGPERCENTAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("samplingPercentage"))
    val SCHEDULEFREQUENCY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("scheduleFrequency"))
    val STATISTICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("statistics"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val USERPAUSEDDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("userPausedDetails"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALLOWLISTIDS_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(CUSTOMDATAIDENTIFIERIDS_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(INITIALRUN_DESCRIPTOR)
        field(JOBARN_DESCRIPTOR)
        field(JOBID_DESCRIPTOR)
        field(JOBSTATUS_DESCRIPTOR)
        field(JOBTYPE_DESCRIPTOR)
        field(LASTRUNERRORSTATUS_DESCRIPTOR)
        field(LASTRUNTIME_DESCRIPTOR)
        field(MANAGEDDATAIDENTIFIERIDS_DESCRIPTOR)
        field(MANAGEDDATAIDENTIFIERSELECTOR_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(S3JOBDEFINITION_DESCRIPTOR)
        field(SAMPLINGPERCENTAGE_DESCRIPTOR)
        field(SCHEDULEFREQUENCY_DESCRIPTOR)
        field(STATISTICS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(USERPAUSEDDETAILS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ALLOWLISTIDS_DESCRIPTOR.index -> builder.allowListIds =
                    deserializer.deserializeList(ALLOWLISTIDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                CLIENTTOKEN_DESCRIPTOR.index -> builder.clientToken = deserializeString()
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromIso8601(it) }
                CUSTOMDATAIDENTIFIERIDS_DESCRIPTOR.index -> builder.customDataIdentifierIds =
                    deserializer.deserializeList(CUSTOMDATAIDENTIFIERIDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                INITIALRUN_DESCRIPTOR.index -> builder.initialRun = deserializeBoolean()
                JOBARN_DESCRIPTOR.index -> builder.jobArn = deserializeString()
                JOBID_DESCRIPTOR.index -> builder.jobId = deserializeString()
                JOBSTATUS_DESCRIPTOR.index -> builder.jobStatus = deserializeString().let { JobStatus.fromValue(it) }
                JOBTYPE_DESCRIPTOR.index -> builder.jobType = deserializeString().let { JobType.fromValue(it) }
                LASTRUNERRORSTATUS_DESCRIPTOR.index -> builder.lastRunErrorStatus = deserializeLastRunErrorStatusDocument(deserializer)
                LASTRUNTIME_DESCRIPTOR.index -> builder.lastRunTime = deserializeString().let { Instant.fromIso8601(it) }
                MANAGEDDATAIDENTIFIERIDS_DESCRIPTOR.index -> builder.managedDataIdentifierIds =
                    deserializer.deserializeList(MANAGEDDATAIDENTIFIERIDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                MANAGEDDATAIDENTIFIERSELECTOR_DESCRIPTOR.index -> builder.managedDataIdentifierSelector = deserializeString().let { ManagedDataIdentifierSelector.fromValue(it) }
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                S3JOBDEFINITION_DESCRIPTOR.index -> builder.s3JobDefinition = deserializeS3JobDefinitionDocument(deserializer)
                SAMPLINGPERCENTAGE_DESCRIPTOR.index -> builder.samplingPercentage = deserializeInt()
                SCHEDULEFREQUENCY_DESCRIPTOR.index -> builder.scheduleFrequency = deserializeJobScheduleFrequencyDocument(deserializer)
                STATISTICS_DESCRIPTOR.index -> builder.statistics = deserializeStatisticsDocument(deserializer)
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                USERPAUSEDDETAILS_DESCRIPTOR.index -> builder.userPausedDetails = deserializeUserPausedDetailsDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
