// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.macie2.model.BucketCountByEffectivePermission
import aws.sdk.kotlin.services.macie2.model.BucketCountByEncryptionType
import aws.sdk.kotlin.services.macie2.model.BucketCountBySharedAccessType
import aws.sdk.kotlin.services.macie2.model.BucketCountPolicyAllowsUnencryptedObjectUploads
import aws.sdk.kotlin.services.macie2.model.GetBucketStatisticsResponse
import aws.sdk.kotlin.services.macie2.model.Macie2Exception
import aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetBucketStatisticsOperationDeserializer: HttpDeserialize<GetBucketStatisticsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetBucketStatisticsResponse {
        if (!response.status.isSuccess()) {
            throwGetBucketStatisticsError(context, response)
        }
        val builder = GetBucketStatisticsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetBucketStatisticsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetBucketStatisticsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw Macie2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> Macie2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetBucketStatisticsOperationBody(builder: GetBucketStatisticsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BUCKETCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("bucketCount"))
    val BUCKETCOUNTBYEFFECTIVEPERMISSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("bucketCountByEffectivePermission"))
    val BUCKETCOUNTBYENCRYPTIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("bucketCountByEncryptionType"))
    val BUCKETCOUNTBYOBJECTENCRYPTIONREQUIREMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("bucketCountByObjectEncryptionRequirement"))
    val BUCKETCOUNTBYSHAREDACCESSTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("bucketCountBySharedAccessType"))
    val CLASSIFIABLEOBJECTCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("classifiableObjectCount"))
    val CLASSIFIABLESIZEINBYTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("classifiableSizeInBytes"))
    val LASTUPDATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastUpdated"))
    val OBJECTCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("objectCount"))
    val SIZEINBYTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("sizeInBytes"))
    val SIZEINBYTESCOMPRESSED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("sizeInBytesCompressed"))
    val UNCLASSIFIABLEOBJECTCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("unclassifiableObjectCount"))
    val UNCLASSIFIABLEOBJECTSIZEINBYTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("unclassifiableObjectSizeInBytes"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BUCKETCOUNT_DESCRIPTOR)
        field(BUCKETCOUNTBYEFFECTIVEPERMISSION_DESCRIPTOR)
        field(BUCKETCOUNTBYENCRYPTIONTYPE_DESCRIPTOR)
        field(BUCKETCOUNTBYOBJECTENCRYPTIONREQUIREMENT_DESCRIPTOR)
        field(BUCKETCOUNTBYSHAREDACCESSTYPE_DESCRIPTOR)
        field(CLASSIFIABLEOBJECTCOUNT_DESCRIPTOR)
        field(CLASSIFIABLESIZEINBYTES_DESCRIPTOR)
        field(LASTUPDATED_DESCRIPTOR)
        field(OBJECTCOUNT_DESCRIPTOR)
        field(SIZEINBYTES_DESCRIPTOR)
        field(SIZEINBYTESCOMPRESSED_DESCRIPTOR)
        field(UNCLASSIFIABLEOBJECTCOUNT_DESCRIPTOR)
        field(UNCLASSIFIABLEOBJECTSIZEINBYTES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BUCKETCOUNT_DESCRIPTOR.index -> builder.bucketCount = deserializeLong()
                BUCKETCOUNTBYEFFECTIVEPERMISSION_DESCRIPTOR.index -> builder.bucketCountByEffectivePermission = deserializeBucketCountByEffectivePermissionDocument(deserializer)
                BUCKETCOUNTBYENCRYPTIONTYPE_DESCRIPTOR.index -> builder.bucketCountByEncryptionType = deserializeBucketCountByEncryptionTypeDocument(deserializer)
                BUCKETCOUNTBYOBJECTENCRYPTIONREQUIREMENT_DESCRIPTOR.index -> builder.bucketCountByObjectEncryptionRequirement = deserializeBucketCountPolicyAllowsUnencryptedObjectUploadsDocument(deserializer)
                BUCKETCOUNTBYSHAREDACCESSTYPE_DESCRIPTOR.index -> builder.bucketCountBySharedAccessType = deserializeBucketCountBySharedAccessTypeDocument(deserializer)
                CLASSIFIABLEOBJECTCOUNT_DESCRIPTOR.index -> builder.classifiableObjectCount = deserializeLong()
                CLASSIFIABLESIZEINBYTES_DESCRIPTOR.index -> builder.classifiableSizeInBytes = deserializeLong()
                LASTUPDATED_DESCRIPTOR.index -> builder.lastUpdated = deserializeString().let { Instant.fromIso8601(it) }
                OBJECTCOUNT_DESCRIPTOR.index -> builder.objectCount = deserializeLong()
                SIZEINBYTES_DESCRIPTOR.index -> builder.sizeInBytes = deserializeLong()
                SIZEINBYTESCOMPRESSED_DESCRIPTOR.index -> builder.sizeInBytesCompressed = deserializeLong()
                UNCLASSIFIABLEOBJECTCOUNT_DESCRIPTOR.index -> builder.unclassifiableObjectCount = deserializeObjectLevelStatisticsDocument(deserializer)
                UNCLASSIFIABLEOBJECTSIZEINBYTES_DESCRIPTOR.index -> builder.unclassifiableObjectSizeInBytes = deserializeObjectLevelStatisticsDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
