// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.macie2.model.AvailabilityCode
import aws.sdk.kotlin.services.macie2.model.GetSensitiveDataOccurrencesAvailabilityResponse
import aws.sdk.kotlin.services.macie2.model.Macie2Exception
import aws.sdk.kotlin.services.macie2.model.UnavailabilityReasonCode
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetSensitiveDataOccurrencesAvailabilityOperationDeserializer: HttpDeserialize<GetSensitiveDataOccurrencesAvailabilityResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetSensitiveDataOccurrencesAvailabilityResponse {
        if (!response.status.isSuccess()) {
            throwGetSensitiveDataOccurrencesAvailabilityError(context, response)
        }
        val builder = GetSensitiveDataOccurrencesAvailabilityResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetSensitiveDataOccurrencesAvailabilityOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetSensitiveDataOccurrencesAvailabilityError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw Macie2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> Macie2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetSensitiveDataOccurrencesAvailabilityOperationBody(builder: GetSensitiveDataOccurrencesAvailabilityResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("code"))
    val REASONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("reasons"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CODE_DESCRIPTOR)
        field(REASONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CODE_DESCRIPTOR.index -> builder.code = deserializeString().let { AvailabilityCode.fromValue(it) }
                REASONS_DESCRIPTOR.index -> builder.reasons =
                    deserializer.deserializeList(REASONS_DESCRIPTOR) {
                        val col0 = mutableListOf<UnavailabilityReasonCode>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString().let { UnavailabilityReasonCode.fromValue(it) } } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
