// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.macie2.model.DetectedDataDetails
import aws.sdk.kotlin.services.macie2.model.GetSensitiveDataOccurrencesResponse
import aws.sdk.kotlin.services.macie2.model.Macie2Exception
import aws.sdk.kotlin.services.macie2.model.RevealRequestStatus
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class GetSensitiveDataOccurrencesOperationDeserializer: HttpDeserialize<GetSensitiveDataOccurrencesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetSensitiveDataOccurrencesResponse {
        if (!response.status.isSuccess()) {
            throwGetSensitiveDataOccurrencesError(context, response)
        }
        val builder = GetSensitiveDataOccurrencesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetSensitiveDataOccurrencesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetSensitiveDataOccurrencesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw Macie2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnprocessableEntityException" -> UnprocessableEntityExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> Macie2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetSensitiveDataOccurrencesOperationBody(builder: GetSensitiveDataOccurrencesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ERROR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("error"))
    val SENSITIVEDATAOCCURRENCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("sensitiveDataOccurrences"))
    val SENSITIVEDATAOCCURRENCES_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ERROR_DESCRIPTOR)
        field(SENSITIVEDATAOCCURRENCES_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ERROR_DESCRIPTOR.index -> builder.error = deserializeString()
                SENSITIVEDATAOCCURRENCES_DESCRIPTOR.index -> builder.sensitiveDataOccurrences =
                    deserializer.deserializeMap(SENSITIVEDATAOCCURRENCES_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, List<DetectedDataDetails>>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 =
                                if (nextHasValue()) {
                                    deserializer.deserializeList(SENSITIVEDATAOCCURRENCES_C0_DESCRIPTOR) {
                                        val col1 = mutableListOf<DetectedDataDetails>()
                                        while (hasNextElement()) {
                                            val el1 = if (nextHasValue()) { deserializeDetectedDataDetailsDocument(deserializer) } else { deserializeNull(); continue }
                                            col1.add(el1)
                                        }
                                        col1
                                    }
                                } else { deserializeNull(); continue }

                            map0[k0] = v0
                        }
                        map0
                    }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { RevealRequestStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
