// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.macie2.model.GetUsageTotalsResponse
import aws.sdk.kotlin.services.macie2.model.Macie2Exception
import aws.sdk.kotlin.services.macie2.model.TimeRange
import aws.sdk.kotlin.services.macie2.model.UsageTotal
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetUsageTotalsOperationDeserializer: HttpDeserialize<GetUsageTotalsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetUsageTotalsResponse {
        if (!response.status.isSuccess()) {
            throwGetUsageTotalsError(context, response)
        }
        val builder = GetUsageTotalsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetUsageTotalsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetUsageTotalsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw Macie2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> Macie2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetUsageTotalsOperationBody(builder: GetUsageTotalsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val TIMERANGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("timeRange"))
    val USAGETOTALS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("usageTotals"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(TIMERANGE_DESCRIPTOR)
        field(USAGETOTALS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                TIMERANGE_DESCRIPTOR.index -> builder.timeRange = deserializeString().let { TimeRange.fromValue(it) }
                USAGETOTALS_DESCRIPTOR.index -> builder.usageTotals =
                    deserializer.deserializeList(USAGETOTALS_DESCRIPTOR) {
                        val col0 = mutableListOf<UsageTotal>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeUsageTotalDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
