// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.transform

import aws.sdk.kotlin.services.macie2.model.SearchResourcesBucketCriteria
import aws.sdk.kotlin.services.macie2.model.SearchResourcesRequest
import aws.sdk.kotlin.services.macie2.model.SearchResourcesSortCriteria
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class SearchResourcesOperationSerializer: HttpSerialize<SearchResourcesRequest> {
    override suspend fun serialize(context: ExecutionContext, input: SearchResourcesRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/datasources/search-resources"
        }

        val payload = serializeSearchResourcesOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeSearchResourcesOperationBody(context: ExecutionContext, input: SearchResourcesRequest): ByteArray {
    val serializer = JsonSerializer()
    val BUCKETCRITERIA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("bucketCriteria"))
    val MAXRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("maxResults"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val SORTCRITERIA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("sortCriteria"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BUCKETCRITERIA_DESCRIPTOR)
        field(MAXRESULTS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(SORTCRITERIA_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.bucketCriteria?.let { field(BUCKETCRITERIA_DESCRIPTOR, it, ::serializeSearchResourcesBucketCriteriaDocument) }
        if (input.maxResults != 0) field(MAXRESULTS_DESCRIPTOR, input.maxResults)
        input.nextToken?.let { field(NEXTTOKEN_DESCRIPTOR, it) }
        input.sortCriteria?.let { field(SORTCRITERIA_DESCRIPTOR, it, ::serializeSearchResourcesSortCriteriaDocument) }
    }
    return serializer.toByteArray()
}
