// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.waiters

import aws.sdk.kotlin.services.macie2.Macie2Client
import aws.sdk.kotlin.services.macie2.model.GetSensitiveDataOccurrencesRequest
import aws.sdk.kotlin.services.macie2.model.GetSensitiveDataOccurrencesResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import kotlin.time.Duration.Companion.milliseconds


/**
 * Wait until the sensitive data occurrences are ready.
 */
public suspend fun Macie2Client.waitUntilFindingRevealed(request: GetSensitiveDataOccurrencesRequest): Outcome<GetSensitiveDataOccurrencesResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 2_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<GetSensitiveDataOccurrencesRequest, GetSensitiveDataOccurrencesResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val status = it?.status
            status?.toString() == "SUCCESS"
        },
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val status = it?.status
            status?.toString() == "ERROR"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { getSensitiveDataOccurrences(request) }
}

/**
 * Wait until the sensitive data occurrences are ready.
 */
public suspend fun Macie2Client.waitUntilFindingRevealed(block: GetSensitiveDataOccurrencesRequest.Builder.() -> Unit): Outcome<GetSensitiveDataOccurrencesResponse> =
    waitUntilFindingRevealed(GetSensitiveDataOccurrencesRequest.Builder().apply(block).build())
