// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.endpoints

import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.endpoints.Endpoint
import aws.smithy.kotlin.runtime.http.endpoints.EndpointProviderException
import kotlin.test.*
import kotlinx.coroutines.test.runTest

public class DefaultEndpointProviderTest {
    // For region ap-south-1 with FIPS enabled and DualStack enabled
    @Test
    fun test0() = runTest {
        val params = EndpointParameters {
            region = "ap-south-1"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.ap-south-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-south-1 with FIPS enabled and DualStack disabled
    @Test
    fun test1() = runTest {
        val params = EndpointParameters {
            region = "ap-south-1"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.ap-south-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-south-1 with FIPS disabled and DualStack enabled
    @Test
    fun test2() = runTest {
        val params = EndpointParameters {
            region = "ap-south-1"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.ap-south-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-south-1 with FIPS disabled and DualStack disabled
    @Test
    fun test3() = runTest {
        val params = EndpointParameters {
            region = "ap-south-1"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.ap-south-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-south-1 with FIPS enabled and DualStack enabled
    @Test
    fun test4() = runTest {
        val params = EndpointParameters {
            region = "eu-south-1"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.eu-south-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-south-1 with FIPS enabled and DualStack disabled
    @Test
    fun test5() = runTest {
        val params = EndpointParameters {
            region = "eu-south-1"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.eu-south-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-south-1 with FIPS disabled and DualStack enabled
    @Test
    fun test6() = runTest {
        val params = EndpointParameters {
            region = "eu-south-1"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.eu-south-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-south-1 with FIPS disabled and DualStack disabled
    @Test
    fun test7() = runTest {
        val params = EndpointParameters {
            region = "eu-south-1"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.eu-south-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ca-central-1 with FIPS enabled and DualStack enabled
    @Test
    fun test8() = runTest {
        val params = EndpointParameters {
            region = "ca-central-1"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.ca-central-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ca-central-1 with FIPS enabled and DualStack disabled
    @Test
    fun test9() = runTest {
        val params = EndpointParameters {
            region = "ca-central-1"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.ca-central-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ca-central-1 with FIPS disabled and DualStack enabled
    @Test
    fun test10() = runTest {
        val params = EndpointParameters {
            region = "ca-central-1"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.ca-central-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ca-central-1 with FIPS disabled and DualStack disabled
    @Test
    fun test11() = runTest {
        val params = EndpointParameters {
            region = "ca-central-1"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.ca-central-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-central-1 with FIPS enabled and DualStack enabled
    @Test
    fun test12() = runTest {
        val params = EndpointParameters {
            region = "eu-central-1"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.eu-central-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-central-1 with FIPS enabled and DualStack disabled
    @Test
    fun test13() = runTest {
        val params = EndpointParameters {
            region = "eu-central-1"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.eu-central-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-central-1 with FIPS disabled and DualStack enabled
    @Test
    fun test14() = runTest {
        val params = EndpointParameters {
            region = "eu-central-1"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.eu-central-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-central-1 with FIPS disabled and DualStack disabled
    @Test
    fun test15() = runTest {
        val params = EndpointParameters {
            region = "eu-central-1"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.eu-central-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-west-1 with FIPS enabled and DualStack enabled
    @Test
    fun test16() = runTest {
        val params = EndpointParameters {
            region = "us-west-1"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.us-west-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-west-1 with FIPS enabled and DualStack disabled
    @Test
    fun test17() = runTest {
        val params = EndpointParameters {
            region = "us-west-1"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.us-west-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-west-1 with FIPS disabled and DualStack enabled
    @Test
    fun test18() = runTest {
        val params = EndpointParameters {
            region = "us-west-1"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.us-west-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-west-1 with FIPS disabled and DualStack disabled
    @Test
    fun test19() = runTest {
        val params = EndpointParameters {
            region = "us-west-1"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.us-west-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-west-2 with FIPS enabled and DualStack enabled
    @Test
    fun test20() = runTest {
        val params = EndpointParameters {
            region = "us-west-2"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.us-west-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-west-2 with FIPS enabled and DualStack disabled
    @Test
    fun test21() = runTest {
        val params = EndpointParameters {
            region = "us-west-2"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.us-west-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-west-2 with FIPS disabled and DualStack enabled
    @Test
    fun test22() = runTest {
        val params = EndpointParameters {
            region = "us-west-2"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.us-west-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-west-2 with FIPS disabled and DualStack disabled
    @Test
    fun test23() = runTest {
        val params = EndpointParameters {
            region = "us-west-2"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.us-west-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region af-south-1 with FIPS enabled and DualStack enabled
    @Test
    fun test24() = runTest {
        val params = EndpointParameters {
            region = "af-south-1"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.af-south-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region af-south-1 with FIPS enabled and DualStack disabled
    @Test
    fun test25() = runTest {
        val params = EndpointParameters {
            region = "af-south-1"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.af-south-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region af-south-1 with FIPS disabled and DualStack enabled
    @Test
    fun test26() = runTest {
        val params = EndpointParameters {
            region = "af-south-1"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.af-south-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region af-south-1 with FIPS disabled and DualStack disabled
    @Test
    fun test27() = runTest {
        val params = EndpointParameters {
            region = "af-south-1"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.af-south-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-north-1 with FIPS enabled and DualStack enabled
    @Test
    fun test28() = runTest {
        val params = EndpointParameters {
            region = "eu-north-1"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.eu-north-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-north-1 with FIPS enabled and DualStack disabled
    @Test
    fun test29() = runTest {
        val params = EndpointParameters {
            region = "eu-north-1"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.eu-north-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-north-1 with FIPS disabled and DualStack enabled
    @Test
    fun test30() = runTest {
        val params = EndpointParameters {
            region = "eu-north-1"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.eu-north-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-north-1 with FIPS disabled and DualStack disabled
    @Test
    fun test31() = runTest {
        val params = EndpointParameters {
            region = "eu-north-1"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.eu-north-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-3 with FIPS enabled and DualStack enabled
    @Test
    fun test32() = runTest {
        val params = EndpointParameters {
            region = "eu-west-3"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.eu-west-3.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-3 with FIPS enabled and DualStack disabled
    @Test
    fun test33() = runTest {
        val params = EndpointParameters {
            region = "eu-west-3"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.eu-west-3.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-3 with FIPS disabled and DualStack enabled
    @Test
    fun test34() = runTest {
        val params = EndpointParameters {
            region = "eu-west-3"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.eu-west-3.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-3 with FIPS disabled and DualStack disabled
    @Test
    fun test35() = runTest {
        val params = EndpointParameters {
            region = "eu-west-3"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.eu-west-3.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-2 with FIPS enabled and DualStack enabled
    @Test
    fun test36() = runTest {
        val params = EndpointParameters {
            region = "eu-west-2"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.eu-west-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-2 with FIPS enabled and DualStack disabled
    @Test
    fun test37() = runTest {
        val params = EndpointParameters {
            region = "eu-west-2"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.eu-west-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-2 with FIPS disabled and DualStack enabled
    @Test
    fun test38() = runTest {
        val params = EndpointParameters {
            region = "eu-west-2"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.eu-west-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-2 with FIPS disabled and DualStack disabled
    @Test
    fun test39() = runTest {
        val params = EndpointParameters {
            region = "eu-west-2"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.eu-west-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-1 with FIPS enabled and DualStack enabled
    @Test
    fun test40() = runTest {
        val params = EndpointParameters {
            region = "eu-west-1"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.eu-west-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-1 with FIPS enabled and DualStack disabled
    @Test
    fun test41() = runTest {
        val params = EndpointParameters {
            region = "eu-west-1"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.eu-west-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-1 with FIPS disabled and DualStack enabled
    @Test
    fun test42() = runTest {
        val params = EndpointParameters {
            region = "eu-west-1"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.eu-west-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-1 with FIPS disabled and DualStack disabled
    @Test
    fun test43() = runTest {
        val params = EndpointParameters {
            region = "eu-west-1"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.eu-west-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-3 with FIPS enabled and DualStack enabled
    @Test
    fun test44() = runTest {
        val params = EndpointParameters {
            region = "ap-northeast-3"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.ap-northeast-3.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-3 with FIPS enabled and DualStack disabled
    @Test
    fun test45() = runTest {
        val params = EndpointParameters {
            region = "ap-northeast-3"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.ap-northeast-3.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-3 with FIPS disabled and DualStack enabled
    @Test
    fun test46() = runTest {
        val params = EndpointParameters {
            region = "ap-northeast-3"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.ap-northeast-3.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-3 with FIPS disabled and DualStack disabled
    @Test
    fun test47() = runTest {
        val params = EndpointParameters {
            region = "ap-northeast-3"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.ap-northeast-3.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-2 with FIPS enabled and DualStack enabled
    @Test
    fun test48() = runTest {
        val params = EndpointParameters {
            region = "ap-northeast-2"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.ap-northeast-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-2 with FIPS enabled and DualStack disabled
    @Test
    fun test49() = runTest {
        val params = EndpointParameters {
            region = "ap-northeast-2"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.ap-northeast-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-2 with FIPS disabled and DualStack enabled
    @Test
    fun test50() = runTest {
        val params = EndpointParameters {
            region = "ap-northeast-2"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.ap-northeast-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-2 with FIPS disabled and DualStack disabled
    @Test
    fun test51() = runTest {
        val params = EndpointParameters {
            region = "ap-northeast-2"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.ap-northeast-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-1 with FIPS enabled and DualStack enabled
    @Test
    fun test52() = runTest {
        val params = EndpointParameters {
            region = "ap-northeast-1"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.ap-northeast-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-1 with FIPS enabled and DualStack disabled
    @Test
    fun test53() = runTest {
        val params = EndpointParameters {
            region = "ap-northeast-1"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.ap-northeast-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-1 with FIPS disabled and DualStack enabled
    @Test
    fun test54() = runTest {
        val params = EndpointParameters {
            region = "ap-northeast-1"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.ap-northeast-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-1 with FIPS disabled and DualStack disabled
    @Test
    fun test55() = runTest {
        val params = EndpointParameters {
            region = "ap-northeast-1"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.ap-northeast-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region me-south-1 with FIPS enabled and DualStack enabled
    @Test
    fun test56() = runTest {
        val params = EndpointParameters {
            region = "me-south-1"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.me-south-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region me-south-1 with FIPS enabled and DualStack disabled
    @Test
    fun test57() = runTest {
        val params = EndpointParameters {
            region = "me-south-1"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.me-south-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region me-south-1 with FIPS disabled and DualStack enabled
    @Test
    fun test58() = runTest {
        val params = EndpointParameters {
            region = "me-south-1"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.me-south-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region me-south-1 with FIPS disabled and DualStack disabled
    @Test
    fun test59() = runTest {
        val params = EndpointParameters {
            region = "me-south-1"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.me-south-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region sa-east-1 with FIPS enabled and DualStack enabled
    @Test
    fun test60() = runTest {
        val params = EndpointParameters {
            region = "sa-east-1"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.sa-east-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region sa-east-1 with FIPS enabled and DualStack disabled
    @Test
    fun test61() = runTest {
        val params = EndpointParameters {
            region = "sa-east-1"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.sa-east-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region sa-east-1 with FIPS disabled and DualStack enabled
    @Test
    fun test62() = runTest {
        val params = EndpointParameters {
            region = "sa-east-1"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.sa-east-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region sa-east-1 with FIPS disabled and DualStack disabled
    @Test
    fun test63() = runTest {
        val params = EndpointParameters {
            region = "sa-east-1"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.sa-east-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-east-1 with FIPS enabled and DualStack enabled
    @Test
    fun test64() = runTest {
        val params = EndpointParameters {
            region = "ap-east-1"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.ap-east-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-east-1 with FIPS enabled and DualStack disabled
    @Test
    fun test65() = runTest {
        val params = EndpointParameters {
            region = "ap-east-1"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.ap-east-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-east-1 with FIPS disabled and DualStack enabled
    @Test
    fun test66() = runTest {
        val params = EndpointParameters {
            region = "ap-east-1"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.ap-east-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-east-1 with FIPS disabled and DualStack disabled
    @Test
    fun test67() = runTest {
        val params = EndpointParameters {
            region = "ap-east-1"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.ap-east-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-1 with FIPS enabled and DualStack enabled
    @Test
    fun test68() = runTest {
        val params = EndpointParameters {
            region = "ap-southeast-1"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.ap-southeast-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-1 with FIPS enabled and DualStack disabled
    @Test
    fun test69() = runTest {
        val params = EndpointParameters {
            region = "ap-southeast-1"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.ap-southeast-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-1 with FIPS disabled and DualStack enabled
    @Test
    fun test70() = runTest {
        val params = EndpointParameters {
            region = "ap-southeast-1"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.ap-southeast-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-1 with FIPS disabled and DualStack disabled
    @Test
    fun test71() = runTest {
        val params = EndpointParameters {
            region = "ap-southeast-1"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.ap-southeast-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-2 with FIPS enabled and DualStack enabled
    @Test
    fun test72() = runTest {
        val params = EndpointParameters {
            region = "ap-southeast-2"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.ap-southeast-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-2 with FIPS enabled and DualStack disabled
    @Test
    fun test73() = runTest {
        val params = EndpointParameters {
            region = "ap-southeast-2"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.ap-southeast-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-2 with FIPS disabled and DualStack enabled
    @Test
    fun test74() = runTest {
        val params = EndpointParameters {
            region = "ap-southeast-2"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.ap-southeast-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-2 with FIPS disabled and DualStack disabled
    @Test
    fun test75() = runTest {
        val params = EndpointParameters {
            region = "ap-southeast-2"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.ap-southeast-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-1 with FIPS enabled and DualStack enabled
    @Test
    fun test76() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.us-east-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-1 with FIPS enabled and DualStack disabled
    @Test
    fun test77() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.us-east-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-1 with FIPS disabled and DualStack enabled
    @Test
    fun test78() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.us-east-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-1 with FIPS disabled and DualStack disabled
    @Test
    fun test79() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.us-east-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-2 with FIPS enabled and DualStack enabled
    @Test
    fun test80() = runTest {
        val params = EndpointParameters {
            region = "us-east-2"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.us-east-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-2 with FIPS enabled and DualStack disabled
    @Test
    fun test81() = runTest {
        val params = EndpointParameters {
            region = "us-east-2"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2-fips.us-east-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-2 with FIPS disabled and DualStack enabled
    @Test
    fun test82() = runTest {
        val params = EndpointParameters {
            region = "us-east-2"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.us-east-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-2 with FIPS disabled and DualStack disabled
    @Test
    fun test83() = runTest {
        val params = EndpointParameters {
            region = "us-east-2"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://macie2.us-east-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For custom endpoint with fips disabled and dualstack disabled
    @Test
    fun test84() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useDualStack = false
            useFips = false
            endpoint = "https://example.com"
        }
        val expected = Endpoint(
            uri = Url.parse("https://example.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For custom endpoint with fips enabled and dualstack disabled
    @Test
    fun test85() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useDualStack = false
            useFips = true
            endpoint = "https://example.com"
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid Configuration: FIPS and custom endpoint are not supported", ex.message)
    }

    // For custom endpoint with fips disabled and dualstack enabled
    @Test
    fun test86() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useDualStack = true
            useFips = false
            endpoint = "https://example.com"
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid Configuration: Dualstack and custom endpoint are not supported", ex.message)
    }

}
