// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.runtime.regions.resolveRegionForOperation
import aws.sdk.kotlin.services.macie2.model.*
import aws.sdk.kotlin.services.macie2.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngineConfig
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "Macie2"
const val ServiceApiVersion: String = "2020-01-01"
const val SdkVersion: String = "0.6.0-alpha"

internal class DefaultMacie2Client(override val config: Macie2Client.Config) : Macie2Client {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine(HttpClientEngineConfig())
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }

    /**
     * Accepts an Amazon Macie membership invitation that was received from a specific account.
     */
    override suspend fun acceptInvitation(input: AcceptInvitationRequest): AcceptInvitationResponse {
        val op = SdkHttpOperation.build<AcceptInvitationRequest, AcceptInvitationResponse> {
            serializer = AcceptInvitationOperationSerializer()
            deserializer = AcceptInvitationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AcceptInvitation"
            }
        }
        registerAcceptInvitationMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about one or more custom data identifiers.
     */
    override suspend fun batchGetCustomDataIdentifiers(input: BatchGetCustomDataIdentifiersRequest): BatchGetCustomDataIdentifiersResponse {
        val op = SdkHttpOperation.build<BatchGetCustomDataIdentifiersRequest, BatchGetCustomDataIdentifiersResponse> {
            serializer = BatchGetCustomDataIdentifiersOperationSerializer()
            deserializer = BatchGetCustomDataIdentifiersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchGetCustomDataIdentifiers"
            }
        }
        registerBatchGetCustomDataIdentifiersMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates and defines the settings for a classification job.
     */
    override suspend fun createClassificationJob(input: CreateClassificationJobRequest): CreateClassificationJobResponse {
        val op = SdkHttpOperation.build<CreateClassificationJobRequest, CreateClassificationJobResponse> {
            serializer = CreateClassificationJobOperationSerializer()
            deserializer = CreateClassificationJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateClassificationJob"
            }
        }
        registerCreateClassificationJobMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates and defines the criteria and other settings for a custom data identifier.
     */
    override suspend fun createCustomDataIdentifier(input: CreateCustomDataIdentifierRequest): CreateCustomDataIdentifierResponse {
        val op = SdkHttpOperation.build<CreateCustomDataIdentifierRequest, CreateCustomDataIdentifierResponse> {
            serializer = CreateCustomDataIdentifierOperationSerializer()
            deserializer = CreateCustomDataIdentifierOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCustomDataIdentifier"
            }
        }
        registerCreateCustomDataIdentifierMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates and defines the criteria and other settings for a findings filter.
     */
    override suspend fun createFindingsFilter(input: CreateFindingsFilterRequest): CreateFindingsFilterResponse {
        val op = SdkHttpOperation.build<CreateFindingsFilterRequest, CreateFindingsFilterResponse> {
            serializer = CreateFindingsFilterOperationSerializer()
            deserializer = CreateFindingsFilterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateFindingsFilter"
            }
        }
        registerCreateFindingsFilterMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Sends an Amazon Macie membership invitation to one or more accounts.
     */
    override suspend fun createInvitations(input: CreateInvitationsRequest): CreateInvitationsResponse {
        val op = SdkHttpOperation.build<CreateInvitationsRequest, CreateInvitationsResponse> {
            serializer = CreateInvitationsOperationSerializer()
            deserializer = CreateInvitationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateInvitations"
            }
        }
        registerCreateInvitationsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Associates an account with an Amazon Macie administrator account.
     */
    override suspend fun createMember(input: CreateMemberRequest): CreateMemberResponse {
        val op = SdkHttpOperation.build<CreateMemberRequest, CreateMemberResponse> {
            serializer = CreateMemberOperationSerializer()
            deserializer = CreateMemberOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateMember"
            }
        }
        registerCreateMemberMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates sample findings.
     */
    override suspend fun createSampleFindings(input: CreateSampleFindingsRequest): CreateSampleFindingsResponse {
        val op = SdkHttpOperation.build<CreateSampleFindingsRequest, CreateSampleFindingsResponse> {
            serializer = CreateSampleFindingsOperationSerializer()
            deserializer = CreateSampleFindingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSampleFindings"
            }
        }
        registerCreateSampleFindingsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Declines Amazon Macie membership invitations that were received from specific accounts.
     */
    override suspend fun declineInvitations(input: DeclineInvitationsRequest): DeclineInvitationsResponse {
        val op = SdkHttpOperation.build<DeclineInvitationsRequest, DeclineInvitationsResponse> {
            serializer = DeclineInvitationsOperationSerializer()
            deserializer = DeclineInvitationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeclineInvitations"
            }
        }
        registerDeclineInvitationsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Soft deletes a custom data identifier.
     */
    override suspend fun deleteCustomDataIdentifier(input: DeleteCustomDataIdentifierRequest): DeleteCustomDataIdentifierResponse {
        val op = SdkHttpOperation.build<DeleteCustomDataIdentifierRequest, DeleteCustomDataIdentifierResponse> {
            serializer = DeleteCustomDataIdentifierOperationSerializer()
            deserializer = DeleteCustomDataIdentifierOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCustomDataIdentifier"
            }
        }
        registerDeleteCustomDataIdentifierMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a findings filter.
     */
    override suspend fun deleteFindingsFilter(input: DeleteFindingsFilterRequest): DeleteFindingsFilterResponse {
        val op = SdkHttpOperation.build<DeleteFindingsFilterRequest, DeleteFindingsFilterResponse> {
            serializer = DeleteFindingsFilterOperationSerializer()
            deserializer = DeleteFindingsFilterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteFindingsFilter"
            }
        }
        registerDeleteFindingsFilterMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes Amazon Macie membership invitations that were received from specific accounts.
     */
    override suspend fun deleteInvitations(input: DeleteInvitationsRequest): DeleteInvitationsResponse {
        val op = SdkHttpOperation.build<DeleteInvitationsRequest, DeleteInvitationsResponse> {
            serializer = DeleteInvitationsOperationSerializer()
            deserializer = DeleteInvitationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteInvitations"
            }
        }
        registerDeleteInvitationsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the association between an Amazon Macie administrator account and an account.
     */
    override suspend fun deleteMember(input: DeleteMemberRequest): DeleteMemberResponse {
        val op = SdkHttpOperation.build<DeleteMemberRequest, DeleteMemberResponse> {
            serializer = DeleteMemberOperationSerializer()
            deserializer = DeleteMemberOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteMember"
            }
        }
        registerDeleteMemberMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves (queries) statistical data and other information about one or more S3 buckets that Amazon Macie monitors and analyzes.
     */
    override suspend fun describeBuckets(input: DescribeBucketsRequest): DescribeBucketsResponse {
        val op = SdkHttpOperation.build<DescribeBucketsRequest, DescribeBucketsResponse> {
            serializer = DescribeBucketsOperationSerializer()
            deserializer = DescribeBucketsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeBuckets"
            }
        }
        registerDescribeBucketsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the status and settings for a classification job.
     */
    override suspend fun describeClassificationJob(input: DescribeClassificationJobRequest): DescribeClassificationJobResponse {
        val op = SdkHttpOperation.build<DescribeClassificationJobRequest, DescribeClassificationJobResponse> {
            serializer = DescribeClassificationJobOperationSerializer()
            deserializer = DescribeClassificationJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeClassificationJob"
            }
        }
        registerDescribeClassificationJobMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the Amazon Macie configuration settings for an Amazon Web Services organization.
     */
    override suspend fun describeOrganizationConfiguration(input: DescribeOrganizationConfigurationRequest): DescribeOrganizationConfigurationResponse {
        val op = SdkHttpOperation.build<DescribeOrganizationConfigurationRequest, DescribeOrganizationConfigurationResponse> {
            serializer = DescribeOrganizationConfigurationOperationSerializer()
            deserializer = DescribeOrganizationConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeOrganizationConfiguration"
            }
        }
        registerDescribeOrganizationConfigurationMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Disables an Amazon Macie account and deletes Macie resources for the account.
     */
    override suspend fun disableMacie(input: DisableMacieRequest): DisableMacieResponse {
        val op = SdkHttpOperation.build<DisableMacieRequest, DisableMacieResponse> {
            serializer = DisableMacieOperationSerializer()
            deserializer = DisableMacieOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisableMacie"
            }
        }
        registerDisableMacieMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Disables an account as the delegated Amazon Macie administrator account for an Amazon Web Services organization.
     */
    override suspend fun disableOrganizationAdminAccount(input: DisableOrganizationAdminAccountRequest): DisableOrganizationAdminAccountResponse {
        val op = SdkHttpOperation.build<DisableOrganizationAdminAccountRequest, DisableOrganizationAdminAccountResponse> {
            serializer = DisableOrganizationAdminAccountOperationSerializer()
            deserializer = DisableOrganizationAdminAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisableOrganizationAdminAccount"
            }
        }
        registerDisableOrganizationAdminAccountMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a member account from its Amazon Macie administrator account.
     */
    override suspend fun disassociateFromAdministratorAccount(input: DisassociateFromAdministratorAccountRequest): DisassociateFromAdministratorAccountResponse {
        val op = SdkHttpOperation.build<DisassociateFromAdministratorAccountRequest, DisassociateFromAdministratorAccountResponse> {
            serializer = DisassociateFromAdministratorAccountOperationSerializer()
            deserializer = DisassociateFromAdministratorAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateFromAdministratorAccount"
            }
        }
        registerDisassociateFromAdministratorAccountMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * (Deprecated) Disassociates a member account from its Amazon Macie administrator account. This operation has been replaced by the <link  linkend="DisassociateFromAdministratorAccount">DisassociateFromAdministratorAccount</link> operation.
     */
    override suspend fun disassociateFromMasterAccount(input: DisassociateFromMasterAccountRequest): DisassociateFromMasterAccountResponse {
        val op = SdkHttpOperation.build<DisassociateFromMasterAccountRequest, DisassociateFromMasterAccountResponse> {
            serializer = DisassociateFromMasterAccountOperationSerializer()
            deserializer = DisassociateFromMasterAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateFromMasterAccount"
            }
        }
        registerDisassociateFromMasterAccountMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates an Amazon Macie administrator account from a member account.
     */
    override suspend fun disassociateMember(input: DisassociateMemberRequest): DisassociateMemberResponse {
        val op = SdkHttpOperation.build<DisassociateMemberRequest, DisassociateMemberResponse> {
            serializer = DisassociateMemberOperationSerializer()
            deserializer = DisassociateMemberOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateMember"
            }
        }
        registerDisassociateMemberMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Enables Amazon Macie and specifies the configuration settings for a Macie account.
     */
    override suspend fun enableMacie(input: EnableMacieRequest): EnableMacieResponse {
        val op = SdkHttpOperation.build<EnableMacieRequest, EnableMacieResponse> {
            serializer = EnableMacieOperationSerializer()
            deserializer = EnableMacieOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "EnableMacie"
            }
        }
        registerEnableMacieMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Designates an account as the delegated Amazon Macie administrator account for an Amazon Web Services organization.
     */
    override suspend fun enableOrganizationAdminAccount(input: EnableOrganizationAdminAccountRequest): EnableOrganizationAdminAccountResponse {
        val op = SdkHttpOperation.build<EnableOrganizationAdminAccountRequest, EnableOrganizationAdminAccountResponse> {
            serializer = EnableOrganizationAdminAccountOperationSerializer()
            deserializer = EnableOrganizationAdminAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "EnableOrganizationAdminAccount"
            }
        }
        registerEnableOrganizationAdminAccountMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the Amazon Macie administrator account for an account.
     */
    override suspend fun getAdministratorAccount(input: GetAdministratorAccountRequest): GetAdministratorAccountResponse {
        val op = SdkHttpOperation.build<GetAdministratorAccountRequest, GetAdministratorAccountResponse> {
            serializer = GetAdministratorAccountOperationSerializer()
            deserializer = GetAdministratorAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAdministratorAccount"
            }
        }
        registerGetAdministratorAccountMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves (queries) aggregated statistical data for all the S3 buckets that Amazon Macie monitors and analyzes.
     */
    override suspend fun getBucketStatistics(input: GetBucketStatisticsRequest): GetBucketStatisticsResponse {
        val op = SdkHttpOperation.build<GetBucketStatisticsRequest, GetBucketStatisticsResponse> {
            serializer = GetBucketStatisticsOperationSerializer()
            deserializer = GetBucketStatisticsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetBucketStatistics"
            }
        }
        registerGetBucketStatisticsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the configuration settings for storing data classification results.
     */
    override suspend fun getClassificationExportConfiguration(input: GetClassificationExportConfigurationRequest): GetClassificationExportConfigurationResponse {
        val op = SdkHttpOperation.build<GetClassificationExportConfigurationRequest, GetClassificationExportConfigurationResponse> {
            serializer = GetClassificationExportConfigurationOperationSerializer()
            deserializer = GetClassificationExportConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetClassificationExportConfiguration"
            }
        }
        registerGetClassificationExportConfigurationMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the criteria and other settings for a custom data identifier.
     */
    override suspend fun getCustomDataIdentifier(input: GetCustomDataIdentifierRequest): GetCustomDataIdentifierResponse {
        val op = SdkHttpOperation.build<GetCustomDataIdentifierRequest, GetCustomDataIdentifierResponse> {
            serializer = GetCustomDataIdentifierOperationSerializer()
            deserializer = GetCustomDataIdentifierOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCustomDataIdentifier"
            }
        }
        registerGetCustomDataIdentifierMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves (queries) aggregated statistical data about findings.
     */
    override suspend fun getFindingStatistics(input: GetFindingStatisticsRequest): GetFindingStatisticsResponse {
        val op = SdkHttpOperation.build<GetFindingStatisticsRequest, GetFindingStatisticsResponse> {
            serializer = GetFindingStatisticsOperationSerializer()
            deserializer = GetFindingStatisticsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetFindingStatistics"
            }
        }
        registerGetFindingStatisticsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the details of one or more findings.
     */
    override suspend fun getFindings(input: GetFindingsRequest): GetFindingsResponse {
        val op = SdkHttpOperation.build<GetFindingsRequest, GetFindingsResponse> {
            serializer = GetFindingsOperationSerializer()
            deserializer = GetFindingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetFindings"
            }
        }
        registerGetFindingsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the criteria and other settings for a findings filter.
     */
    override suspend fun getFindingsFilter(input: GetFindingsFilterRequest): GetFindingsFilterResponse {
        val op = SdkHttpOperation.build<GetFindingsFilterRequest, GetFindingsFilterResponse> {
            serializer = GetFindingsFilterOperationSerializer()
            deserializer = GetFindingsFilterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetFindingsFilter"
            }
        }
        registerGetFindingsFilterMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the configuration settings for publishing findings to Security Hub.
     */
    override suspend fun getFindingsPublicationConfiguration(input: GetFindingsPublicationConfigurationRequest): GetFindingsPublicationConfigurationResponse {
        val op = SdkHttpOperation.build<GetFindingsPublicationConfigurationRequest, GetFindingsPublicationConfigurationResponse> {
            serializer = GetFindingsPublicationConfigurationOperationSerializer()
            deserializer = GetFindingsPublicationConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetFindingsPublicationConfiguration"
            }
        }
        registerGetFindingsPublicationConfigurationMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the count of Amazon Macie membership invitations that were received by an account.
     */
    override suspend fun getInvitationsCount(input: GetInvitationsCountRequest): GetInvitationsCountResponse {
        val op = SdkHttpOperation.build<GetInvitationsCountRequest, GetInvitationsCountResponse> {
            serializer = GetInvitationsCountOperationSerializer()
            deserializer = GetInvitationsCountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetInvitationsCount"
            }
        }
        registerGetInvitationsCountMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the current status and configuration settings for an Amazon Macie account.
     */
    override suspend fun getMacieSession(input: GetMacieSessionRequest): GetMacieSessionResponse {
        val op = SdkHttpOperation.build<GetMacieSessionRequest, GetMacieSessionResponse> {
            serializer = GetMacieSessionOperationSerializer()
            deserializer = GetMacieSessionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetMacieSession"
            }
        }
        registerGetMacieSessionMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * (Deprecated) Retrieves information about the Amazon Macie administrator account for an account. This operation has been replaced by the <link  linkend="GetAdministratorAccount">GetAdministratorAccount</link> operation.
     */
    override suspend fun getMasterAccount(input: GetMasterAccountRequest): GetMasterAccountResponse {
        val op = SdkHttpOperation.build<GetMasterAccountRequest, GetMasterAccountResponse> {
            serializer = GetMasterAccountOperationSerializer()
            deserializer = GetMasterAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetMasterAccount"
            }
        }
        registerGetMasterAccountMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about an account that's associated with an Amazon Macie administrator account.
     */
    override suspend fun getMember(input: GetMemberRequest): GetMemberResponse {
        val op = SdkHttpOperation.build<GetMemberRequest, GetMemberResponse> {
            serializer = GetMemberOperationSerializer()
            deserializer = GetMemberOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetMember"
            }
        }
        registerGetMemberMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves (queries) quotas and aggregated usage data for one or more accounts.
     */
    override suspend fun getUsageStatistics(input: GetUsageStatisticsRequest): GetUsageStatisticsResponse {
        val op = SdkHttpOperation.build<GetUsageStatisticsRequest, GetUsageStatisticsResponse> {
            serializer = GetUsageStatisticsOperationSerializer()
            deserializer = GetUsageStatisticsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetUsageStatistics"
            }
        }
        registerGetUsageStatisticsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves (queries) aggregated usage data for an account.
     */
    override suspend fun getUsageTotals(input: GetUsageTotalsRequest): GetUsageTotalsResponse {
        val op = SdkHttpOperation.build<GetUsageTotalsRequest, GetUsageTotalsResponse> {
            serializer = GetUsageTotalsOperationSerializer()
            deserializer = GetUsageTotalsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetUsageTotals"
            }
        }
        registerGetUsageTotalsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a subset of information about one or more classification jobs.
     */
    override suspend fun listClassificationJobs(input: ListClassificationJobsRequest): ListClassificationJobsResponse {
        val op = SdkHttpOperation.build<ListClassificationJobsRequest, ListClassificationJobsResponse> {
            serializer = ListClassificationJobsOperationSerializer()
            deserializer = ListClassificationJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListClassificationJobs"
            }
        }
        registerListClassificationJobsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a subset of information about all the custom data identifiers for an account.
     */
    override suspend fun listCustomDataIdentifiers(input: ListCustomDataIdentifiersRequest): ListCustomDataIdentifiersResponse {
        val op = SdkHttpOperation.build<ListCustomDataIdentifiersRequest, ListCustomDataIdentifiersResponse> {
            serializer = ListCustomDataIdentifiersOperationSerializer()
            deserializer = ListCustomDataIdentifiersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCustomDataIdentifiers"
            }
        }
        registerListCustomDataIdentifiersMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a subset of information about one or more findings.
     */
    override suspend fun listFindings(input: ListFindingsRequest): ListFindingsResponse {
        val op = SdkHttpOperation.build<ListFindingsRequest, ListFindingsResponse> {
            serializer = ListFindingsOperationSerializer()
            deserializer = ListFindingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListFindings"
            }
        }
        registerListFindingsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a subset of information about all the findings filters for an account.
     */
    override suspend fun listFindingsFilters(input: ListFindingsFiltersRequest): ListFindingsFiltersResponse {
        val op = SdkHttpOperation.build<ListFindingsFiltersRequest, ListFindingsFiltersResponse> {
            serializer = ListFindingsFiltersOperationSerializer()
            deserializer = ListFindingsFiltersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListFindingsFilters"
            }
        }
        registerListFindingsFiltersMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about all the Amazon Macie membership invitations that were received by an account.
     */
    override suspend fun listInvitations(input: ListInvitationsRequest): ListInvitationsResponse {
        val op = SdkHttpOperation.build<ListInvitationsRequest, ListInvitationsResponse> {
            serializer = ListInvitationsOperationSerializer()
            deserializer = ListInvitationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListInvitations"
            }
        }
        registerListInvitationsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the accounts that are associated with an Amazon Macie administrator account.
     */
    override suspend fun listMembers(input: ListMembersRequest): ListMembersResponse {
        val op = SdkHttpOperation.build<ListMembersRequest, ListMembersResponse> {
            serializer = ListMembersOperationSerializer()
            deserializer = ListMembersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListMembers"
            }
        }
        registerListMembersMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the delegated Amazon Macie administrator account for an Amazon Web Services organization.
     */
    override suspend fun listOrganizationAdminAccounts(input: ListOrganizationAdminAccountsRequest): ListOrganizationAdminAccountsResponse {
        val op = SdkHttpOperation.build<ListOrganizationAdminAccountsRequest, ListOrganizationAdminAccountsResponse> {
            serializer = ListOrganizationAdminAccountsOperationSerializer()
            deserializer = ListOrganizationAdminAccountsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListOrganizationAdminAccounts"
            }
        }
        registerListOrganizationAdminAccountsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the tags (keys and values) that are associated with a classification job, custom data identifier, findings filter, or member account.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        registerListTagsForResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates or updates the configuration settings for storing data classification results.
     */
    override suspend fun putClassificationExportConfiguration(input: PutClassificationExportConfigurationRequest): PutClassificationExportConfigurationResponse {
        val op = SdkHttpOperation.build<PutClassificationExportConfigurationRequest, PutClassificationExportConfigurationResponse> {
            serializer = PutClassificationExportConfigurationOperationSerializer()
            deserializer = PutClassificationExportConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutClassificationExportConfiguration"
            }
        }
        registerPutClassificationExportConfigurationMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the configuration settings for publishing findings to Security Hub.
     */
    override suspend fun putFindingsPublicationConfiguration(input: PutFindingsPublicationConfigurationRequest): PutFindingsPublicationConfigurationResponse {
        val op = SdkHttpOperation.build<PutFindingsPublicationConfigurationRequest, PutFindingsPublicationConfigurationResponse> {
            serializer = PutFindingsPublicationConfigurationOperationSerializer()
            deserializer = PutFindingsPublicationConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutFindingsPublicationConfiguration"
            }
        }
        registerPutFindingsPublicationConfigurationMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves (queries) statistical data and other information about Amazon Web Services resources that Amazon Macie monitors and analyzes.
     */
    override suspend fun searchResources(input: SearchResourcesRequest): SearchResourcesResponse {
        val op = SdkHttpOperation.build<SearchResourcesRequest, SearchResourcesResponse> {
            serializer = SearchResourcesOperationSerializer()
            deserializer = SearchResourcesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SearchResources"
            }
        }
        registerSearchResourcesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Adds or updates one or more tags (keys and values) that are associated with a classification job, custom data identifier, findings filter, or member account.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "TagResource"
            }
        }
        registerTagResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Tests a custom data identifier.
     */
    override suspend fun testCustomDataIdentifier(input: TestCustomDataIdentifierRequest): TestCustomDataIdentifierResponse {
        val op = SdkHttpOperation.build<TestCustomDataIdentifierRequest, TestCustomDataIdentifierResponse> {
            serializer = TestCustomDataIdentifierOperationSerializer()
            deserializer = TestCustomDataIdentifierOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TestCustomDataIdentifier"
            }
        }
        registerTestCustomDataIdentifierMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Removes one or more tags (keys and values) from a classification job, custom data identifier, findings filter, or member account.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "UntagResource"
            }
        }
        registerUntagResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Changes the status of a classification job.
     */
    override suspend fun updateClassificationJob(input: UpdateClassificationJobRequest): UpdateClassificationJobResponse {
        val op = SdkHttpOperation.build<UpdateClassificationJobRequest, UpdateClassificationJobResponse> {
            serializer = UpdateClassificationJobOperationSerializer()
            deserializer = UpdateClassificationJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateClassificationJob"
            }
        }
        registerUpdateClassificationJobMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the criteria and other settings for a findings filter.
     */
    override suspend fun updateFindingsFilter(input: UpdateFindingsFilterRequest): UpdateFindingsFilterResponse {
        val op = SdkHttpOperation.build<UpdateFindingsFilterRequest, UpdateFindingsFilterResponse> {
            serializer = UpdateFindingsFilterOperationSerializer()
            deserializer = UpdateFindingsFilterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateFindingsFilter"
            }
        }
        registerUpdateFindingsFilterMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Suspends or re-enables an Amazon Macie account, or updates the configuration settings for a Macie account.
     */
    override suspend fun updateMacieSession(input: UpdateMacieSessionRequest): UpdateMacieSessionResponse {
        val op = SdkHttpOperation.build<UpdateMacieSessionRequest, UpdateMacieSessionResponse> {
            serializer = UpdateMacieSessionOperationSerializer()
            deserializer = UpdateMacieSessionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateMacieSession"
            }
        }
        registerUpdateMacieSessionMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Enables an Amazon Macie administrator to suspend or re-enable a member account.
     */
    override suspend fun updateMemberSession(input: UpdateMemberSessionRequest): UpdateMemberSessionResponse {
        val op = SdkHttpOperation.build<UpdateMemberSessionRequest, UpdateMemberSessionResponse> {
            serializer = UpdateMemberSessionOperationSerializer()
            deserializer = UpdateMemberSessionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateMemberSession"
            }
        }
        registerUpdateMemberSessionMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the Amazon Macie configuration settings for an Amazon Web Services organization.
     */
    override suspend fun updateOrganizationConfiguration(input: UpdateOrganizationConfigurationRequest): UpdateOrganizationConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateOrganizationConfigurationRequest, UpdateOrganizationConfigurationResponse> {
            serializer = UpdateOrganizationConfigurationOperationSerializer()
            deserializer = UpdateOrganizationConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateOrganizationConfiguration"
            }
        }
        registerUpdateOrganizationConfigurationMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        val region = resolveRegionForOperation(ctx, config)
        ctx.putIfAbsent(AwsClientOption.Region, region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.signingRegion ?: region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
