// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2

import aws.sdk.kotlin.runtime.auth.AuthConfig
import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.endpoint.EndpointResolver
import aws.sdk.kotlin.runtime.regions.RegionConfig
import aws.sdk.kotlin.services.macie2.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine

/**
 * Amazon Macie is a fully managed data security and data privacy service that uses machine learning and pattern matching to discover and protect your sensitive data in AWS. Macie automates the discovery of sensitive data, such as PII and intellectual property, to provide you with insight into the data that your organization stores in AWS. Macie also provides an inventory of your Amazon S3 buckets, which it continually monitors for you. If Macie detects sensitive data or potential data access issues, it generates detailed findings for you to review and act upon as necessary.
 */
interface Macie2Client : SdkClient {

    override val serviceName: String
        get() = "Macie2"
    /**
     * Macie2Client's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.DslBuilder.() -> Unit = {}): Macie2Client {
            val config = Config.BuilderImpl().apply(block).build()
            return DefaultMacie2Client(config)
        }
    }

    class Config private constructor(builder: BuilderImpl): AuthConfig, HttpClientConfig, IdempotencyTokenConfig, RegionConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider? = builder.credentialsProvider
        val endpointResolver: EndpointResolver? = builder.endpointResolver
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        override val region: String? = builder.region
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        override val signingRegion: String? = builder.signingRegion

        interface FluentBuilder {
            fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder
            fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder
            fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder
            fun idempotencyTokenProvider(idempotencyTokenProvider: IdempotencyTokenProvider): FluentBuilder
            fun region(region: String): FluentBuilder
            fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder
            fun signingRegion(signingRegion: String): FluentBuilder
            fun build(): Config
        }

        interface DslBuilder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider?

            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: EndpointResolver?

            /**
             * Override the default HTTP client configuration (e.g. configure proxy behavior, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine?

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider?

            /**
             * AWS region to make requests to
             */
            var region: String?

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode

            /**
             * AWS region to be used for signing the request. This is not necessarily the same as `region`
             * in the case of global services like IAM
             */
            var signingRegion: String?

            fun build(): Config
        }

        internal class BuilderImpl() : FluentBuilder, DslBuilder {
            override var credentialsProvider: CredentialsProvider? = null
            override var endpointResolver: EndpointResolver? = null
            override var httpClientEngine: HttpClientEngine? = null
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            override var region: String? = null
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default
            override var signingRegion: String? = null

            override fun build(): Config = Config(this)
            override fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder = apply { this.credentialsProvider = credentialsProvider }
            override fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder = apply { this.endpointResolver = endpointResolver }
            override fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder = apply { this.httpClientEngine = httpClientEngine }
            override fun idempotencyTokenProvider(idempotencyTokenProvider: IdempotencyTokenProvider): FluentBuilder = apply { this.idempotencyTokenProvider = idempotencyTokenProvider }
            override fun region(region: String): FluentBuilder = apply { this.region = region }
            override fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder = apply { this.sdkLogMode = sdkLogMode }
            override fun signingRegion(signingRegion: String): FluentBuilder = apply { this.signingRegion = signingRegion }
        }
    }

    /**
     * Accepts an Amazon Macie membership invitation that was received from a specific account.
     */
    suspend fun acceptInvitation(input: AcceptInvitationRequest): AcceptInvitationResponse

    /**
     * Accepts an Amazon Macie membership invitation that was received from a specific account.
     */
    suspend fun acceptInvitation(block: AcceptInvitationRequest.DslBuilder.() -> Unit) = acceptInvitation(AcceptInvitationRequest.builder().apply(block).build())

    /**
     * Retrieves information about one or more custom data identifiers.
     */
    suspend fun batchGetCustomDataIdentifiers(input: BatchGetCustomDataIdentifiersRequest): BatchGetCustomDataIdentifiersResponse

    /**
     * Retrieves information about one or more custom data identifiers.
     */
    suspend fun batchGetCustomDataIdentifiers(block: BatchGetCustomDataIdentifiersRequest.DslBuilder.() -> Unit) = batchGetCustomDataIdentifiers(BatchGetCustomDataIdentifiersRequest.builder().apply(block).build())

    /**
     * Creates and defines the settings for a classification job.
     */
    suspend fun createClassificationJob(input: CreateClassificationJobRequest): CreateClassificationJobResponse

    /**
     * Creates and defines the settings for a classification job.
     */
    suspend fun createClassificationJob(block: CreateClassificationJobRequest.DslBuilder.() -> Unit) = createClassificationJob(CreateClassificationJobRequest.builder().apply(block).build())

    /**
     * Creates and defines the criteria and other settings for a custom data identifier.
     */
    suspend fun createCustomDataIdentifier(input: CreateCustomDataIdentifierRequest): CreateCustomDataIdentifierResponse

    /**
     * Creates and defines the criteria and other settings for a custom data identifier.
     */
    suspend fun createCustomDataIdentifier(block: CreateCustomDataIdentifierRequest.DslBuilder.() -> Unit) = createCustomDataIdentifier(CreateCustomDataIdentifierRequest.builder().apply(block).build())

    /**
     * Creates and defines the criteria and other settings for a findings filter.
     */
    suspend fun createFindingsFilter(input: CreateFindingsFilterRequest): CreateFindingsFilterResponse

    /**
     * Creates and defines the criteria and other settings for a findings filter.
     */
    suspend fun createFindingsFilter(block: CreateFindingsFilterRequest.DslBuilder.() -> Unit) = createFindingsFilter(CreateFindingsFilterRequest.builder().apply(block).build())

    /**
     * Sends an Amazon Macie membership invitation to one or more accounts.
     */
    suspend fun createInvitations(input: CreateInvitationsRequest): CreateInvitationsResponse

    /**
     * Sends an Amazon Macie membership invitation to one or more accounts.
     */
    suspend fun createInvitations(block: CreateInvitationsRequest.DslBuilder.() -> Unit) = createInvitations(CreateInvitationsRequest.builder().apply(block).build())

    /**
     * Associates an account with an Amazon Macie administrator account.
     */
    suspend fun createMember(input: CreateMemberRequest): CreateMemberResponse

    /**
     * Associates an account with an Amazon Macie administrator account.
     */
    suspend fun createMember(block: CreateMemberRequest.DslBuilder.() -> Unit) = createMember(CreateMemberRequest.builder().apply(block).build())

    /**
     * Creates sample findings.
     */
    suspend fun createSampleFindings(input: CreateSampleFindingsRequest): CreateSampleFindingsResponse

    /**
     * Creates sample findings.
     */
    suspend fun createSampleFindings(block: CreateSampleFindingsRequest.DslBuilder.() -> Unit) = createSampleFindings(CreateSampleFindingsRequest.builder().apply(block).build())

    /**
     * Declines Amazon Macie membership invitations that were received from specific accounts.
     */
    suspend fun declineInvitations(input: DeclineInvitationsRequest): DeclineInvitationsResponse

    /**
     * Declines Amazon Macie membership invitations that were received from specific accounts.
     */
    suspend fun declineInvitations(block: DeclineInvitationsRequest.DslBuilder.() -> Unit) = declineInvitations(DeclineInvitationsRequest.builder().apply(block).build())

    /**
     * Soft deletes a custom data identifier.
     */
    suspend fun deleteCustomDataIdentifier(input: DeleteCustomDataIdentifierRequest): DeleteCustomDataIdentifierResponse

    /**
     * Soft deletes a custom data identifier.
     */
    suspend fun deleteCustomDataIdentifier(block: DeleteCustomDataIdentifierRequest.DslBuilder.() -> Unit) = deleteCustomDataIdentifier(DeleteCustomDataIdentifierRequest.builder().apply(block).build())

    /**
     * Deletes a findings filter.
     */
    suspend fun deleteFindingsFilter(input: DeleteFindingsFilterRequest): DeleteFindingsFilterResponse

    /**
     * Deletes a findings filter.
     */
    suspend fun deleteFindingsFilter(block: DeleteFindingsFilterRequest.DslBuilder.() -> Unit) = deleteFindingsFilter(DeleteFindingsFilterRequest.builder().apply(block).build())

    /**
     * Deletes Amazon Macie membership invitations that were received from specific accounts.
     */
    suspend fun deleteInvitations(input: DeleteInvitationsRequest): DeleteInvitationsResponse

    /**
     * Deletes Amazon Macie membership invitations that were received from specific accounts.
     */
    suspend fun deleteInvitations(block: DeleteInvitationsRequest.DslBuilder.() -> Unit) = deleteInvitations(DeleteInvitationsRequest.builder().apply(block).build())

    /**
     * Deletes the association between an Amazon Macie administrator account and an account.
     */
    suspend fun deleteMember(input: DeleteMemberRequest): DeleteMemberResponse

    /**
     * Deletes the association between an Amazon Macie administrator account and an account.
     */
    suspend fun deleteMember(block: DeleteMemberRequest.DslBuilder.() -> Unit) = deleteMember(DeleteMemberRequest.builder().apply(block).build())

    /**
     * Retrieves (queries) statistical data and other information about one or more S3 buckets that Amazon Macie monitors and analyzes.
     */
    suspend fun describeBuckets(input: DescribeBucketsRequest): DescribeBucketsResponse

    /**
     * Retrieves (queries) statistical data and other information about one or more S3 buckets that Amazon Macie monitors and analyzes.
     */
    suspend fun describeBuckets(block: DescribeBucketsRequest.DslBuilder.() -> Unit) = describeBuckets(DescribeBucketsRequest.builder().apply(block).build())

    /**
     * Retrieves the status and settings for a classification job.
     */
    suspend fun describeClassificationJob(input: DescribeClassificationJobRequest): DescribeClassificationJobResponse

    /**
     * Retrieves the status and settings for a classification job.
     */
    suspend fun describeClassificationJob(block: DescribeClassificationJobRequest.DslBuilder.() -> Unit) = describeClassificationJob(DescribeClassificationJobRequest.builder().apply(block).build())

    /**
     * Retrieves the Amazon Macie configuration settings for an Amazon Web Services organization.
     */
    suspend fun describeOrganizationConfiguration(input: DescribeOrganizationConfigurationRequest): DescribeOrganizationConfigurationResponse

    /**
     * Retrieves the Amazon Macie configuration settings for an Amazon Web Services organization.
     */
    suspend fun describeOrganizationConfiguration(block: DescribeOrganizationConfigurationRequest.DslBuilder.() -> Unit) = describeOrganizationConfiguration(DescribeOrganizationConfigurationRequest.builder().apply(block).build())

    /**
     * Disables an Amazon Macie account and deletes Macie resources for the account.
     */
    suspend fun disableMacie(input: DisableMacieRequest): DisableMacieResponse

    /**
     * Disables an Amazon Macie account and deletes Macie resources for the account.
     */
    suspend fun disableMacie(block: DisableMacieRequest.DslBuilder.() -> Unit) = disableMacie(DisableMacieRequest.builder().apply(block).build())

    /**
     * Disables an account as the delegated Amazon Macie administrator account for an Amazon Web Services organization.
     */
    suspend fun disableOrganizationAdminAccount(input: DisableOrganizationAdminAccountRequest): DisableOrganizationAdminAccountResponse

    /**
     * Disables an account as the delegated Amazon Macie administrator account for an Amazon Web Services organization.
     */
    suspend fun disableOrganizationAdminAccount(block: DisableOrganizationAdminAccountRequest.DslBuilder.() -> Unit) = disableOrganizationAdminAccount(DisableOrganizationAdminAccountRequest.builder().apply(block).build())

    /**
     * Disassociates a member account from its Amazon Macie administrator account.
     */
    suspend fun disassociateFromAdministratorAccount(input: DisassociateFromAdministratorAccountRequest): DisassociateFromAdministratorAccountResponse

    /**
     * Disassociates a member account from its Amazon Macie administrator account.
     */
    suspend fun disassociateFromAdministratorAccount(block: DisassociateFromAdministratorAccountRequest.DslBuilder.() -> Unit) = disassociateFromAdministratorAccount(DisassociateFromAdministratorAccountRequest.builder().apply(block).build())

    /**
     * (Deprecated) Disassociates a member account from its Amazon Macie administrator account. This operation has been replaced by the <link  linkend="DisassociateFromAdministratorAccount">DisassociateFromAdministratorAccount</link> operation.
     */
    suspend fun disassociateFromMasterAccount(input: DisassociateFromMasterAccountRequest): DisassociateFromMasterAccountResponse

    /**
     * (Deprecated) Disassociates a member account from its Amazon Macie administrator account. This operation has been replaced by the <link  linkend="DisassociateFromAdministratorAccount">DisassociateFromAdministratorAccount</link> operation.
     */
    suspend fun disassociateFromMasterAccount(block: DisassociateFromMasterAccountRequest.DslBuilder.() -> Unit) = disassociateFromMasterAccount(DisassociateFromMasterAccountRequest.builder().apply(block).build())

    /**
     * Disassociates an Amazon Macie administrator account from a member account.
     */
    suspend fun disassociateMember(input: DisassociateMemberRequest): DisassociateMemberResponse

    /**
     * Disassociates an Amazon Macie administrator account from a member account.
     */
    suspend fun disassociateMember(block: DisassociateMemberRequest.DslBuilder.() -> Unit) = disassociateMember(DisassociateMemberRequest.builder().apply(block).build())

    /**
     * Enables Amazon Macie and specifies the configuration settings for a Macie account.
     */
    suspend fun enableMacie(input: EnableMacieRequest): EnableMacieResponse

    /**
     * Enables Amazon Macie and specifies the configuration settings for a Macie account.
     */
    suspend fun enableMacie(block: EnableMacieRequest.DslBuilder.() -> Unit) = enableMacie(EnableMacieRequest.builder().apply(block).build())

    /**
     * Designates an account as the delegated Amazon Macie administrator account for an Amazon Web Services organization.
     */
    suspend fun enableOrganizationAdminAccount(input: EnableOrganizationAdminAccountRequest): EnableOrganizationAdminAccountResponse

    /**
     * Designates an account as the delegated Amazon Macie administrator account for an Amazon Web Services organization.
     */
    suspend fun enableOrganizationAdminAccount(block: EnableOrganizationAdminAccountRequest.DslBuilder.() -> Unit) = enableOrganizationAdminAccount(EnableOrganizationAdminAccountRequest.builder().apply(block).build())

    /**
     * Retrieves information about the Amazon Macie administrator account for an account.
     */
    suspend fun getAdministratorAccount(input: GetAdministratorAccountRequest): GetAdministratorAccountResponse

    /**
     * Retrieves information about the Amazon Macie administrator account for an account.
     */
    suspend fun getAdministratorAccount(block: GetAdministratorAccountRequest.DslBuilder.() -> Unit) = getAdministratorAccount(GetAdministratorAccountRequest.builder().apply(block).build())

    /**
     * Retrieves (queries) aggregated statistical data for all the S3 buckets that Amazon Macie monitors and analyzes.
     */
    suspend fun getBucketStatistics(input: GetBucketStatisticsRequest): GetBucketStatisticsResponse

    /**
     * Retrieves (queries) aggregated statistical data for all the S3 buckets that Amazon Macie monitors and analyzes.
     */
    suspend fun getBucketStatistics(block: GetBucketStatisticsRequest.DslBuilder.() -> Unit) = getBucketStatistics(GetBucketStatisticsRequest.builder().apply(block).build())

    /**
     * Retrieves the configuration settings for storing data classification results.
     */
    suspend fun getClassificationExportConfiguration(input: GetClassificationExportConfigurationRequest): GetClassificationExportConfigurationResponse

    /**
     * Retrieves the configuration settings for storing data classification results.
     */
    suspend fun getClassificationExportConfiguration(block: GetClassificationExportConfigurationRequest.DslBuilder.() -> Unit) = getClassificationExportConfiguration(GetClassificationExportConfigurationRequest.builder().apply(block).build())

    /**
     * Retrieves the criteria and other settings for a custom data identifier.
     */
    suspend fun getCustomDataIdentifier(input: GetCustomDataIdentifierRequest): GetCustomDataIdentifierResponse

    /**
     * Retrieves the criteria and other settings for a custom data identifier.
     */
    suspend fun getCustomDataIdentifier(block: GetCustomDataIdentifierRequest.DslBuilder.() -> Unit) = getCustomDataIdentifier(GetCustomDataIdentifierRequest.builder().apply(block).build())

    /**
     * Retrieves (queries) aggregated statistical data about findings.
     */
    suspend fun getFindingStatistics(input: GetFindingStatisticsRequest): GetFindingStatisticsResponse

    /**
     * Retrieves (queries) aggregated statistical data about findings.
     */
    suspend fun getFindingStatistics(block: GetFindingStatisticsRequest.DslBuilder.() -> Unit) = getFindingStatistics(GetFindingStatisticsRequest.builder().apply(block).build())

    /**
     * Retrieves the details of one or more findings.
     */
    suspend fun getFindings(input: GetFindingsRequest): GetFindingsResponse

    /**
     * Retrieves the details of one or more findings.
     */
    suspend fun getFindings(block: GetFindingsRequest.DslBuilder.() -> Unit) = getFindings(GetFindingsRequest.builder().apply(block).build())

    /**
     * Retrieves the criteria and other settings for a findings filter.
     */
    suspend fun getFindingsFilter(input: GetFindingsFilterRequest): GetFindingsFilterResponse

    /**
     * Retrieves the criteria and other settings for a findings filter.
     */
    suspend fun getFindingsFilter(block: GetFindingsFilterRequest.DslBuilder.() -> Unit) = getFindingsFilter(GetFindingsFilterRequest.builder().apply(block).build())

    /**
     * Retrieves the configuration settings for publishing findings to Security Hub.
     */
    suspend fun getFindingsPublicationConfiguration(input: GetFindingsPublicationConfigurationRequest): GetFindingsPublicationConfigurationResponse

    /**
     * Retrieves the configuration settings for publishing findings to Security Hub.
     */
    suspend fun getFindingsPublicationConfiguration(block: GetFindingsPublicationConfigurationRequest.DslBuilder.() -> Unit) = getFindingsPublicationConfiguration(GetFindingsPublicationConfigurationRequest.builder().apply(block).build())

    /**
     * Retrieves the count of Amazon Macie membership invitations that were received by an account.
     */
    suspend fun getInvitationsCount(input: GetInvitationsCountRequest): GetInvitationsCountResponse

    /**
     * Retrieves the count of Amazon Macie membership invitations that were received by an account.
     */
    suspend fun getInvitationsCount(block: GetInvitationsCountRequest.DslBuilder.() -> Unit) = getInvitationsCount(GetInvitationsCountRequest.builder().apply(block).build())

    /**
     * Retrieves the current status and configuration settings for an Amazon Macie account.
     */
    suspend fun getMacieSession(input: GetMacieSessionRequest): GetMacieSessionResponse

    /**
     * Retrieves the current status and configuration settings for an Amazon Macie account.
     */
    suspend fun getMacieSession(block: GetMacieSessionRequest.DslBuilder.() -> Unit) = getMacieSession(GetMacieSessionRequest.builder().apply(block).build())

    /**
     * (Deprecated) Retrieves information about the Amazon Macie administrator account for an account. This operation has been replaced by the <link  linkend="GetAdministratorAccount">GetAdministratorAccount</link> operation.
     */
    suspend fun getMasterAccount(input: GetMasterAccountRequest): GetMasterAccountResponse

    /**
     * (Deprecated) Retrieves information about the Amazon Macie administrator account for an account. This operation has been replaced by the <link  linkend="GetAdministratorAccount">GetAdministratorAccount</link> operation.
     */
    suspend fun getMasterAccount(block: GetMasterAccountRequest.DslBuilder.() -> Unit) = getMasterAccount(GetMasterAccountRequest.builder().apply(block).build())

    /**
     * Retrieves information about an account that's associated with an Amazon Macie administrator account.
     */
    suspend fun getMember(input: GetMemberRequest): GetMemberResponse

    /**
     * Retrieves information about an account that's associated with an Amazon Macie administrator account.
     */
    suspend fun getMember(block: GetMemberRequest.DslBuilder.() -> Unit) = getMember(GetMemberRequest.builder().apply(block).build())

    /**
     * Retrieves (queries) quotas and aggregated usage data for one or more accounts.
     */
    suspend fun getUsageStatistics(input: GetUsageStatisticsRequest): GetUsageStatisticsResponse

    /**
     * Retrieves (queries) quotas and aggregated usage data for one or more accounts.
     */
    suspend fun getUsageStatistics(block: GetUsageStatisticsRequest.DslBuilder.() -> Unit) = getUsageStatistics(GetUsageStatisticsRequest.builder().apply(block).build())

    /**
     * Retrieves (queries) aggregated usage data for an account.
     */
    suspend fun getUsageTotals(input: GetUsageTotalsRequest): GetUsageTotalsResponse

    /**
     * Retrieves (queries) aggregated usage data for an account.
     */
    suspend fun getUsageTotals(block: GetUsageTotalsRequest.DslBuilder.() -> Unit) = getUsageTotals(GetUsageTotalsRequest.builder().apply(block).build())

    /**
     * Retrieves a subset of information about one or more classification jobs.
     */
    suspend fun listClassificationJobs(input: ListClassificationJobsRequest): ListClassificationJobsResponse

    /**
     * Retrieves a subset of information about one or more classification jobs.
     */
    suspend fun listClassificationJobs(block: ListClassificationJobsRequest.DslBuilder.() -> Unit) = listClassificationJobs(ListClassificationJobsRequest.builder().apply(block).build())

    /**
     * Retrieves a subset of information about all the custom data identifiers for an account.
     */
    suspend fun listCustomDataIdentifiers(input: ListCustomDataIdentifiersRequest): ListCustomDataIdentifiersResponse

    /**
     * Retrieves a subset of information about all the custom data identifiers for an account.
     */
    suspend fun listCustomDataIdentifiers(block: ListCustomDataIdentifiersRequest.DslBuilder.() -> Unit) = listCustomDataIdentifiers(ListCustomDataIdentifiersRequest.builder().apply(block).build())

    /**
     * Retrieves a subset of information about one or more findings.
     */
    suspend fun listFindings(input: ListFindingsRequest): ListFindingsResponse

    /**
     * Retrieves a subset of information about one or more findings.
     */
    suspend fun listFindings(block: ListFindingsRequest.DslBuilder.() -> Unit) = listFindings(ListFindingsRequest.builder().apply(block).build())

    /**
     * Retrieves a subset of information about all the findings filters for an account.
     */
    suspend fun listFindingsFilters(input: ListFindingsFiltersRequest): ListFindingsFiltersResponse

    /**
     * Retrieves a subset of information about all the findings filters for an account.
     */
    suspend fun listFindingsFilters(block: ListFindingsFiltersRequest.DslBuilder.() -> Unit) = listFindingsFilters(ListFindingsFiltersRequest.builder().apply(block).build())

    /**
     * Retrieves information about all the Amazon Macie membership invitations that were received by an account.
     */
    suspend fun listInvitations(input: ListInvitationsRequest): ListInvitationsResponse

    /**
     * Retrieves information about all the Amazon Macie membership invitations that were received by an account.
     */
    suspend fun listInvitations(block: ListInvitationsRequest.DslBuilder.() -> Unit) = listInvitations(ListInvitationsRequest.builder().apply(block).build())

    /**
     * Retrieves information about the accounts that are associated with an Amazon Macie administrator account.
     */
    suspend fun listMembers(input: ListMembersRequest): ListMembersResponse

    /**
     * Retrieves information about the accounts that are associated with an Amazon Macie administrator account.
     */
    suspend fun listMembers(block: ListMembersRequest.DslBuilder.() -> Unit) = listMembers(ListMembersRequest.builder().apply(block).build())

    /**
     * Retrieves information about the delegated Amazon Macie administrator account for an Amazon Web Services organization.
     */
    suspend fun listOrganizationAdminAccounts(input: ListOrganizationAdminAccountsRequest): ListOrganizationAdminAccountsResponse

    /**
     * Retrieves information about the delegated Amazon Macie administrator account for an Amazon Web Services organization.
     */
    suspend fun listOrganizationAdminAccounts(block: ListOrganizationAdminAccountsRequest.DslBuilder.() -> Unit) = listOrganizationAdminAccounts(ListOrganizationAdminAccountsRequest.builder().apply(block).build())

    /**
     * Retrieves the tags (keys and values) that are associated with a classification job, custom data identifier, findings filter, or member account.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Retrieves the tags (keys and values) that are associated with a classification job, custom data identifier, findings filter, or member account.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.DslBuilder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.builder().apply(block).build())

    /**
     * Creates or updates the configuration settings for storing data classification results.
     */
    suspend fun putClassificationExportConfiguration(input: PutClassificationExportConfigurationRequest): PutClassificationExportConfigurationResponse

    /**
     * Creates or updates the configuration settings for storing data classification results.
     */
    suspend fun putClassificationExportConfiguration(block: PutClassificationExportConfigurationRequest.DslBuilder.() -> Unit) = putClassificationExportConfiguration(PutClassificationExportConfigurationRequest.builder().apply(block).build())

    /**
     * Updates the configuration settings for publishing findings to Security Hub.
     */
    suspend fun putFindingsPublicationConfiguration(input: PutFindingsPublicationConfigurationRequest): PutFindingsPublicationConfigurationResponse

    /**
     * Updates the configuration settings for publishing findings to Security Hub.
     */
    suspend fun putFindingsPublicationConfiguration(block: PutFindingsPublicationConfigurationRequest.DslBuilder.() -> Unit) = putFindingsPublicationConfiguration(PutFindingsPublicationConfigurationRequest.builder().apply(block).build())

    /**
     * Retrieves (queries) statistical data and other information about Amazon Web Services resources that Amazon Macie monitors and analyzes.
     */
    suspend fun searchResources(input: SearchResourcesRequest): SearchResourcesResponse

    /**
     * Retrieves (queries) statistical data and other information about Amazon Web Services resources that Amazon Macie monitors and analyzes.
     */
    suspend fun searchResources(block: SearchResourcesRequest.DslBuilder.() -> Unit) = searchResources(SearchResourcesRequest.builder().apply(block).build())

    /**
     * Adds or updates one or more tags (keys and values) that are associated with a classification job, custom data identifier, findings filter, or member account.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Adds or updates one or more tags (keys and values) that are associated with a classification job, custom data identifier, findings filter, or member account.
     */
    suspend fun tagResource(block: TagResourceRequest.DslBuilder.() -> Unit) = tagResource(TagResourceRequest.builder().apply(block).build())

    /**
     * Tests a custom data identifier.
     */
    suspend fun testCustomDataIdentifier(input: TestCustomDataIdentifierRequest): TestCustomDataIdentifierResponse

    /**
     * Tests a custom data identifier.
     */
    suspend fun testCustomDataIdentifier(block: TestCustomDataIdentifierRequest.DslBuilder.() -> Unit) = testCustomDataIdentifier(TestCustomDataIdentifierRequest.builder().apply(block).build())

    /**
     * Removes one or more tags (keys and values) from a classification job, custom data identifier, findings filter, or member account.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes one or more tags (keys and values) from a classification job, custom data identifier, findings filter, or member account.
     */
    suspend fun untagResource(block: UntagResourceRequest.DslBuilder.() -> Unit) = untagResource(UntagResourceRequest.builder().apply(block).build())

    /**
     * Changes the status of a classification job.
     */
    suspend fun updateClassificationJob(input: UpdateClassificationJobRequest): UpdateClassificationJobResponse

    /**
     * Changes the status of a classification job.
     */
    suspend fun updateClassificationJob(block: UpdateClassificationJobRequest.DslBuilder.() -> Unit) = updateClassificationJob(UpdateClassificationJobRequest.builder().apply(block).build())

    /**
     * Updates the criteria and other settings for a findings filter.
     */
    suspend fun updateFindingsFilter(input: UpdateFindingsFilterRequest): UpdateFindingsFilterResponse

    /**
     * Updates the criteria and other settings for a findings filter.
     */
    suspend fun updateFindingsFilter(block: UpdateFindingsFilterRequest.DslBuilder.() -> Unit) = updateFindingsFilter(UpdateFindingsFilterRequest.builder().apply(block).build())

    /**
     * Suspends or re-enables an Amazon Macie account, or updates the configuration settings for a Macie account.
     */
    suspend fun updateMacieSession(input: UpdateMacieSessionRequest): UpdateMacieSessionResponse

    /**
     * Suspends or re-enables an Amazon Macie account, or updates the configuration settings for a Macie account.
     */
    suspend fun updateMacieSession(block: UpdateMacieSessionRequest.DslBuilder.() -> Unit) = updateMacieSession(UpdateMacieSessionRequest.builder().apply(block).build())

    /**
     * Enables an Amazon Macie administrator to suspend or re-enable a member account.
     */
    suspend fun updateMemberSession(input: UpdateMemberSessionRequest): UpdateMemberSessionResponse

    /**
     * Enables an Amazon Macie administrator to suspend or re-enable a member account.
     */
    suspend fun updateMemberSession(block: UpdateMemberSessionRequest.DslBuilder.() -> Unit) = updateMemberSession(UpdateMemberSessionRequest.builder().apply(block).build())

    /**
     * Updates the Amazon Macie configuration settings for an Amazon Web Services organization.
     */
    suspend fun updateOrganizationConfiguration(input: UpdateOrganizationConfigurationRequest): UpdateOrganizationConfigurationResponse

    /**
     * Updates the Amazon Macie configuration settings for an Amazon Web Services organization.
     */
    suspend fun updateOrganizationConfiguration(block: UpdateOrganizationConfigurationRequest.DslBuilder.() -> Unit) = updateOrganizationConfiguration(UpdateOrganizationConfigurationRequest.builder().apply(block).build())
}
