// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about the permissions settings of the bucket-level access control list (ACL) for an S3 bucket.
 */
class AccessControlList private constructor(builder: BuilderImpl) {
    /**
     * Specifies whether the ACL grants the general public with read access permissions for the bucket.
     */
    val allowsPublicReadAccess: Boolean? = builder.allowsPublicReadAccess
    /**
     * Specifies whether the ACL grants the general public with write access permissions for the bucket.
     */
    val allowsPublicWriteAccess: Boolean? = builder.allowsPublicWriteAccess

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AccessControlList = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AccessControlList(")
        append("allowsPublicReadAccess=$allowsPublicReadAccess,")
        append("allowsPublicWriteAccess=$allowsPublicWriteAccess)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowsPublicReadAccess?.hashCode() ?: 0
        result = 31 * result + (allowsPublicWriteAccess?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AccessControlList

        if (allowsPublicReadAccess != other.allowsPublicReadAccess) return false
        if (allowsPublicWriteAccess != other.allowsPublicWriteAccess) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AccessControlList = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AccessControlList
        /**
         * Specifies whether the ACL grants the general public with read access permissions for the bucket.
         */
        fun allowsPublicReadAccess(allowsPublicReadAccess: Boolean): FluentBuilder
        /**
         * Specifies whether the ACL grants the general public with write access permissions for the bucket.
         */
        fun allowsPublicWriteAccess(allowsPublicWriteAccess: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Specifies whether the ACL grants the general public with read access permissions for the bucket.
         */
        var allowsPublicReadAccess: Boolean?
        /**
         * Specifies whether the ACL grants the general public with write access permissions for the bucket.
         */
        var allowsPublicWriteAccess: Boolean?

        fun build(): AccessControlList
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var allowsPublicReadAccess: Boolean? = null
        override var allowsPublicWriteAccess: Boolean? = null

        constructor(x: AccessControlList) : this() {
            this.allowsPublicReadAccess = x.allowsPublicReadAccess
            this.allowsPublicWriteAccess = x.allowsPublicWriteAccess
        }

        override fun build(): AccessControlList = AccessControlList(this)
        override fun allowsPublicReadAccess(allowsPublicReadAccess: Boolean): FluentBuilder = apply { this.allowsPublicReadAccess = allowsPublicReadAccess }
        override fun allowsPublicWriteAccess(allowsPublicWriteAccess: Boolean): FluentBuilder = apply { this.allowsPublicWriteAccess = allowsPublicWriteAccess }
    }
}
