// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information about an API operation that an entity invoked for an affected resource.
 */
class ApiCallDetails private constructor(builder: BuilderImpl) {
    /**
     * The name of the operation that was invoked most recently and produced the finding.
     */
    val api: String? = builder.api
    /**
     * The URL of the Amazon Web Service that provides the operation, for example: s3.amazonaws.com.
     */
    val apiServiceName: String? = builder.apiServiceName
    /**
     * The first date and time, in UTC and extended ISO 8601 format, when any operation was invoked and produced the finding.
     */
    val firstSeen: Instant? = builder.firstSeen
    /**
     * The most recent date and time, in UTC and extended ISO 8601 format, when the specified operation (api) was invoked and produced the finding.
     */
    val lastSeen: Instant? = builder.lastSeen

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ApiCallDetails = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ApiCallDetails(")
        append("api=$api,")
        append("apiServiceName=$apiServiceName,")
        append("firstSeen=$firstSeen,")
        append("lastSeen=$lastSeen)")
    }

    override fun hashCode(): kotlin.Int {
        var result = api?.hashCode() ?: 0
        result = 31 * result + (apiServiceName?.hashCode() ?: 0)
        result = 31 * result + (firstSeen?.hashCode() ?: 0)
        result = 31 * result + (lastSeen?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ApiCallDetails

        if (api != other.api) return false
        if (apiServiceName != other.apiServiceName) return false
        if (firstSeen != other.firstSeen) return false
        if (lastSeen != other.lastSeen) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ApiCallDetails = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ApiCallDetails
        /**
         * The name of the operation that was invoked most recently and produced the finding.
         */
        fun api(api: String): FluentBuilder
        /**
         * The URL of the Amazon Web Service that provides the operation, for example: s3.amazonaws.com.
         */
        fun apiServiceName(apiServiceName: String): FluentBuilder
        /**
         * The first date and time, in UTC and extended ISO 8601 format, when any operation was invoked and produced the finding.
         */
        fun firstSeen(firstSeen: Instant): FluentBuilder
        /**
         * The most recent date and time, in UTC and extended ISO 8601 format, when the specified operation (api) was invoked and produced the finding.
         */
        fun lastSeen(lastSeen: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the operation that was invoked most recently and produced the finding.
         */
        var api: String?
        /**
         * The URL of the Amazon Web Service that provides the operation, for example: s3.amazonaws.com.
         */
        var apiServiceName: String?
        /**
         * The first date and time, in UTC and extended ISO 8601 format, when any operation was invoked and produced the finding.
         */
        var firstSeen: Instant?
        /**
         * The most recent date and time, in UTC and extended ISO 8601 format, when the specified operation (api) was invoked and produced the finding.
         */
        var lastSeen: Instant?

        fun build(): ApiCallDetails
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var api: String? = null
        override var apiServiceName: String? = null
        override var firstSeen: Instant? = null
        override var lastSeen: Instant? = null

        constructor(x: ApiCallDetails) : this() {
            this.api = x.api
            this.apiServiceName = x.apiServiceName
            this.firstSeen = x.firstSeen
            this.lastSeen = x.lastSeen
        }

        override fun build(): ApiCallDetails = ApiCallDetails(this)
        override fun api(api: String): FluentBuilder = apply { this.api = api }
        override fun apiServiceName(apiServiceName: String): FluentBuilder = apply { this.apiServiceName = apiServiceName }
        override fun firstSeen(firstSeen: Instant): FluentBuilder = apply { this.firstSeen = firstSeen }
        override fun lastSeen(lastSeen: Instant): FluentBuilder = apply { this.lastSeen = lastSeen }
    }
}
