// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about an Amazon Web Services account and entity that performed an action on an affected resource. The action was performed using the credentials for an Amazon Web Services account other than your own account.
 */
class AwsAccount private constructor(builder: BuilderImpl) {
    /**
     * The unique identifier for the Amazon Web Services account.
     */
    val accountId: String? = builder.accountId
    /**
     * The unique identifier for the entity that performed the action.
     */
    val principalId: String? = builder.principalId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AwsAccount = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AwsAccount(")
        append("accountId=$accountId,")
        append("principalId=$principalId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (principalId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AwsAccount

        if (accountId != other.accountId) return false
        if (principalId != other.principalId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AwsAccount = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AwsAccount
        /**
         * The unique identifier for the Amazon Web Services account.
         */
        fun accountId(accountId: String): FluentBuilder
        /**
         * The unique identifier for the entity that performed the action.
         */
        fun principalId(principalId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The unique identifier for the Amazon Web Services account.
         */
        var accountId: String?
        /**
         * The unique identifier for the entity that performed the action.
         */
        var principalId: String?

        fun build(): AwsAccount
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accountId: String? = null
        override var principalId: String? = null

        constructor(x: AwsAccount) : this() {
            this.accountId = x.accountId
            this.principalId = x.principalId
        }

        override fun build(): AwsAccount = AwsAccount(this)
        override fun accountId(accountId: String): FluentBuilder = apply { this.accountId = accountId }
        override fun principalId(principalId: String): FluentBuilder = apply { this.principalId = principalId }
    }
}
