// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information about a custom data identifier.
 */
class BatchGetCustomDataIdentifierSummary private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the custom data identifier.
     */
    val arn: String? = builder.arn
    /**
     * The date and time, in UTC and extended ISO 8601 format, when the custom data identifier was created.
     */
    val createdAt: Instant? = builder.createdAt
    /**
     * Specifies whether the custom data identifier was deleted. If you delete a custom data identifier, Amazon Macie doesn't delete it permanently. Instead, it soft deletes the identifier.
     */
    val deleted: Boolean? = builder.deleted
    /**
     * The custom description of the custom data identifier.
     */
    val description: String? = builder.description
    /**
     * The unique identifier for the custom data identifier.
     */
    val id: String? = builder.id
    /**
     * The custom name of the custom data identifier.
     */
    val name: String? = builder.name

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): BatchGetCustomDataIdentifierSummary = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("BatchGetCustomDataIdentifierSummary(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("deleted=$deleted,")
        append("description=$description,")
        append("id=$id,")
        append("name=$name)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (deleted?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as BatchGetCustomDataIdentifierSummary

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (deleted != other.deleted) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (name != other.name) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): BatchGetCustomDataIdentifierSummary = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): BatchGetCustomDataIdentifierSummary
        /**
         * The Amazon Resource Name (ARN) of the custom data identifier.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the custom data identifier was created.
         */
        fun createdAt(createdAt: Instant): FluentBuilder
        /**
         * Specifies whether the custom data identifier was deleted. If you delete a custom data identifier, Amazon Macie doesn't delete it permanently. Instead, it soft deletes the identifier.
         */
        fun deleted(deleted: Boolean): FluentBuilder
        /**
         * The custom description of the custom data identifier.
         */
        fun description(description: String): FluentBuilder
        /**
         * The unique identifier for the custom data identifier.
         */
        fun id(id: String): FluentBuilder
        /**
         * The custom name of the custom data identifier.
         */
        fun name(name: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the custom data identifier.
         */
        var arn: String?
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the custom data identifier was created.
         */
        var createdAt: Instant?
        /**
         * Specifies whether the custom data identifier was deleted. If you delete a custom data identifier, Amazon Macie doesn't delete it permanently. Instead, it soft deletes the identifier.
         */
        var deleted: Boolean?
        /**
         * The custom description of the custom data identifier.
         */
        var description: String?
        /**
         * The unique identifier for the custom data identifier.
         */
        var id: String?
        /**
         * The custom name of the custom data identifier.
         */
        var name: String?

        fun build(): BatchGetCustomDataIdentifierSummary
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var createdAt: Instant? = null
        override var deleted: Boolean? = null
        override var description: String? = null
        override var id: String? = null
        override var name: String? = null

        constructor(x: BatchGetCustomDataIdentifierSummary) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.deleted = x.deleted
            this.description = x.description
            this.id = x.id
            this.name = x.name
        }

        override fun build(): BatchGetCustomDataIdentifierSummary = BatchGetCustomDataIdentifierSummary(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun createdAt(createdAt: Instant): FluentBuilder = apply { this.createdAt = createdAt }
        override fun deleted(deleted: Boolean): FluentBuilder = apply { this.deleted = deleted }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
    }
}
