// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about the block public access settings for an S3 bucket. These settings can apply to a bucket at the account level or bucket level. For detailed information about each setting, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-control-block-public-access.html">Blocking public access to your Amazon S3 storage in the Amazon Simple Storage Service User Guide.
 */
class BlockPublicAccess private constructor(builder: BuilderImpl) {
    /**
     * Specifies whether Amazon S3 blocks public access control lists (ACLs) for the bucket and objects in the bucket.
     */
    val blockPublicAcls: Boolean? = builder.blockPublicAcls
    /**
     * Specifies whether Amazon S3 blocks public bucket policies for the bucket.
     */
    val blockPublicPolicy: Boolean? = builder.blockPublicPolicy
    /**
     * Specifies whether Amazon S3 ignores public ACLs for the bucket and objects in the bucket.
     */
    val ignorePublicAcls: Boolean? = builder.ignorePublicAcls
    /**
     * Specifies whether Amazon S3 restricts public bucket policies for the bucket.
     */
    val restrictPublicBuckets: Boolean? = builder.restrictPublicBuckets

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): BlockPublicAccess = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("BlockPublicAccess(")
        append("blockPublicAcls=$blockPublicAcls,")
        append("blockPublicPolicy=$blockPublicPolicy,")
        append("ignorePublicAcls=$ignorePublicAcls,")
        append("restrictPublicBuckets=$restrictPublicBuckets)")
    }

    override fun hashCode(): kotlin.Int {
        var result = blockPublicAcls?.hashCode() ?: 0
        result = 31 * result + (blockPublicPolicy?.hashCode() ?: 0)
        result = 31 * result + (ignorePublicAcls?.hashCode() ?: 0)
        result = 31 * result + (restrictPublicBuckets?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as BlockPublicAccess

        if (blockPublicAcls != other.blockPublicAcls) return false
        if (blockPublicPolicy != other.blockPublicPolicy) return false
        if (ignorePublicAcls != other.ignorePublicAcls) return false
        if (restrictPublicBuckets != other.restrictPublicBuckets) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): BlockPublicAccess = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): BlockPublicAccess
        /**
         * Specifies whether Amazon S3 blocks public access control lists (ACLs) for the bucket and objects in the bucket.
         */
        fun blockPublicAcls(blockPublicAcls: Boolean): FluentBuilder
        /**
         * Specifies whether Amazon S3 blocks public bucket policies for the bucket.
         */
        fun blockPublicPolicy(blockPublicPolicy: Boolean): FluentBuilder
        /**
         * Specifies whether Amazon S3 ignores public ACLs for the bucket and objects in the bucket.
         */
        fun ignorePublicAcls(ignorePublicAcls: Boolean): FluentBuilder
        /**
         * Specifies whether Amazon S3 restricts public bucket policies for the bucket.
         */
        fun restrictPublicBuckets(restrictPublicBuckets: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Specifies whether Amazon S3 blocks public access control lists (ACLs) for the bucket and objects in the bucket.
         */
        var blockPublicAcls: Boolean?
        /**
         * Specifies whether Amazon S3 blocks public bucket policies for the bucket.
         */
        var blockPublicPolicy: Boolean?
        /**
         * Specifies whether Amazon S3 ignores public ACLs for the bucket and objects in the bucket.
         */
        var ignorePublicAcls: Boolean?
        /**
         * Specifies whether Amazon S3 restricts public bucket policies for the bucket.
         */
        var restrictPublicBuckets: Boolean?

        fun build(): BlockPublicAccess
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var blockPublicAcls: Boolean? = null
        override var blockPublicPolicy: Boolean? = null
        override var ignorePublicAcls: Boolean? = null
        override var restrictPublicBuckets: Boolean? = null

        constructor(x: BlockPublicAccess) : this() {
            this.blockPublicAcls = x.blockPublicAcls
            this.blockPublicPolicy = x.blockPublicPolicy
            this.ignorePublicAcls = x.ignorePublicAcls
            this.restrictPublicBuckets = x.restrictPublicBuckets
        }

        override fun build(): BlockPublicAccess = BlockPublicAccess(this)
        override fun blockPublicAcls(blockPublicAcls: Boolean): FluentBuilder = apply { this.blockPublicAcls = blockPublicAcls }
        override fun blockPublicPolicy(blockPublicPolicy: Boolean): FluentBuilder = apply { this.blockPublicPolicy = blockPublicPolicy }
        override fun ignorePublicAcls(ignorePublicAcls: Boolean): FluentBuilder = apply { this.ignorePublicAcls = ignorePublicAcls }
        override fun restrictPublicBuckets(restrictPublicBuckets: Boolean): FluentBuilder = apply { this.restrictPublicBuckets = restrictPublicBuckets }
    }
}
