// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about the number of S3 buckets that are publicly accessible based on a combination of permissions settings for each bucket.
 */
class BucketCountByEffectivePermission private constructor(builder: BuilderImpl) {
    /**
     * The total number of buckets that allow the general public to have read or write access to the bucket.
     */
    val publiclyAccessible: Long? = builder.publiclyAccessible
    /**
     * The total number of buckets that allow the general public to have read access to the bucket.
     */
    val publiclyReadable: Long? = builder.publiclyReadable
    /**
     * The total number of buckets that allow the general public to have write access to the bucket.
     */
    val publiclyWritable: Long? = builder.publiclyWritable
    /**
     * The total number of buckets that Amazon Macie wasn't able to evaluate permissions settings for. Macie can't determine whether these buckets are publicly accessible.
     */
    val unknown: Long? = builder.unknown

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): BucketCountByEffectivePermission = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("BucketCountByEffectivePermission(")
        append("publiclyAccessible=$publiclyAccessible,")
        append("publiclyReadable=$publiclyReadable,")
        append("publiclyWritable=$publiclyWritable,")
        append("unknown=$unknown)")
    }

    override fun hashCode(): kotlin.Int {
        var result = publiclyAccessible?.hashCode() ?: 0
        result = 31 * result + (publiclyReadable?.hashCode() ?: 0)
        result = 31 * result + (publiclyWritable?.hashCode() ?: 0)
        result = 31 * result + (unknown?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as BucketCountByEffectivePermission

        if (publiclyAccessible != other.publiclyAccessible) return false
        if (publiclyReadable != other.publiclyReadable) return false
        if (publiclyWritable != other.publiclyWritable) return false
        if (unknown != other.unknown) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): BucketCountByEffectivePermission = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): BucketCountByEffectivePermission
        /**
         * The total number of buckets that allow the general public to have read or write access to the bucket.
         */
        fun publiclyAccessible(publiclyAccessible: Long): FluentBuilder
        /**
         * The total number of buckets that allow the general public to have read access to the bucket.
         */
        fun publiclyReadable(publiclyReadable: Long): FluentBuilder
        /**
         * The total number of buckets that allow the general public to have write access to the bucket.
         */
        fun publiclyWritable(publiclyWritable: Long): FluentBuilder
        /**
         * The total number of buckets that Amazon Macie wasn't able to evaluate permissions settings for. Macie can't determine whether these buckets are publicly accessible.
         */
        fun unknown(unknown: Long): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The total number of buckets that allow the general public to have read or write access to the bucket.
         */
        var publiclyAccessible: Long?
        /**
         * The total number of buckets that allow the general public to have read access to the bucket.
         */
        var publiclyReadable: Long?
        /**
         * The total number of buckets that allow the general public to have write access to the bucket.
         */
        var publiclyWritable: Long?
        /**
         * The total number of buckets that Amazon Macie wasn't able to evaluate permissions settings for. Macie can't determine whether these buckets are publicly accessible.
         */
        var unknown: Long?

        fun build(): BucketCountByEffectivePermission
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var publiclyAccessible: Long? = null
        override var publiclyReadable: Long? = null
        override var publiclyWritable: Long? = null
        override var unknown: Long? = null

        constructor(x: BucketCountByEffectivePermission) : this() {
            this.publiclyAccessible = x.publiclyAccessible
            this.publiclyReadable = x.publiclyReadable
            this.publiclyWritable = x.publiclyWritable
            this.unknown = x.unknown
        }

        override fun build(): BucketCountByEffectivePermission = BucketCountByEffectivePermission(this)
        override fun publiclyAccessible(publiclyAccessible: Long): FluentBuilder = apply { this.publiclyAccessible = publiclyAccessible }
        override fun publiclyReadable(publiclyReadable: Long): FluentBuilder = apply { this.publiclyReadable = publiclyReadable }
        override fun publiclyWritable(publiclyWritable: Long): FluentBuilder = apply { this.publiclyWritable = publiclyWritable }
        override fun unknown(unknown: Long): FluentBuilder = apply { this.unknown = unknown }
    }
}
