// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about the number of S3 buckets that use certain types of server-side encryption by default or don't encrypt new objects by default. For detailed information about these settings, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucket-encryption.html">Setting default server-side encryption behavior for Amazon S3 buckets in the Amazon Simple Storage Service User Guide.
 */
class BucketCountByEncryptionType private constructor(builder: BuilderImpl) {
    /**
     * The total number of buckets that use an Key Management Service (KMS) customer master key (CMK) to encrypt new objects by default. These buckets use Amazon Web Services managed KMS encryption (AWS-KMS) or customer managed KMS encryption (SSE-KMS) by default.
     */
    val kmsManaged: Long? = builder.kmsManaged
    /**
     * The total number of buckets that use an Amazon S3 managed key to encrypt new objects by default. These buckets use Amazon S3 managed encryption (SSE-S3) by default.
     */
    val s3Managed: Long? = builder.s3Managed
    /**
     * The total number of buckets that don't encrypt new objects by default. Default encryption is disabled for these buckets.
     */
    val unencrypted: Long? = builder.unencrypted
    /**
     * The total number of buckets that Amazon Macie doesn't have current encryption metadata for. Macie can't provide current data about the default encryption settings for these buckets.
     */
    val unknown: Long? = builder.unknown

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): BucketCountByEncryptionType = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("BucketCountByEncryptionType(")
        append("kmsManaged=$kmsManaged,")
        append("s3Managed=$s3Managed,")
        append("unencrypted=$unencrypted,")
        append("unknown=$unknown)")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsManaged?.hashCode() ?: 0
        result = 31 * result + (s3Managed?.hashCode() ?: 0)
        result = 31 * result + (unencrypted?.hashCode() ?: 0)
        result = 31 * result + (unknown?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as BucketCountByEncryptionType

        if (kmsManaged != other.kmsManaged) return false
        if (s3Managed != other.s3Managed) return false
        if (unencrypted != other.unencrypted) return false
        if (unknown != other.unknown) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): BucketCountByEncryptionType = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): BucketCountByEncryptionType
        /**
         * The total number of buckets that use an Key Management Service (KMS) customer master key (CMK) to encrypt new objects by default. These buckets use Amazon Web Services managed KMS encryption (AWS-KMS) or customer managed KMS encryption (SSE-KMS) by default.
         */
        fun kmsManaged(kmsManaged: Long): FluentBuilder
        /**
         * The total number of buckets that use an Amazon S3 managed key to encrypt new objects by default. These buckets use Amazon S3 managed encryption (SSE-S3) by default.
         */
        fun s3Managed(s3Managed: Long): FluentBuilder
        /**
         * The total number of buckets that don't encrypt new objects by default. Default encryption is disabled for these buckets.
         */
        fun unencrypted(unencrypted: Long): FluentBuilder
        /**
         * The total number of buckets that Amazon Macie doesn't have current encryption metadata for. Macie can't provide current data about the default encryption settings for these buckets.
         */
        fun unknown(unknown: Long): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The total number of buckets that use an Key Management Service (KMS) customer master key (CMK) to encrypt new objects by default. These buckets use Amazon Web Services managed KMS encryption (AWS-KMS) or customer managed KMS encryption (SSE-KMS) by default.
         */
        var kmsManaged: Long?
        /**
         * The total number of buckets that use an Amazon S3 managed key to encrypt new objects by default. These buckets use Amazon S3 managed encryption (SSE-S3) by default.
         */
        var s3Managed: Long?
        /**
         * The total number of buckets that don't encrypt new objects by default. Default encryption is disabled for these buckets.
         */
        var unencrypted: Long?
        /**
         * The total number of buckets that Amazon Macie doesn't have current encryption metadata for. Macie can't provide current data about the default encryption settings for these buckets.
         */
        var unknown: Long?

        fun build(): BucketCountByEncryptionType
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var kmsManaged: Long? = null
        override var s3Managed: Long? = null
        override var unencrypted: Long? = null
        override var unknown: Long? = null

        constructor(x: BucketCountByEncryptionType) : this() {
            this.kmsManaged = x.kmsManaged
            this.s3Managed = x.s3Managed
            this.unencrypted = x.unencrypted
            this.unknown = x.unknown
        }

        override fun build(): BucketCountByEncryptionType = BucketCountByEncryptionType(this)
        override fun kmsManaged(kmsManaged: Long): FluentBuilder = apply { this.kmsManaged = kmsManaged }
        override fun s3Managed(s3Managed: Long): FluentBuilder = apply { this.s3Managed = s3Managed }
        override fun unencrypted(unencrypted: Long): FluentBuilder = apply { this.unencrypted = unencrypted }
        override fun unknown(unknown: Long): FluentBuilder = apply { this.unknown = unknown }
    }
}
