// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about the number of S3 buckets that are or aren't shared with other Amazon Web Services accounts.
 */
class BucketCountBySharedAccessType private constructor(builder: BuilderImpl) {
    /**
     * The total number of buckets that are shared with an Amazon Web Services account that isn't part of the same Amazon Macie organization.
     */
    val external: Long? = builder.external
    /**
     * The total number of buckets that are shared with an Amazon Web Services account that's part of the same Amazon Macie organization.
     */
    val internal: Long? = builder.internal
    /**
     * The total number of buckets that aren't shared with other Amazon Web Services accounts.
     */
    val notShared: Long? = builder.notShared
    /**
     * The total number of buckets that Amazon Macie wasn't able to evaluate shared access settings for. Macie can't determine whether these buckets are shared with other Amazon Web Services accounts.
     */
    val unknown: Long? = builder.unknown

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): BucketCountBySharedAccessType = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("BucketCountBySharedAccessType(")
        append("external=$external,")
        append("internal=$internal,")
        append("notShared=$notShared,")
        append("unknown=$unknown)")
    }

    override fun hashCode(): kotlin.Int {
        var result = external?.hashCode() ?: 0
        result = 31 * result + (internal?.hashCode() ?: 0)
        result = 31 * result + (notShared?.hashCode() ?: 0)
        result = 31 * result + (unknown?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as BucketCountBySharedAccessType

        if (external != other.external) return false
        if (internal != other.internal) return false
        if (notShared != other.notShared) return false
        if (unknown != other.unknown) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): BucketCountBySharedAccessType = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): BucketCountBySharedAccessType
        /**
         * The total number of buckets that are shared with an Amazon Web Services account that isn't part of the same Amazon Macie organization.
         */
        fun external(external: Long): FluentBuilder
        /**
         * The total number of buckets that are shared with an Amazon Web Services account that's part of the same Amazon Macie organization.
         */
        fun internal(internal: Long): FluentBuilder
        /**
         * The total number of buckets that aren't shared with other Amazon Web Services accounts.
         */
        fun notShared(notShared: Long): FluentBuilder
        /**
         * The total number of buckets that Amazon Macie wasn't able to evaluate shared access settings for. Macie can't determine whether these buckets are shared with other Amazon Web Services accounts.
         */
        fun unknown(unknown: Long): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The total number of buckets that are shared with an Amazon Web Services account that isn't part of the same Amazon Macie organization.
         */
        var external: Long?
        /**
         * The total number of buckets that are shared with an Amazon Web Services account that's part of the same Amazon Macie organization.
         */
        var internal: Long?
        /**
         * The total number of buckets that aren't shared with other Amazon Web Services accounts.
         */
        var notShared: Long?
        /**
         * The total number of buckets that Amazon Macie wasn't able to evaluate shared access settings for. Macie can't determine whether these buckets are shared with other Amazon Web Services accounts.
         */
        var unknown: Long?

        fun build(): BucketCountBySharedAccessType
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var external: Long? = null
        override var internal: Long? = null
        override var notShared: Long? = null
        override var unknown: Long? = null

        constructor(x: BucketCountBySharedAccessType) : this() {
            this.external = x.external
            this.internal = x.internal
            this.notShared = x.notShared
            this.unknown = x.unknown
        }

        override fun build(): BucketCountBySharedAccessType = BucketCountBySharedAccessType(this)
        override fun external(external: Long): FluentBuilder = apply { this.external = external }
        override fun internal(internal: Long): FluentBuilder = apply { this.internal = internal }
        override fun notShared(notShared: Long): FluentBuilder = apply { this.notShared = notShared }
        override fun unknown(unknown: Long): FluentBuilder = apply { this.unknown = unknown }
    }
}
