// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about the number of S3 buckets whose bucket policies do or don't require server-side encryption of objects when objects are uploaded to the buckets.
 */
class BucketCountPolicyAllowsUnencryptedObjectUploads private constructor(builder: BuilderImpl) {
    /**
     * The total number of buckets that don't have a bucket policy or have a bucket policy that doesn't require server-side encryption of new objects. If a bucket policy exists, the policy doesn't require PutObject requests to include the x-amz-server-side-encryption header and it doesn't require the value for that header to be AES256 or aws:kms.
     */
    val allowsUnencryptedObjectUploads: Long? = builder.allowsUnencryptedObjectUploads
    /**
     * The total number of buckets whose bucket policies require server-side encryption of new objects. PutObject requests for these buckets must include the x-amz-server-side-encryption header and the value for that header must be AES256 or aws:kms.
     */
    val deniesUnencryptedObjectUploads: Long? = builder.deniesUnencryptedObjectUploads
    /**
     * The total number of buckets that Amazon Macie wasn't able to evaluate server-side encryption requirements for. Macie can't determine whether the bucket policies for these buckets require server-side encryption of new objects.
     */
    val unknown: Long? = builder.unknown

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): BucketCountPolicyAllowsUnencryptedObjectUploads = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("BucketCountPolicyAllowsUnencryptedObjectUploads(")
        append("allowsUnencryptedObjectUploads=$allowsUnencryptedObjectUploads,")
        append("deniesUnencryptedObjectUploads=$deniesUnencryptedObjectUploads,")
        append("unknown=$unknown)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowsUnencryptedObjectUploads?.hashCode() ?: 0
        result = 31 * result + (deniesUnencryptedObjectUploads?.hashCode() ?: 0)
        result = 31 * result + (unknown?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as BucketCountPolicyAllowsUnencryptedObjectUploads

        if (allowsUnencryptedObjectUploads != other.allowsUnencryptedObjectUploads) return false
        if (deniesUnencryptedObjectUploads != other.deniesUnencryptedObjectUploads) return false
        if (unknown != other.unknown) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): BucketCountPolicyAllowsUnencryptedObjectUploads = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): BucketCountPolicyAllowsUnencryptedObjectUploads
        /**
         * The total number of buckets that don't have a bucket policy or have a bucket policy that doesn't require server-side encryption of new objects. If a bucket policy exists, the policy doesn't require PutObject requests to include the x-amz-server-side-encryption header and it doesn't require the value for that header to be AES256 or aws:kms.
         */
        fun allowsUnencryptedObjectUploads(allowsUnencryptedObjectUploads: Long): FluentBuilder
        /**
         * The total number of buckets whose bucket policies require server-side encryption of new objects. PutObject requests for these buckets must include the x-amz-server-side-encryption header and the value for that header must be AES256 or aws:kms.
         */
        fun deniesUnencryptedObjectUploads(deniesUnencryptedObjectUploads: Long): FluentBuilder
        /**
         * The total number of buckets that Amazon Macie wasn't able to evaluate server-side encryption requirements for. Macie can't determine whether the bucket policies for these buckets require server-side encryption of new objects.
         */
        fun unknown(unknown: Long): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The total number of buckets that don't have a bucket policy or have a bucket policy that doesn't require server-side encryption of new objects. If a bucket policy exists, the policy doesn't require PutObject requests to include the x-amz-server-side-encryption header and it doesn't require the value for that header to be AES256 or aws:kms.
         */
        var allowsUnencryptedObjectUploads: Long?
        /**
         * The total number of buckets whose bucket policies require server-side encryption of new objects. PutObject requests for these buckets must include the x-amz-server-side-encryption header and the value for that header must be AES256 or aws:kms.
         */
        var deniesUnencryptedObjectUploads: Long?
        /**
         * The total number of buckets that Amazon Macie wasn't able to evaluate server-side encryption requirements for. Macie can't determine whether the bucket policies for these buckets require server-side encryption of new objects.
         */
        var unknown: Long?

        fun build(): BucketCountPolicyAllowsUnencryptedObjectUploads
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var allowsUnencryptedObjectUploads: Long? = null
        override var deniesUnencryptedObjectUploads: Long? = null
        override var unknown: Long? = null

        constructor(x: BucketCountPolicyAllowsUnencryptedObjectUploads) : this() {
            this.allowsUnencryptedObjectUploads = x.allowsUnencryptedObjectUploads
            this.deniesUnencryptedObjectUploads = x.deniesUnencryptedObjectUploads
            this.unknown = x.unknown
        }

        override fun build(): BucketCountPolicyAllowsUnencryptedObjectUploads = BucketCountPolicyAllowsUnencryptedObjectUploads(this)
        override fun allowsUnencryptedObjectUploads(allowsUnencryptedObjectUploads: Long): FluentBuilder = apply { this.allowsUnencryptedObjectUploads = allowsUnencryptedObjectUploads }
        override fun deniesUnencryptedObjectUploads(deniesUnencryptedObjectUploads: Long): FluentBuilder = apply { this.deniesUnencryptedObjectUploads = deniesUnencryptedObjectUploads }
        override fun unknown(unknown: Long): FluentBuilder = apply { this.unknown = unknown }
    }
}
