// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about the bucket-level permissions settings for an S3 bucket.
 */
class BucketLevelPermissions private constructor(builder: BuilderImpl) {
    /**
     * The permissions settings of the access control list (ACL) for the bucket. This value is null if an ACL hasn't been defined for the bucket.
     */
    val accessControlList: AccessControlList? = builder.accessControlList
    /**
     * The block public access settings for the bucket.
     */
    val blockPublicAccess: BlockPublicAccess? = builder.blockPublicAccess
    /**
     * The permissions settings of the bucket policy for the bucket. This value is null if a bucket policy hasn't been defined for the bucket.
     */
    val bucketPolicy: BucketPolicy? = builder.bucketPolicy

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): BucketLevelPermissions = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("BucketLevelPermissions(")
        append("accessControlList=$accessControlList,")
        append("blockPublicAccess=$blockPublicAccess,")
        append("bucketPolicy=$bucketPolicy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessControlList?.hashCode() ?: 0
        result = 31 * result + (blockPublicAccess?.hashCode() ?: 0)
        result = 31 * result + (bucketPolicy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as BucketLevelPermissions

        if (accessControlList != other.accessControlList) return false
        if (blockPublicAccess != other.blockPublicAccess) return false
        if (bucketPolicy != other.bucketPolicy) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): BucketLevelPermissions = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): BucketLevelPermissions
        /**
         * The permissions settings of the access control list (ACL) for the bucket. This value is null if an ACL hasn't been defined for the bucket.
         */
        fun accessControlList(accessControlList: AccessControlList): FluentBuilder
        /**
         * The block public access settings for the bucket.
         */
        fun blockPublicAccess(blockPublicAccess: BlockPublicAccess): FluentBuilder
        /**
         * The permissions settings of the bucket policy for the bucket. This value is null if a bucket policy hasn't been defined for the bucket.
         */
        fun bucketPolicy(bucketPolicy: BucketPolicy): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The permissions settings of the access control list (ACL) for the bucket. This value is null if an ACL hasn't been defined for the bucket.
         */
        var accessControlList: AccessControlList?
        /**
         * The block public access settings for the bucket.
         */
        var blockPublicAccess: BlockPublicAccess?
        /**
         * The permissions settings of the bucket policy for the bucket. This value is null if a bucket policy hasn't been defined for the bucket.
         */
        var bucketPolicy: BucketPolicy?

        fun build(): BucketLevelPermissions
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.AccessControlList] inside the given [block]
         */
        fun accessControlList(block: AccessControlList.DslBuilder.() -> kotlin.Unit) {
            this.accessControlList = AccessControlList.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.BlockPublicAccess] inside the given [block]
         */
        fun blockPublicAccess(block: BlockPublicAccess.DslBuilder.() -> kotlin.Unit) {
            this.blockPublicAccess = BlockPublicAccess.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.BucketPolicy] inside the given [block]
         */
        fun bucketPolicy(block: BucketPolicy.DslBuilder.() -> kotlin.Unit) {
            this.bucketPolicy = BucketPolicy.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accessControlList: AccessControlList? = null
        override var blockPublicAccess: BlockPublicAccess? = null
        override var bucketPolicy: BucketPolicy? = null

        constructor(x: BucketLevelPermissions) : this() {
            this.accessControlList = x.accessControlList
            this.blockPublicAccess = x.blockPublicAccess
            this.bucketPolicy = x.bucketPolicy
        }

        override fun build(): BucketLevelPermissions = BucketLevelPermissions(this)
        override fun accessControlList(accessControlList: AccessControlList): FluentBuilder = apply { this.accessControlList = accessControlList }
        override fun blockPublicAccess(blockPublicAccess: BlockPublicAccess): FluentBuilder = apply { this.blockPublicAccess = blockPublicAccess }
        override fun bucketPolicy(bucketPolicy: BucketPolicy): FluentBuilder = apply { this.bucketPolicy = bucketPolicy }
    }
}
