// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information about an S3 bucket that Amazon Macie monitors and analyzes.
 */
class BucketMetadata private constructor(builder: BuilderImpl) {
    /**
     * The unique identifier for the Amazon Web Services account that owns the bucket.
     */
    val accountId: String? = builder.accountId
    /**
     * Specifies whether the bucket policy for the bucket requires server-side encryption of objects when objects are uploaded to the bucket. Possible values are: FALSE - The bucket policy requires server-side encryption of new objects. PutObject requests must include the x-amz-server-side-encryption header and the value for that header must be AES256 or aws:kms. TRUE - The bucket doesn't have a bucket policy or it has a bucket policy that doesn't require server-side encryption of new objects. If a bucket policy exists, it doesn't require PutObject requests to include the x-amz-server-side-encryption header and it doesn't require the value for that header to be AES256 or aws:kms. UNKNOWN - Amazon Macie can't determine whether the bucket policy requires server-side encryption of new objects.
     */
    val allowsUnencryptedObjectUploads: AllowsUnencryptedObjectUploads? = builder.allowsUnencryptedObjectUploads
    /**
     * The Amazon Resource Name (ARN) of the bucket.
     */
    val bucketArn: String? = builder.bucketArn
    /**
     * The date and time, in UTC and extended ISO 8601 format, when the bucket was created.
     */
    val bucketCreatedAt: Instant? = builder.bucketCreatedAt
    /**
     * The name of the bucket.
     */
    val bucketName: String? = builder.bucketName
    /**
     * The total number of objects that Amazon Macie can analyze in the bucket. These objects use a supported storage class and have a file name extension for a supported file or storage format.
     */
    val classifiableObjectCount: Long? = builder.classifiableObjectCount
    /**
     * The total storage size, in bytes, of the objects that Amazon Macie can analyze in the bucket. These objects use a supported storage class and have a file name extension for a supported file or storage format. If versioning is enabled for the bucket, Macie calculates this value based on the size of the latest version of each applicable object in the bucket. This value doesn't reflect the storage size of all versions of each applicable object in the bucket.
     */
    val classifiableSizeInBytes: Long? = builder.classifiableSizeInBytes
    /**
     * Specifies whether any one-time or recurring classification jobs are configured to analyze data in the bucket, and, if so, the details of the job that ran most recently.
     */
    val jobDetails: JobDetails? = builder.jobDetails
    /**
     * The date and time, in UTC and extended ISO 8601 format, when Amazon Macie most recently retrieved both bucket and object metadata from Amazon S3 for the bucket.
     */
    val lastUpdated: Instant? = builder.lastUpdated
    /**
     * The total number of objects in the bucket.
     */
    val objectCount: Long? = builder.objectCount
    /**
     * The total number of objects that are in the bucket, grouped by server-side encryption type. This includes a grouping that reports the total number of objects that aren't encrypted or use client-side encryption.
     */
    val objectCountByEncryptionType: ObjectCountByEncryptionType? = builder.objectCountByEncryptionType
    /**
     * Specifies whether the bucket is publicly accessible due to the combination of permissions settings that apply to the bucket, and provides information about those settings.
     */
    val publicAccess: BucketPublicAccess? = builder.publicAccess
    /**
     * The Amazon Web Services Region that hosts the bucket.
     */
    val region: String? = builder.region
    /**
     * Specifies whether the bucket is configured to replicate one or more objects to buckets for other Amazon Web Services accounts and, if so, which accounts.
     */
    val replicationDetails: ReplicationDetails? = builder.replicationDetails
    /**
     * Specifies whether the bucket encrypts new objects by default and, if so, the type of server-side encryption that's used.
     */
    val serverSideEncryption: BucketServerSideEncryption? = builder.serverSideEncryption
    /**
     * Specifies whether the bucket is shared with another Amazon Web Services account. Possible values are: EXTERNAL - The bucket is shared with an Amazon Web Services account that isn't part of the same Amazon Macie organization. INTERNAL - The bucket is shared with an Amazon Web Services account that's part of the same Amazon Macie organization. NOT_SHARED - The bucket isn't shared with other Amazon Web Services accounts. UNKNOWN - Amazon Macie wasn't able to evaluate the shared access settings for the bucket.
     */
    val sharedAccess: SharedAccess? = builder.sharedAccess
    /**
     * The total storage size, in bytes, of the bucket. If versioning is enabled for the bucket, Amazon Macie calculates this value based on the size of the latest version of each object in the bucket. This value doesn't reflect the storage size of all versions of each object in the bucket.
     */
    val sizeInBytes: Long? = builder.sizeInBytes
    /**
     * The total storage size, in bytes, of the objects that are compressed (.gz, .gzip, .zip) files in the bucket. If versioning is enabled for the bucket, Macie calculates this value based on the size of the latest version of each applicable object in the bucket. This value doesn't reflect the storage size of all versions of each applicable object in the bucket.
     */
    val sizeInBytesCompressed: Long? = builder.sizeInBytesCompressed
    /**
     * An array that specifies the tags (keys and values) that are associated with the bucket.
     */
    val tags: List<KeyValuePair>? = builder.tags
    /**
     * The total number of objects that Amazon Macie can't analyze in the bucket. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.
     */
    val unclassifiableObjectCount: ObjectLevelStatistics? = builder.unclassifiableObjectCount
    /**
     * The total storage size, in bytes, of the objects that Amazon Macie can't analyze in the bucket. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.
     */
    val unclassifiableObjectSizeInBytes: ObjectLevelStatistics? = builder.unclassifiableObjectSizeInBytes
    /**
     * Specifies whether versioning is enabled for the bucket.
     */
    val versioning: Boolean? = builder.versioning

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): BucketMetadata = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("BucketMetadata(")
        append("accountId=$accountId,")
        append("allowsUnencryptedObjectUploads=$allowsUnencryptedObjectUploads,")
        append("bucketArn=$bucketArn,")
        append("bucketCreatedAt=$bucketCreatedAt,")
        append("bucketName=$bucketName,")
        append("classifiableObjectCount=$classifiableObjectCount,")
        append("classifiableSizeInBytes=$classifiableSizeInBytes,")
        append("jobDetails=$jobDetails,")
        append("lastUpdated=$lastUpdated,")
        append("objectCount=$objectCount,")
        append("objectCountByEncryptionType=$objectCountByEncryptionType,")
        append("publicAccess=$publicAccess,")
        append("region=$region,")
        append("replicationDetails=$replicationDetails,")
        append("serverSideEncryption=$serverSideEncryption,")
        append("sharedAccess=$sharedAccess,")
        append("sizeInBytes=$sizeInBytes,")
        append("sizeInBytesCompressed=$sizeInBytesCompressed,")
        append("tags=$tags,")
        append("unclassifiableObjectCount=$unclassifiableObjectCount,")
        append("unclassifiableObjectSizeInBytes=$unclassifiableObjectSizeInBytes,")
        append("versioning=$versioning)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (allowsUnencryptedObjectUploads?.hashCode() ?: 0)
        result = 31 * result + (bucketArn?.hashCode() ?: 0)
        result = 31 * result + (bucketCreatedAt?.hashCode() ?: 0)
        result = 31 * result + (bucketName?.hashCode() ?: 0)
        result = 31 * result + (classifiableObjectCount?.hashCode() ?: 0)
        result = 31 * result + (classifiableSizeInBytes?.hashCode() ?: 0)
        result = 31 * result + (jobDetails?.hashCode() ?: 0)
        result = 31 * result + (lastUpdated?.hashCode() ?: 0)
        result = 31 * result + (objectCount?.hashCode() ?: 0)
        result = 31 * result + (objectCountByEncryptionType?.hashCode() ?: 0)
        result = 31 * result + (publicAccess?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (replicationDetails?.hashCode() ?: 0)
        result = 31 * result + (serverSideEncryption?.hashCode() ?: 0)
        result = 31 * result + (sharedAccess?.hashCode() ?: 0)
        result = 31 * result + (sizeInBytes?.hashCode() ?: 0)
        result = 31 * result + (sizeInBytesCompressed?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (unclassifiableObjectCount?.hashCode() ?: 0)
        result = 31 * result + (unclassifiableObjectSizeInBytes?.hashCode() ?: 0)
        result = 31 * result + (versioning?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as BucketMetadata

        if (accountId != other.accountId) return false
        if (allowsUnencryptedObjectUploads != other.allowsUnencryptedObjectUploads) return false
        if (bucketArn != other.bucketArn) return false
        if (bucketCreatedAt != other.bucketCreatedAt) return false
        if (bucketName != other.bucketName) return false
        if (classifiableObjectCount != other.classifiableObjectCount) return false
        if (classifiableSizeInBytes != other.classifiableSizeInBytes) return false
        if (jobDetails != other.jobDetails) return false
        if (lastUpdated != other.lastUpdated) return false
        if (objectCount != other.objectCount) return false
        if (objectCountByEncryptionType != other.objectCountByEncryptionType) return false
        if (publicAccess != other.publicAccess) return false
        if (region != other.region) return false
        if (replicationDetails != other.replicationDetails) return false
        if (serverSideEncryption != other.serverSideEncryption) return false
        if (sharedAccess != other.sharedAccess) return false
        if (sizeInBytes != other.sizeInBytes) return false
        if (sizeInBytesCompressed != other.sizeInBytesCompressed) return false
        if (tags != other.tags) return false
        if (unclassifiableObjectCount != other.unclassifiableObjectCount) return false
        if (unclassifiableObjectSizeInBytes != other.unclassifiableObjectSizeInBytes) return false
        if (versioning != other.versioning) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): BucketMetadata = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): BucketMetadata
        /**
         * The unique identifier for the Amazon Web Services account that owns the bucket.
         */
        fun accountId(accountId: String): FluentBuilder
        /**
         * Specifies whether the bucket policy for the bucket requires server-side encryption of objects when objects are uploaded to the bucket. Possible values are: FALSE - The bucket policy requires server-side encryption of new objects. PutObject requests must include the x-amz-server-side-encryption header and the value for that header must be AES256 or aws:kms. TRUE - The bucket doesn't have a bucket policy or it has a bucket policy that doesn't require server-side encryption of new objects. If a bucket policy exists, it doesn't require PutObject requests to include the x-amz-server-side-encryption header and it doesn't require the value for that header to be AES256 or aws:kms. UNKNOWN - Amazon Macie can't determine whether the bucket policy requires server-side encryption of new objects.
         */
        fun allowsUnencryptedObjectUploads(allowsUnencryptedObjectUploads: AllowsUnencryptedObjectUploads): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the bucket.
         */
        fun bucketArn(bucketArn: String): FluentBuilder
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the bucket was created.
         */
        fun bucketCreatedAt(bucketCreatedAt: Instant): FluentBuilder
        /**
         * The name of the bucket.
         */
        fun bucketName(bucketName: String): FluentBuilder
        /**
         * The total number of objects that Amazon Macie can analyze in the bucket. These objects use a supported storage class and have a file name extension for a supported file or storage format.
         */
        fun classifiableObjectCount(classifiableObjectCount: Long): FluentBuilder
        /**
         * The total storage size, in bytes, of the objects that Amazon Macie can analyze in the bucket. These objects use a supported storage class and have a file name extension for a supported file or storage format. If versioning is enabled for the bucket, Macie calculates this value based on the size of the latest version of each applicable object in the bucket. This value doesn't reflect the storage size of all versions of each applicable object in the bucket.
         */
        fun classifiableSizeInBytes(classifiableSizeInBytes: Long): FluentBuilder
        /**
         * Specifies whether any one-time or recurring classification jobs are configured to analyze data in the bucket, and, if so, the details of the job that ran most recently.
         */
        fun jobDetails(jobDetails: JobDetails): FluentBuilder
        /**
         * The date and time, in UTC and extended ISO 8601 format, when Amazon Macie most recently retrieved both bucket and object metadata from Amazon S3 for the bucket.
         */
        fun lastUpdated(lastUpdated: Instant): FluentBuilder
        /**
         * The total number of objects in the bucket.
         */
        fun objectCount(objectCount: Long): FluentBuilder
        /**
         * The total number of objects that are in the bucket, grouped by server-side encryption type. This includes a grouping that reports the total number of objects that aren't encrypted or use client-side encryption.
         */
        fun objectCountByEncryptionType(objectCountByEncryptionType: ObjectCountByEncryptionType): FluentBuilder
        /**
         * Specifies whether the bucket is publicly accessible due to the combination of permissions settings that apply to the bucket, and provides information about those settings.
         */
        fun publicAccess(publicAccess: BucketPublicAccess): FluentBuilder
        /**
         * The Amazon Web Services Region that hosts the bucket.
         */
        fun region(region: String): FluentBuilder
        /**
         * Specifies whether the bucket is configured to replicate one or more objects to buckets for other Amazon Web Services accounts and, if so, which accounts.
         */
        fun replicationDetails(replicationDetails: ReplicationDetails): FluentBuilder
        /**
         * Specifies whether the bucket encrypts new objects by default and, if so, the type of server-side encryption that's used.
         */
        fun serverSideEncryption(serverSideEncryption: BucketServerSideEncryption): FluentBuilder
        /**
         * Specifies whether the bucket is shared with another Amazon Web Services account. Possible values are: EXTERNAL - The bucket is shared with an Amazon Web Services account that isn't part of the same Amazon Macie organization. INTERNAL - The bucket is shared with an Amazon Web Services account that's part of the same Amazon Macie organization. NOT_SHARED - The bucket isn't shared with other Amazon Web Services accounts. UNKNOWN - Amazon Macie wasn't able to evaluate the shared access settings for the bucket.
         */
        fun sharedAccess(sharedAccess: SharedAccess): FluentBuilder
        /**
         * The total storage size, in bytes, of the bucket. If versioning is enabled for the bucket, Amazon Macie calculates this value based on the size of the latest version of each object in the bucket. This value doesn't reflect the storage size of all versions of each object in the bucket.
         */
        fun sizeInBytes(sizeInBytes: Long): FluentBuilder
        /**
         * The total storage size, in bytes, of the objects that are compressed (.gz, .gzip, .zip) files in the bucket. If versioning is enabled for the bucket, Macie calculates this value based on the size of the latest version of each applicable object in the bucket. This value doesn't reflect the storage size of all versions of each applicable object in the bucket.
         */
        fun sizeInBytesCompressed(sizeInBytesCompressed: Long): FluentBuilder
        /**
         * An array that specifies the tags (keys and values) that are associated with the bucket.
         */
        fun tags(tags: List<KeyValuePair>): FluentBuilder
        /**
         * The total number of objects that Amazon Macie can't analyze in the bucket. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.
         */
        fun unclassifiableObjectCount(unclassifiableObjectCount: ObjectLevelStatistics): FluentBuilder
        /**
         * The total storage size, in bytes, of the objects that Amazon Macie can't analyze in the bucket. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.
         */
        fun unclassifiableObjectSizeInBytes(unclassifiableObjectSizeInBytes: ObjectLevelStatistics): FluentBuilder
        /**
         * Specifies whether versioning is enabled for the bucket.
         */
        fun versioning(versioning: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The unique identifier for the Amazon Web Services account that owns the bucket.
         */
        var accountId: String?
        /**
         * Specifies whether the bucket policy for the bucket requires server-side encryption of objects when objects are uploaded to the bucket. Possible values are: FALSE - The bucket policy requires server-side encryption of new objects. PutObject requests must include the x-amz-server-side-encryption header and the value for that header must be AES256 or aws:kms. TRUE - The bucket doesn't have a bucket policy or it has a bucket policy that doesn't require server-side encryption of new objects. If a bucket policy exists, it doesn't require PutObject requests to include the x-amz-server-side-encryption header and it doesn't require the value for that header to be AES256 or aws:kms. UNKNOWN - Amazon Macie can't determine whether the bucket policy requires server-side encryption of new objects.
         */
        var allowsUnencryptedObjectUploads: AllowsUnencryptedObjectUploads?
        /**
         * The Amazon Resource Name (ARN) of the bucket.
         */
        var bucketArn: String?
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the bucket was created.
         */
        var bucketCreatedAt: Instant?
        /**
         * The name of the bucket.
         */
        var bucketName: String?
        /**
         * The total number of objects that Amazon Macie can analyze in the bucket. These objects use a supported storage class and have a file name extension for a supported file or storage format.
         */
        var classifiableObjectCount: Long?
        /**
         * The total storage size, in bytes, of the objects that Amazon Macie can analyze in the bucket. These objects use a supported storage class and have a file name extension for a supported file or storage format. If versioning is enabled for the bucket, Macie calculates this value based on the size of the latest version of each applicable object in the bucket. This value doesn't reflect the storage size of all versions of each applicable object in the bucket.
         */
        var classifiableSizeInBytes: Long?
        /**
         * Specifies whether any one-time or recurring classification jobs are configured to analyze data in the bucket, and, if so, the details of the job that ran most recently.
         */
        var jobDetails: JobDetails?
        /**
         * The date and time, in UTC and extended ISO 8601 format, when Amazon Macie most recently retrieved both bucket and object metadata from Amazon S3 for the bucket.
         */
        var lastUpdated: Instant?
        /**
         * The total number of objects in the bucket.
         */
        var objectCount: Long?
        /**
         * The total number of objects that are in the bucket, grouped by server-side encryption type. This includes a grouping that reports the total number of objects that aren't encrypted or use client-side encryption.
         */
        var objectCountByEncryptionType: ObjectCountByEncryptionType?
        /**
         * Specifies whether the bucket is publicly accessible due to the combination of permissions settings that apply to the bucket, and provides information about those settings.
         */
        var publicAccess: BucketPublicAccess?
        /**
         * The Amazon Web Services Region that hosts the bucket.
         */
        var region: String?
        /**
         * Specifies whether the bucket is configured to replicate one or more objects to buckets for other Amazon Web Services accounts and, if so, which accounts.
         */
        var replicationDetails: ReplicationDetails?
        /**
         * Specifies whether the bucket encrypts new objects by default and, if so, the type of server-side encryption that's used.
         */
        var serverSideEncryption: BucketServerSideEncryption?
        /**
         * Specifies whether the bucket is shared with another Amazon Web Services account. Possible values are: EXTERNAL - The bucket is shared with an Amazon Web Services account that isn't part of the same Amazon Macie organization. INTERNAL - The bucket is shared with an Amazon Web Services account that's part of the same Amazon Macie organization. NOT_SHARED - The bucket isn't shared with other Amazon Web Services accounts. UNKNOWN - Amazon Macie wasn't able to evaluate the shared access settings for the bucket.
         */
        var sharedAccess: SharedAccess?
        /**
         * The total storage size, in bytes, of the bucket. If versioning is enabled for the bucket, Amazon Macie calculates this value based on the size of the latest version of each object in the bucket. This value doesn't reflect the storage size of all versions of each object in the bucket.
         */
        var sizeInBytes: Long?
        /**
         * The total storage size, in bytes, of the objects that are compressed (.gz, .gzip, .zip) files in the bucket. If versioning is enabled for the bucket, Macie calculates this value based on the size of the latest version of each applicable object in the bucket. This value doesn't reflect the storage size of all versions of each applicable object in the bucket.
         */
        var sizeInBytesCompressed: Long?
        /**
         * An array that specifies the tags (keys and values) that are associated with the bucket.
         */
        var tags: List<KeyValuePair>?
        /**
         * The total number of objects that Amazon Macie can't analyze in the bucket. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.
         */
        var unclassifiableObjectCount: ObjectLevelStatistics?
        /**
         * The total storage size, in bytes, of the objects that Amazon Macie can't analyze in the bucket. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.
         */
        var unclassifiableObjectSizeInBytes: ObjectLevelStatistics?
        /**
         * Specifies whether versioning is enabled for the bucket.
         */
        var versioning: Boolean?

        fun build(): BucketMetadata
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.JobDetails] inside the given [block]
         */
        fun jobDetails(block: JobDetails.DslBuilder.() -> kotlin.Unit) {
            this.jobDetails = JobDetails.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.ObjectCountByEncryptionType] inside the given [block]
         */
        fun objectCountByEncryptionType(block: ObjectCountByEncryptionType.DslBuilder.() -> kotlin.Unit) {
            this.objectCountByEncryptionType = ObjectCountByEncryptionType.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.BucketPublicAccess] inside the given [block]
         */
        fun publicAccess(block: BucketPublicAccess.DslBuilder.() -> kotlin.Unit) {
            this.publicAccess = BucketPublicAccess.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.ReplicationDetails] inside the given [block]
         */
        fun replicationDetails(block: ReplicationDetails.DslBuilder.() -> kotlin.Unit) {
            this.replicationDetails = ReplicationDetails.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.BucketServerSideEncryption] inside the given [block]
         */
        fun serverSideEncryption(block: BucketServerSideEncryption.DslBuilder.() -> kotlin.Unit) {
            this.serverSideEncryption = BucketServerSideEncryption.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics] inside the given [block]
         */
        fun unclassifiableObjectCount(block: ObjectLevelStatistics.DslBuilder.() -> kotlin.Unit) {
            this.unclassifiableObjectCount = ObjectLevelStatistics.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics] inside the given [block]
         */
        fun unclassifiableObjectSizeInBytes(block: ObjectLevelStatistics.DslBuilder.() -> kotlin.Unit) {
            this.unclassifiableObjectSizeInBytes = ObjectLevelStatistics.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accountId: String? = null
        override var allowsUnencryptedObjectUploads: AllowsUnencryptedObjectUploads? = null
        override var bucketArn: String? = null
        override var bucketCreatedAt: Instant? = null
        override var bucketName: String? = null
        override var classifiableObjectCount: Long? = null
        override var classifiableSizeInBytes: Long? = null
        override var jobDetails: JobDetails? = null
        override var lastUpdated: Instant? = null
        override var objectCount: Long? = null
        override var objectCountByEncryptionType: ObjectCountByEncryptionType? = null
        override var publicAccess: BucketPublicAccess? = null
        override var region: String? = null
        override var replicationDetails: ReplicationDetails? = null
        override var serverSideEncryption: BucketServerSideEncryption? = null
        override var sharedAccess: SharedAccess? = null
        override var sizeInBytes: Long? = null
        override var sizeInBytesCompressed: Long? = null
        override var tags: List<KeyValuePair>? = null
        override var unclassifiableObjectCount: ObjectLevelStatistics? = null
        override var unclassifiableObjectSizeInBytes: ObjectLevelStatistics? = null
        override var versioning: Boolean? = null

        constructor(x: BucketMetadata) : this() {
            this.accountId = x.accountId
            this.allowsUnencryptedObjectUploads = x.allowsUnencryptedObjectUploads
            this.bucketArn = x.bucketArn
            this.bucketCreatedAt = x.bucketCreatedAt
            this.bucketName = x.bucketName
            this.classifiableObjectCount = x.classifiableObjectCount
            this.classifiableSizeInBytes = x.classifiableSizeInBytes
            this.jobDetails = x.jobDetails
            this.lastUpdated = x.lastUpdated
            this.objectCount = x.objectCount
            this.objectCountByEncryptionType = x.objectCountByEncryptionType
            this.publicAccess = x.publicAccess
            this.region = x.region
            this.replicationDetails = x.replicationDetails
            this.serverSideEncryption = x.serverSideEncryption
            this.sharedAccess = x.sharedAccess
            this.sizeInBytes = x.sizeInBytes
            this.sizeInBytesCompressed = x.sizeInBytesCompressed
            this.tags = x.tags
            this.unclassifiableObjectCount = x.unclassifiableObjectCount
            this.unclassifiableObjectSizeInBytes = x.unclassifiableObjectSizeInBytes
            this.versioning = x.versioning
        }

        override fun build(): BucketMetadata = BucketMetadata(this)
        override fun accountId(accountId: String): FluentBuilder = apply { this.accountId = accountId }
        override fun allowsUnencryptedObjectUploads(allowsUnencryptedObjectUploads: AllowsUnencryptedObjectUploads): FluentBuilder = apply { this.allowsUnencryptedObjectUploads = allowsUnencryptedObjectUploads }
        override fun bucketArn(bucketArn: String): FluentBuilder = apply { this.bucketArn = bucketArn }
        override fun bucketCreatedAt(bucketCreatedAt: Instant): FluentBuilder = apply { this.bucketCreatedAt = bucketCreatedAt }
        override fun bucketName(bucketName: String): FluentBuilder = apply { this.bucketName = bucketName }
        override fun classifiableObjectCount(classifiableObjectCount: Long): FluentBuilder = apply { this.classifiableObjectCount = classifiableObjectCount }
        override fun classifiableSizeInBytes(classifiableSizeInBytes: Long): FluentBuilder = apply { this.classifiableSizeInBytes = classifiableSizeInBytes }
        override fun jobDetails(jobDetails: JobDetails): FluentBuilder = apply { this.jobDetails = jobDetails }
        override fun lastUpdated(lastUpdated: Instant): FluentBuilder = apply { this.lastUpdated = lastUpdated }
        override fun objectCount(objectCount: Long): FluentBuilder = apply { this.objectCount = objectCount }
        override fun objectCountByEncryptionType(objectCountByEncryptionType: ObjectCountByEncryptionType): FluentBuilder = apply { this.objectCountByEncryptionType = objectCountByEncryptionType }
        override fun publicAccess(publicAccess: BucketPublicAccess): FluentBuilder = apply { this.publicAccess = publicAccess }
        override fun region(region: String): FluentBuilder = apply { this.region = region }
        override fun replicationDetails(replicationDetails: ReplicationDetails): FluentBuilder = apply { this.replicationDetails = replicationDetails }
        override fun serverSideEncryption(serverSideEncryption: BucketServerSideEncryption): FluentBuilder = apply { this.serverSideEncryption = serverSideEncryption }
        override fun sharedAccess(sharedAccess: SharedAccess): FluentBuilder = apply { this.sharedAccess = sharedAccess }
        override fun sizeInBytes(sizeInBytes: Long): FluentBuilder = apply { this.sizeInBytes = sizeInBytes }
        override fun sizeInBytesCompressed(sizeInBytesCompressed: Long): FluentBuilder = apply { this.sizeInBytesCompressed = sizeInBytesCompressed }
        override fun tags(tags: List<KeyValuePair>): FluentBuilder = apply { this.tags = tags }
        override fun unclassifiableObjectCount(unclassifiableObjectCount: ObjectLevelStatistics): FluentBuilder = apply { this.unclassifiableObjectCount = unclassifiableObjectCount }
        override fun unclassifiableObjectSizeInBytes(unclassifiableObjectSizeInBytes: ObjectLevelStatistics): FluentBuilder = apply { this.unclassifiableObjectSizeInBytes = unclassifiableObjectSizeInBytes }
        override fun versioning(versioning: Boolean): FluentBuilder = apply { this.versioning = versioning }
    }
}
